#!/bin/sh
#
# File: lsihba.sh
# 
# Requirements:
#
# sas2ircu and sas3ircu must be in the directory the script is run from
# you can download both of these utilities from the Avago website
# 
# smartmontools must be installed.  This is public domain software that is
# available via apt-get (Ubuntu/Debian), yum (RHEL/CentOS), etc.
#
# Release History
# 12/18/2015 - Initial Test Version Release
# 1/18/2016 - 45Drives edits fixed bug where drives with existing partitons would not report SMART data correctly. Changed output to read "Slot: #" rather than "Port: #"
#



if [ $# = 0 ]; then
 echo ""
 echo "Usage: ./lsihba.sh <sas2|sas3>"
 echo ""
 exit
fi

if [ $1 = "sas2" ] || [ $1 = "sas3" ]; then
 echo ""
else
 echo ""
 echo "Usage: ./lsihba.sh <sas2|sas3>"
 echo ""
 exit
fi

echo ""

sasgen=$1

echo Setting up...
mkdir lsi_script_workspace
tar xf utils

for a in $(./$sasgen\ircu 2>&1 list | awk {'print $1'} | grep -w [0-9])
 do
    b=`./$sasgen\ircu $a display | grep -i -m 1 slot | awk -F: {'print $2'}`
    echo ""
    echo ""
    echo "HBA in Pci Slot$b:"
    echo ""
    for c in $(./$sasgen\ircu $a display | grep 'Slot #' | awk -F: {'print $2'})
     do
      echo $c >> lsi_script_workspace/C$a\_slots.txt
     done
    
    for d in $(./$sasgen\ircu $a display | grep 'Serial No' | awk -F: {'print $2'})
     do
        echo $d >> lsi_script_workspace/C$a\_sernos.txt
     done

    for dd in $(./$sasgen\ircu $a display | grep -i protocol | awk -F: {'print $2'})
     do
        echo $dd >> lsi_script_workspace/C$a\_protocols.txt
     done

    for ddd in $(./$sasgen\ircu $a display | grep -i guid | awk -F: {'print $2'})
     do
        echo $ddd >> lsi_script_workspace/C$a\_guids.txt
     done

    
    e=1
    f=`wc -l lsi_script_workspace/C\$a\_slots.txt | awk {'print $1'}`
    while [ $e -le $f ]
     do
      g=`sed -n {$e\p} lsi_script_workspace/C\$a\_slots.txt`
      h=`sed -n {$e\p} lsi_script_workspace/C\$a\_sernos.txt`
      hh=`sed -n {$e\p} lsi_script_workspace/C\$a\_protocols.txt`
      hhh=`sed -n {$e\p} lsi_script_workspace/C\$a\_guids.txt`

      # Changed "Port" to "Slot" to agree with our current identification process
      echo Slot $g
      echo Serial Number $h
      echo Protocol $hh
      i=`echo $h | cut -c 4-25`
      j=`ls -l /dev/disk/by-id | grep $i | awk -F/ {'print $3'}`
      if [ $hh = "SAS" ]; then
         j=`ls -l /dev/disk/by-id | grep wwn | grep $hhh | awk -F/ {'print $3'}`
      fi
      # 45 Drives edit -- Added the below line
      rawdev=`echo $j | awk {'print $1;'}`
      # If the drive had partitions on it the smart data part would fail.
      # By taking the raw out "j" then scraping the first word this can be avoided
      # The varible rawdev will always be the first device in the varible j, therefore the raw device name    
      echo sd device: $rawdev
      k=`smartctl -H /dev/$rawdev | grep -i health | awk -F: {'print $2'}`
      if [ $k = "OK" ]; then
         k="PASSED"
      fi
      echo SMART Health Check Result: $k
      echo ""
      e=`expr $e + 1`
     done
 done

echo ""
echo Cleaning up...
rm -rf lsi_script_workspace
rm sas*ircu
echo ""
