#!/bin/bash
#BK@45D

### Output Location
log=/etc/support.log

###FUNCTIONS
freebsd()
{
	echo -e "\n45Drives Techincal Support Log Dump\n" >> $log

	echo -e "**********HARDWARE***********\n----------------------------\n" >> $log

	##CPU
	echo -e "CPU:\n" >> $log 
	dmidecode -t 4 >> $log
	echo -e "\n---------------------------\n" >> $log

	##Mobo
	echo -e "Motherboard:\n" >> $log
	dmidecode -t baseboard >> $log
	echo -e "\n---------------------------\n" >> $log

	##Chassis
	echo -e "Chassis:\n" >> $log
	dmidecode -t chassis >> $log
	echo -e "\n---------------------------\n" >> $log

	##Physical PCI Slot Information
	echo -e "PCI Slots(PHY):\n" >> $log
	dmidecode -t slot >> $log
	echo -e "\n---------------------------\n" >> $log
	
	##Devices in PCI slots
	echo -e "PCI Devices:\n" >> $log
	pciconf -lv >> $log
	echo -e "\n---------------------------\n" >> $log

	##Disks attached to system
	echo -e "Disks:\n" >> $log
	camcontrol devlist >> $log
	echo -e "\n---------------------------\n" >> $log


	echo -e "**********SOFTWARE***********\n----------------------------\n" >> $log
	## OS and driver info
	echo -e "OS:\n" >> $log
	uname -a >> $log
	echo -e "\n---------------------------\n" >> $log

	version=$(uname -r | cut -d- -f1)
	if [ "$version" != "10.3" ]; then
		echo -e "Driver Version:\n" >> $log
		echo -e "\nUser is running FreeBSD kernel $version\n" >> $log
		dmesg | grep -i r750 >> $log		
		echo -e "\nNote that if this returns an empty string incorrect drivers are installed\n" >> $log
		echo -e "\n---------------------------\n" >> $log 
	else
		echo -e "Driver Version:\n" >> $log
		echo -e "System is running FreeBSD kernel $version, therefore correct drivers are installed" >> $log
		echo -e "\n---------------------------\n" >> $log 
	fi

	##List all zpools present
	echo -e "Zpool List:\n" >> $log
	zpool list >> $log
	echo -e "\n---------------------------\n" >> $log

	##Detailed Status of each zpool
	echo -e "Zpool Status:\n" >> $log
	zpool status -v >> $log
	echo -e "\n---------------------------\n" >> $log

	##GEOM label to device name
	echo -e "GEOM->DevName:\n" >> $log
	glabel status >> $log
	echo -e "\n---------------------------\n" >> $log

	##Network Interfaces

	echo -e "Network Interfaces:\n" >> $log
	ifconfig >> $log
	echo -e "\n---------------------------\n" >> $log
}

centos()
{
	echo -e "\n45Drives Techincal Support Log Dump\n" >> $log

	echo -e "**********HARDWARE***********\n----------------------------\n" >> $log

	##CPU
	echo -e "CPU:\n" >> $log 
	dmidecode -t 4 >> $log
	echo -e "\n---------------------------\n" >> $log

	##Mobo
	echo -e "Motherboard:\n" >> $log
	dmidecode -t baseboard >> $log
	echo -e "\n---------------------------\n" >> $log

	##Chassis
	echo -e "Chassis:\n" >> $log
	dmidecode -t chassis >> $log
	echo -e "\n---------------------------\n" >> $log

	##Physical PCI Slot Information
	echo -e "PCI Slots(PHY):\n" >> $log
	dmidecode -t slot >> $log
	echo -e "\n---------------------------\n" >> $log

	##Devices in PCI slots
	echo -e "PCI Devices:\n" >> $log
	lspci >> $log
	echo -e "\n---------------------------\n" >> $log

	##Disks attached to system
	echo -e "Disks:\n" >> $log
	lsblk -o name,label,uuid,size,model >> $log
	echo -e "\n---------------------------\n" >> $log


	echo -e "**********SOFTWARE***********\n----------------------------\n" >> $log
	
	## OS and driver info
	echo -e "OS:\n" >> $log
	uname -a >> $log
	echo -e "\n---------------------------\n" >> $log

	echo -e "Driver Version:\n" >> $log
	dmesg | grep -i r750 >> $log
	echo -e "\nIf this the only thing here, R750 drivers are NOT installed\n" >> $log
	echo -e "\n---------------------------\n" >> $log 
	

	##Check to see if ZFS is present
	zfscheck=$(lsmod | grep zfs | awk 'NR==1{print $1;}')
	if [ ! -z $zfscheck ]; then
		##List all zpools present
		echo -e "Zpool List:\n" >> $log
		zpool list -v >> $log
		echo -e "\n---------------------------\n" >> $log
	fi

	# Check LVM and check mdadm
	echo -e "LVM: " >> $log
	lvmcheck=$(rpm -qa lvm2)
	if [ ! -z $lvmcheck ];then	
		echo -e "\nPhysical Volumes:\n" >> $log
		pvs -vq >> $log
		echo -e "\nVolume Groups:\n" >> $log
		vgs -vq >> $log 
		echo -e "\nLogical Volumes:\n" >> $log
		lvs -vq >> $log
	fi
	echo -e "\n---------------------------\n" >> $log

	echo -e "mdadm: \n" >> $log
	mdadmcheck=$(rpm -qa mdadm)
	if [ ! -z $mdadmcheck ];then 
	#then grab relevant info
		echo -e "mdadm Devices:\n" >> $log
		cat /proc/mdstat >> $log
	        echo -e "\nmdadm configuration:\n" >> $log

		# Check for the existence of mdadm.conf and if true write to log.		
		if [ -e "/etc/mdadm.conf" ];then
			cat /etc/mdadm.conf >> $log
		elif [ -e "/etc/mdadm/mdadm.conf" ];then
			cat /etc/mdam/mdadm.conf >> $log
		else
			echo -e "\nNo mdadm RAID configuration file is present\n" >> $log
		fi
	else
		echo -e "mdadm not installed" >> $log
	fi
	echo -e "\n---------------------------\n" >> $log
	
	##Network Interfaces

	echo -e "\nNetwork Interfaces:\n" >> $log
	ifconfig >> $log
	echo -e "\n---------------------------\n" >> $log	
}

ubuntu()
{
	echo -e "\n45Drives Techincal Support Log Dump\n" >> $log

	echo -e "**********HARDWARE***********\n----------------------------\n" >> $log

	##CPU
	echo -e "CPU:\n" >> $log 
	dmidecode -t 4 >> $log
	echo -e "\n---------------------------\n" >> $log

	##Mobo
	echo -e "Motherboard:\n" >> $log
	dmidecode -t baseboard >> $log
	echo -e "\n---------------------------\n" >> $log

	##Chassis
	echo -e "Chassis:\n" >> $log
	dmidecode -t chassis >> $log
	echo -e "\n---------------------------\n" >> $log

	##Physical PCI Slot Information
	echo -e "PCI Slots(PHY):\n" >> $log
	dmidecode -t slot >> $log
	echo -e "\n---------------------------\n" >> $log

	##Devices in PCI slots
	echo -e "PCI Devices:\n" >> $log
	lspci >> $log
	echo -e "\n---------------------------\n" >> $log

	##Disks attached to system
	echo -e "Disks:\n" >> $log
	lsblk -o name,label,uuid,size,model >> $log
	echo -e "\n---------------------------\n" >> $log

	echo -e "**********SOFTWARE***********\n----------------------------\n" >> $log
	
	## OS and driver info
	echo -e "OS:\n" >> $log
	uname -a >> $log
	echo -e "\n---------------------------\n" >> $log

	echo -e "Driver Version:\n" >> $log
	dmesg | grep -i r750 >> $log
	echo -e "\nIf this the only thing here, R750 drivers are NOT installed\n" >> $log
	echo -e "\n---------------------------\n" >> $log 
	

	##Check to see if ZFS is present
	zfscheck=$(lsmod | grep zfs | awk 'NR==1{print $1;}')
	if [ ! -z $zfscheck ]; then
		##List all zpools present
		echo -e "Zpool List:\n" >> $log
		zpool list -v >> $log
		echo -e "\n---------------------------\n" >> $log
	fi

	### Check LVM and check mdadm
	lvm_check=$(dpkg --get-selections | grep lvm2 | grep -v lib | awk '{print $2;}')
	mdadmcheck=$(dpkg --get-selections | grep mdadm | awk '{print $2;}')
	echo -e "LVM: \n" >> $log
	if [ "$lvm_check" == "install" ]; then
		echo -e "Physical Volumes:\n" >> $log
		pvs -vq &>> $log
		echo -e "Volume Groups:\n" >> $log
		vgs -vq &>> $log 
		echo -e "Logical Volumes:\n" >> $log
		lvs -vq &>> $log
	elif [ "$lvm_check" == "deinstall" ]; then
		echo -e "No lvm2 packages installed\n" >> $log
	else
		echo -e "No lvm2 packages downloaded\n" >> $log
	fi
	echo -e "\n---------------------------\n" >> $log
	
	echo -e "mdadm: \n" >> $log
	if [ "$mdadmcheck" == "install" ]; then
		echo -e "mdadm Devices:\n" >> $log
		cat /proc/mdstat >> $log
	        echo -e "mdadm configuration:\n" >> $log

		# Check for the existence of mdadm.conf and if true write to log.		
		if [ -e "/etc/mdadm.conf" ]; then
			cat /etc/mdadm.conf >> $log
		elif [ -e "/etc/mdadm/mdadm.conf" ]; then
			cat /etc/mdadm/mdadm.conf >> $log
		else
			echo -e "\n No mdadm RAID configuration file is present\n"
		fi
	elif [ "$mdadmcheck" == "deinstall" ]; then
		echo -e "No mdadm packages installed\n" >> $log
	else
		echo -e "No mdadm packages downloaded\n" >> $log
	fi
	echo -e "\n---------------------------\n" >> $log

	##Network Interfaces

	echo -e "\nNetwork Interfaces:\n" >> $log
	ifconfig >> $log
	echo -e "\n---------------------------\n" >> $log
}

debian()
{
	echo -e "\n45Drives Techincal Support Log Dump\n" >> $log

	echo -e "**********HARDWARE***********\n----------------------------\n" >> $log

	##CPU
	echo -e "CPU:\n" >> $log 
	dmidecode -t 4 >> $log
	echo -e "\n---------------------------\n" >> $log

	##Mobo
	echo -e "Motherboard:\n" >> $log
	dmidecode -t baseboard >> $log
	echo -e "\n---------------------------\n" >> $log

	##Chassis
	echo -e "Chassis:\n" >> $log
	dmidecode -t chassis >> $log
	echo -e "\n---------------------------\n" >> $log

	##Physical PCI Slot Information
	echo -e "PCI Slots(PHY):\n" >> $log
	dmidecode -t slot >> $log
	echo -e "\n---------------------------\n" >> $log

	##Devices in PCI slots
	echo -e "PCI Devices:\n" >> $log
	lspci >> $log
	echo -e "\n---------------------------\n" >> $log

	##Disks attached to system
	echo -e "Disks:\n" >> $log
	lsblk -o name,label,uuid,size,model >> $log
	echo -e "\n---------------------------\n" >> $log

	echo -e "**********SOFTWARE***********\n----------------------------\n" >> $log
	
	## OS and driver info
	echo -e "OS:\n" >> $log
	uname -a >> $log
	echo -e "\n---------------------------\n" >> $log

	echo -e "R750 Driver Version:\n" >> $log
	dmesg | grep -i r750 >> $log
	echo -e "\nIf this the only thing here, R750 drivers are NOT installed\n" >> $log
	echo -e "\n---------------------------\n" >> $log 
	

	##Check to see if ZFS is present
	zfscheck=$(lsmod | grep zfs | awk 'NR==1{print $1;}')
	if [ ! -z $zfscheck ]; then
		##List all zpools present
		echo -e "Zpool List:\n" >> $log
		zpool list -v >> $log
		echo -e "\n---------------------------\n" >> $log
	fi

	### Check LVM and check mdadm
	lvm_check=$(dpkg --get-selections | grep lvm2 | grep -v lib | awk '{print $2;}')
	mdadmcheck=$(dpkg --get-selections | grep mdadm | awk '{print $2;}')
	echo -e "LVM: \n" >> $log
	if [ "$lvm_check" == "install" ]; then
		echo -e "Physical Volumes:\n" >> $log
		pvs -vq &>> $log
		echo -e "\nVolume Groups:\n" >> $log
		vgs -vq &>> $log 
		echo -e "\nLogical Volumes:\n" >> $log
		lvs -vq &>> $log
	elif [ "$lvm_check" == "deinstall" ]; then
		echo -e "No lvm2 packages installed\n" >> $log
	else
		echo -e "No lvm2 packages downloaded\n" >> $log
	fi
	echo -e "\n---------------------------\n" >> $log
	
	echo -e "mdadm: \n" >> $log
	if [ "$mdadmcheck" == "install" ]; then
		echo -e "mdadm Devices:\n" >> $log
		cat /proc/mdstat >> $log
	        echo -e "mdadm configuration:\n" >> $log

		# Check for the existence of mdadm.conf and if true write to log.		
		if [ -e "/etc/mdadm.conf" ]; then
			cat /etc/mdadm.conf >> $log
		elif [ -e "/etc/mdadm/mdadm.conf" ]; then
			cat /etc/mdadm/mdadm.conf >> $log
		else
			echo -e "\n No mdadm RAID configuration file is present\n"
		fi
	elif [ "$mdadmcheck" == "deinstall" ]; then
		echo -e "No mdadm packages installed\n" >> $log
	else
		echo -e "No mdadm packages downloaded\n" >> $log
	fi
	echo -e "\n---------------------------\n" >> $log

	##Network Interfaces

	echo -e "Network Interfaces:\n" >> $log
	ifconfig >> $log
	echo -e "\n---------------------------\n" >> $log	

}

####MAIN

#Check if root user
if [[ $EUID -ne 0 ]];then
	echo -e "\nYou must be root user\n"
	exit 1
fi

# Check for log, if there, delete and remake with the date
if [ -e "$log" ]
then
	rm -f $log
fi
touch $log
date >> $log

#Check OS
OS=$(uname -s)
kernel=$(uname -r)
echo -e "\nOperating Sytem: $OS\nKernel Version: $kernel\n" >> $log

if [ "$OS" == "Linux" ]; then	
	if [ -e "/etc/centos-release" ]; then
		distro=$(cat /etc/centos-release | awk {'print $1'})
	elif [ -e "/etc/os-release" ]; then
		distro=$(grep -o '".*"' /etc/os-release | sed 's/"//g' | awk 'NR==1{print $1;}')
	else 
		distro=CentOS
	fi

	if [ "$distro" == "CentOS" ]; then
		echo -e "Distribution: $distro\n" >> $log
		version=$(cat /etc/centos-release | sed 's/ Linux//g' | awk {'print $3'})
		echo -e "Version: $version\n" >>$log
		centos
	elif [ "$distro" == "Ubuntu" ]; then
		echo -e "Distribution: $distro\n" >> $log
		version=$(grep -o '".*"' /etc/os-release | sed 's/"//g' | awk NR==2 )
		echo -e "Version: $version\n" >> $log
		ubuntu
	elif [ "$distro" == "Debian" ]; then
		echo -e "Distribution: $distro\n" >> $log
		version=$(cat /etc/debian_version)
		echo -e "Version: $version\n" >> $log
		debian
	else
		echo "Unsupported Linux Distro"
	fi
elif [ "$OS" == "FreeBSD" ]; then
	freebsd 
else
	echo "Unsupported OS"
	exit 1
fi

echo -e "\nIf you are seeing this message only, then this script has completed properly\n\nPlease include the log file created by this script ($log) with your Support Ticket along with a brief description of your problem\n\nThanks!\n" 
