#!/bin/bash
#
# run this script to create a LiveCD in /tmp/livecd.iso
# Your kernel image has to be in $ROOT/boot/vmlinuz or $ROOT/vmlinuz
# 
# add x86_64 support (Urs Beyerle, PSI)
#

export LANG=C

ARCH=$( /bin/arch )
[ "$ARCH" != "x86_64" ] && ARCH=i686

export PATH=.:./tools:../tools:/usr/sbin:/usr/bin:/sbin:/bin:/

CHANGEDIR="`dirname \`readlink -f $0\``"
echo "Changing current directory to $CHANGEDIR"
cd $CHANGEDIR

. liblinuxlive || exit 1
. config || exit 1

./install $ROOT

VMLINUZ=$ROOT/boot/vmlinuz
if [ -L "$VMLINUZ" ]; then VMLINUZ=`readlink -f $VMLINUZ`; fi
if [ "`ls $VMLINUZ 2>/dev/null`" = "" ]; then echo "cannot find $VMLINUZ"; exit 1; fi

header "Creating LiveCD from your Linux"

mkdir -p $CDDATA/base
mkdir -p $CDDATA/modules
mkdir -p $CDDATA/optional
mkdir -p $CDDATA/rootcopy

echo "copying cd-root to $CDDATA, using kernel from $VMLINUZ"
echo "Using kernel modules from /lib/modules/$KERNEL"
cp -R cd-root/* $CDDATA
# cp -R tools $CDDATA
cp -R info/* $CDDATA
cp $VMLINUZ $CDDATA/boot/vmlinuz

echo "creating initrd image..."
cd initrd
./initrd_create
if [ "$?" -ne 0 ]; then exit; fi
cd ..

cp initrd/$INITRDIMG.gz $CDDATA/boot/initrd.gz
rm initrd/$INITRDIMG.gz

echo "creating compressed images..."

# home not longer in the list, will be created on the fly
# opt -> /usr/opt
#
if [ "$ARCH" = "x86_64" ]; then
    dirs="bin etc lib lib64 root usr sbin var"
else
    dirs="bin etc lib root usr sbin var"
fi

for dir in $dirs; do
    if [ -d $ROOT/$dir ]; then
      echo "base/$dir.mo"
      create_module $ROOT/$dir $CDDATA/base/$dir.mo -keep-as-directory
      if [ $? -ne 0 ]; then exit; fi
    fi
done

echo "creating LiveCD ISO image..."
cd $CDDATA
./make_iso.sh /tmp/livecd.iso

cd /tmp
header "Your ISO is created in /tmp/livecd.iso"
