#!/bin/bash
#
###############################################################
#
# LiveCD customization script
# 
# Run this script on a CentOS 4 Installation
# to prepare the system for a LiveCD 
#
# Urs Beyerle, PSI
#
###############################################################
#
###############################################################

function usage() {

   ## Usage
   # ----------------------------------------------------------

   cat <<EOF

   Options:

    -h:       print this screen
    -psi:     customize for PSI Live CD

EOF

}

###############################################################

###############################################################
# Definitions
###############################################################

### read options from command-line
PSI=""
while [ $# -gt 0 ]; do

    case "$1" in
       -h)
            usage; exit;;
       -psi)
            PSI=true; shift; continue;;
       *)
            usage; exit;;
    esac

done


### arch x86_64 or i686 ?

ARCH=$( /bin/arch )
[ "$ARCH" != "x86_64" ] && ARCH=i686

### Local username
if [ $PSI ]; then
    LOCALUSER=l_psi
else
    LOCALUSER=centos_user
fi


###############################################################
# Configure system
###############################################################

# build nvidia kernel modules
if [ -x /usr/sbin/mknvidia ]; then
    mknvidia
fi

# Update Virus definitions (PSI Antivirus CD)
if [ $PSI ]; then
    echo "search psi.ch" > /etc/resolv.conf
    echo "nameserver 129.129.190.11" >> /etc/resolv.conf
    echo "nameserver 129.129.230.11" >> /etc/resolv.conf

    [ -x /usr/local/f-prot/tools/check-updates.pl ] && /usr/local/f-prot/tools/check-updates.pl
    [ -x /usr/bin/freshclam ] && /usr/bin/freshclam
    [ -x /usr/local/uvscan/update-dat ] && /usr/local/uvscan/update-dat

    rm -f /etc/resolv.conf
    touch /etc/resolv.conf
fi

# run depmod -a
depmod -a

# delete users (just to be sure)
userdel -r $LOCALUSER 2>/dev/null
userdel -r l_psi 2>/dev/null
userdel -r sluser 2>/dev/null
userdel -r centos_user 2>/dev/null
userdel -r user 2>/dev/null

# move /opt to /usr/opt and link /opt -> /usr/opt
# (if not already yet done before)
if [ ! -L /opt ]; then
    echo "Move /opt to /usr/opt"
    mv /opt /usr/
    ln -s /usr/opt /opt
fi

# umount PSI master
if [ $PSI ]; then
    umount /mnt/master 2>/dev/null
fi
    
# make sure we have a original copy of /etc/rc.d/rc.sysinit
if [ ! -e /etc/rc.d/rc.sysinit.ori ]; then
    echo "Save /etc/rc.d/rc.sysinit as /etc/rc.d/rc.sysinit.ori"
    cp -a /etc/rc.d/rc.sysinit /etc/rc.d/rc.sysinit.ori
fi

# copy back /etc/yum.repos.d
if [ ! $PSI ]; then
    cp -a /etc/yum.repos.d.ori /etc/yum.repos.d
fi

# run cfagent
if [ $PSI ]; then
    # cfagent needs running afs
    /etc/init.d/afs start
    echo "Run cfagent ..."
    cfagent
    echo "done."
fi

# run slocate
echo "Run updatedb..."
. /etc/updatedb.conf
/usr/bin/updatedb -e /tmp,/boot,/livecd,/home
echo "done."

# run prelink
echo "Run prelink..."
if [ -x /etc/cron.daily/prelink ]; then
    echo "/etc/cron.daily/prelink"
    /etc/cron.daily/prelink
fi
if [ -x /etc/cron_backup/prelink ]; then
    echo "/etc/cron_backup/prelink"
    /etc/cron_backup/prelink
fi
echo "done."

# run makewhatis
echo "Run makewhatis..."
makewhatis -u -w
echo "done."


###############################################################
# Clean up and delete files
###############################################################

echo "Cleaning up ..."

### set LANG
export LANG=C

### stop AFS
#/etc/init.d/afs stop

### clean up yum
yum clean all
rm -rf /var/cache/yum/*

### remove cfengine log files
#rm -f /var/cfengine/*log

### clean log and rpm database
rm -rf /var/log/*
rm -rf /var/lib/rpm/__db.*

### clean /var/spool/mail
rm -rf /var/spool/mail/*
touch /var/spool/mail/root
chmod 600 /var/spool/mail/root

### stop sysstat and create empty log
rpm -q sysstat > /dev/null
if [ "$?" = "0" ]; then
    /etc/init.d/sysstat stop
    mkdir -p /var/log/sa
fi

### create some empty log dirs
rpm -q gdm > /dev/null
[ "$?" = "0" ] && mkdir -p /var/log/gdm
rpm -q iptraf > /dev/null
[ "$?" = "0" ] && mkdir -p /var/log/iptraf
rpm -q samba-common > /dev/null
[ "$?" = "0" ] && mkdir -p /var/log/samba
rpm -q ppp > /dev/null
[ "$?" = "0" ] && mkdir -p /var/log/ppp
rpm -q isdn4k-utils > /dev/null
[ "$?" = "0" ] && mkdir -p /var/log/vbox
rpm -q cups > /dev/null
[ "$?" = "0" ] && mkdir -p /var/log/cups
rpm -q clamav > /dev/null
if [ "$?" = "0" ]; then
    mkdir -p /var/log/clamav
    chown -R clamav /var/log/clamav
fi

### delete .cfsaved Files
if [ $PSI ]; then
    echo -n "Delete .cfsaved Files, please wait: "
    find / -xdev -name "*\.cfsaved" -exec rm -f {} \;
    echo "ok."
fi

### delete .rpmori .rpm Files in /etc
find /etc -name "*\.rpmorig" -exec rm -f {} \;
find /etc -name "*\.rpmnew" -exec rm -f {} \;

### delete *~ files in /etc
find /etc | grep "~$" | while read f; do rm -f "$f"; done

### clean up /root
rm -f /root/.bash_history
rm -f /root/.ssh/known_hosts

### clean AFS cache
if [ -d /usr/vice/cache ]; then
    rm -rf /usr/vice/cache
    mkdir /usr/vice/cache
fi
if [ -d /var/cache/openafs ]; then
    rm -rf /var/cache/openafs
    mkdir /var/cache/openafs
fi

### clean up /var/tmp
rm -rf /var/tmp/*

### remove root passwd
sed -i "s|^root:.*|root:\*:12943:0:99999:7:::|" /etc/shadow

### Remove /.autofsck
rm -rf /.autofsck

### disable cfagent
#rm -f /etc/cron.d/cfengine

### disable check_update in rc.local.psi
if [ $PSI ]; then
    sed -i "s|/etc/init.d/check_update|# /etc/init.d/check_update|" /etc/rc.d/rc.local.psi
fi

### create link to running kernel
ln -fs /boot/vmlinuz-$( uname -r ) /boot/vmlinuz

### Files to remove
FILES_REMOVE="/etc/ssh/ssh_host_key \
              /etc/ssh/ssh_host_key.pub \
              /etc/ssh/ssh_host_rsa_key.pub \
              /etc/ssh/ssh_host_dsa_key \
              /etc/ssh/ssh_host_dsa_key.pub"
for file in $FILES_REMOVE; do
    rm -rf $file
done

### remove useless cronjobs
mkdir -p /etc/cron_backup
mv /etc/cron.d/sysstat /etc/cron_backup/ 2>/dev/null
mv /etc/cron.daily/00-makewhatis.cron /etc/cron_backup/ 2>/dev/null
mv /etc/cron.weekly/00-makewhatis.cron.weekly /etc/cron.weekly/00-makewhatis.cron 2>/dev/null
mv /etc/cron.weekly/00-makewhatis.cron /etc/cron_backup/00-makewhatis.cron.weekly 2>/dev/null
mv /etc/cron.daily/rpm /etc/cron_backup/ 2>/dev/null
mv /etc/cron.daily/slocate.cron /etc/cron_backup/ 2>/dev/null
mv /etc/cron.daily/tetex.cron /etc/cron_backup/ 2>/dev/null
mv /etc/cron.daily/yum.cron /etc/cron_backup/ 2>/dev/null
mv /etc/cron.daily/prelink /etc/cron_backup/ 2>/dev/null
mv /etc/cron.daily/00-logwatch /etc/cron_backup/ 2>/dev/null
echo "done."

### remove desktop entry from crossover
if [ $PSI ]; then
    rm -rf "/usr/share/apps/kdesktop/DesktopLinks/Internet Explorer.desktop"
fi

### remove backup of /etc/X11/xorg.conf
rm -f /etc/X11/xorg.conf.ori 2>/dev/null
rm -f /etc/X11/xorg.conf.backup 2>/dev/null


###############################################################
# Modify files
###############################################################

echo "Modify files ..."

### remove AFS startup warning about cache
if [ $PSI ]; then
    sed  -i "/\!\!\!/d" /etc/init.d/afs
fi

### disable umount of loop device during shutdown
#   this is done really dirty at the moment:
#    -> just replace "loop" with non existing "lo_fake"
sed -i "s|/loop/|/lo_fake/|g" /etc/init.d/netfs
sed -i "s|/loop/|/lo_fake/|g" /etc/init.d/autofs
sed -i "s|/loop/|/lo_fake/|g" /etc/init.d/halt
#    -> instead of bring down lo, bring down eth0 once again.
sed -i "s|ifdown ifcfg-lo|ifdown ifcfg-eth0|g" /etc/init.d/network

### copy new /etc/init.d/halt 
cp -a customize/halt /etc/init.d/halt

### in /etc/rc.d/rc.sysinit
#   comment out 'initlog -c "fsck -T -a $rootdev $fsckoptions"' 
#   to disable fsck of root filesystem
sed -i "s|\tfsck -T -a \$rootdev|\tsleep 0; #fsck -T -a \$rootdev|" /etc/rc.d/rc.sysinit
sed -i "s|\tinitlog -c \"fsck -T -a \$rootdev|\tsleep 0; #initlog -c \"fsck -T -a \$rootdev|" /etc/rc.d/rc.sysinit
#   disable "Remounting root filesystem in read-write mode"
sed -i "s| action \$\"Remounting root filesystem|#action \$\"Remounting root filesystem|" /etc/rc.d/rc.sysinit

### start afs with option -memcache !
#if [ $PSI ]; then
#    sed -i "s|^EXTRA_OPTIONS=.*|EXTRA_OPTIONS='-fakestat -memcache'|" /etc/sysconfig/afs
#else
#    grep -q "\-fakestat \-memcache" /etc/sysconfig/afs
#    if [ "$?" != "0" ]; then
#	sed -i "s|-fakestat|-fakestat -memcache|" /etc/sysconfig/afs
#    fi
#fi

### source /etc/sysconfig/cfengine
#[ $PSI ] && . /etc/sysconfig/cfengine

### Set /etc/motd
if [ "$ARCH" = "x86_64" ]; then
    LiveCD="LiveCD 64bit"
else
    LiveCD="LiveCD"
fi

if [ $PSI ]; then
    echo "Welcome to PSI ${LiveCD} (${CLASS} ${SUBCLASS} SL${RELEASE})" > /etc/motd
else
    echo "Welcome to CentOS 4 ${LiveCD}" > /etc/motd
fi

### Set hostname to psi or slinux (not really necessary)
if [ $PSI ]; then
    HOSTNAME="psi"
    sed -i "s/hostname=.*/hostname=${HOSTNAME}.psi.ch/" /etc/ssmtp/ssmtp.conf
    sed -i "s/HOSTNAME=.*/HOSTNAME=${HOSTNAME}/" /etc/sysconfig/cfengine
else
    HOSTNAME="centos"
fi  

# change hostname
sed -i "s/HOSTNAME=.*/HOSTNAME=${HOSTNAME}/" /etc/sysconfig/network
sed -i "s/DHCP_HOSTNAME=.*/DHCP_HOSTNAME==${HOSTNAME}/" /etc/sysconfig/networking/devices/ifcfg-eth0

### Modify /etc/redhat-release
ADD=" - LiveCD"
grep -q "$ADD" /etc/redhat-release
if [ "$?" != "0" ]; then
    echo "$( cat /etc/redhat-release )${ADD}" > /etc/redhat-release
fi

### Make scratch
if [ $PSI ]; then
    rm -rf /home/scratch
    mkdir -p /home/scratch
    chmod 1777 /home/scratch
    rm -rf /scratch
    ln -s /home/scratch /scratch
else
    rm -rf /home/scratch
    rm -rf /scratch
    mkdir -p /scratch
    chmod 1777 /scratch
fi

### set default runlevel to 5
sed -i 's/id:3:initdefault:/id:5:initdefault:/' /etc/inittab

### default desktop
echo 'DESKTOP="GNOME"' > /etc/sysconfig/desktop

### GDM login background
#if [ -e /usr/share/gdm/themes/SL/background.png ]; then
#    cp -a customize/sl/background.png /usr/share/gdm/themes/SL/background.png
#fi

### KDE default background
#if [ ! $PSI ]; then
#    if [ -e /usr/share/backgrounds/images/default.png ]; then
#	cp -a customize/sl/default.png /usr/share/backgrounds/images/default.png
#    fi
#fi

### KDE startup/exit sound
#if [ -e /usr/share/config/knotify.eventsrc ]; then
#    cp -a customize/sl/knotify.eventsrc /usr/share/config/knotify.eventsrc
#    cp -a customize/sl/kmixrc /usr/share/config/kmixrc
#fi

### KDE session manager; start at login
#   kmix, krandrtray
#if [ -e /usr/share/config/ksmserverrc ]; then
#    cp -a customize/sl/ksmserverrc /usr/share/config/ksmserverrc
#fi    

echo "done."


###############################################################
# Add-ons
###############################################################

echo "Add-ons ..."

### System icon on desktop
#cp -a customize/System.desktop /usr/share/apps/kdesktop/DesktopLinks/

### files for PSI User, will be copied during bootup to /home/$LOCALUSER/
#if [ $PSI ]; then
#    rm -rf /usr/share/$LOCALUSER
#    cp -a customize/$LOCALUSER /usr/share/
#fi

### psi-menu, psi-scanvirus
#if [ $PSI ]; then
#    cp -a customize/psi/psi-menu /usr/bin/
#    cp -a customize/psi/psi-scanvirus /usr/bin/
#    [ -d /usr/local/uvscan ] && cp -a customize/psi/update-dat /usr/local/uvscan/
#    [ -x /usr/bin/freshclam ] && cp -a customize/psi/psi-freshclam /usr/bin/
#fi

echo "done."


###############################################################
# Create special files
###############################################################

echo "Create special files ..."

###############################################################
# /etc/rc.d/init.d/kudzu-auto
### Noninteractive HW detection and configuration
cat > /etc/rc.d/init.d/kudzu-auto <<EOF
#!/bin/bash
# Noninteractive HW detection and configuration
. /etc/init.d/functions
action $"Hardware auto-detection, please wait... " /usr/sbin/kudzu -q 
EOF
chmod +x /etc/rc.d/init.d/kudzu-auto
ln -sf /etc/rc.d/init.d/kudzu-auto /etc/rc.d/rc5.d/S04kudzu-auto
ln -sf /etc/rc.d/init.d/kudzu-auto /etc/rc.d/rc3.d/S04kudzu-auto


###############################################################
# /etc/rc.d/init.d/runveryfirst
### Fix some things during bootup - run VERY first
# runveryfirst will run at the begining of /etc/rc.d/rc.sysinit

cp -a customize/runveryfirst /etc/init.d/runveryfirst
chmod +x /etc/rc.d/init.d/runveryfirst

# execute runveryfirst just before "Initialize hardware"
grep -q runveryfirst /etc/rc.d/rc.sysinit
if [ "$?" != "0" ]; then
    sed -i -e "/^# Initialize hardware/a\/etc\/init.d\/runveryfirst" /etc/rc.d/rc.sysinit
fi


###############################################################
# /etc/rc.d/init.d/runfirst
### Fix some things during bootup - run first
# runfirst will run at the end of /etc/rc.d/rc.sysinit

cp -a customize/runfirst /etc/init.d/runfirst
chmod +x /etc/rc.d/init.d/runfirst

sysinit_line="/etc/rc.d/init.d/runfirst"
grep -q "$sysinit_line" /etc/rc.d/rc.sysinit
if [ "$?" != "0" ]; then
    echo "$sysinit_line" >> /etc/rc.d/rc.sysinit
    echo >> /etc/rc.d/rc.sysinit
fi

###############################################################
# /etc/rc.d/init.d/login
### Provides directly login over xinit

cp -a customize/login /etc/init.d/login
chmod +x /etc/rc.d/init.d/login


###############################################################
# /etc/rc.d/init.d/runlast
### Fix some things during bootup - run last

cp -a customize/runlast /etc/init.d/runlast
chmod +x /etc/rc.d/init.d/runlast

### Add /etc/rc.d/init.d/runlast to rc.local
LINE=/etc/rc.d/init.d/runlast
grep -q $LINE /etc/rc.d/rc.local
if [ "$?" != "0" ]; then
    # add line
    echo "" >> /etc/rc.d/rc.local
    echo $LINE >> /etc/rc.d/rc.local
    echo "" >> /etc/rc.d/rc.local    
fi

###############################################################
# /usr/bin/save-localdata
### stores data on a usbstick
cp -a customize/save-localdata /usr/bin/save-localdata
chmod +x /usr/bin/save-localdata

# add /usr/bin/save-localdata to /etc/sudoers
grep -q "save-localdata" /etc/sudoers
if [ "$?" != "0" ]; then
    echo "$LOCALUSER ALL = NOPASSWD: /usr/bin/save-localdata" >> /etc/sudoers
fi

# create menu entry
cp -a customize/save-localdata.desktop /usr/share/applications/

###############################################################
# /usr/bin/set-volume
### unmute all mixers and set volumes
cp -a customize/set-volume /usr/bin/set-volume
chmod +x /usr/bin/set-volume


###############################################################
# /etc/sysconfig/networking/devices/ifcfg-eth0
### default eth0 config files
cat > /etc/sysconfig/networking/devices/ifcfg-eth0 <<EOF
DEVICE=eth0
ONBOOT=yes
TYPE=Ethernet
BOOTPROTO=dhcp
USERCTL=no
PEERDNS=yes
IPV6INIT=no
EOF
# make hard links
cp -lf /etc/sysconfig/networking/devices/ifcfg-eth0 /etc/sysconfig/networking/profiles/default/
cp -lf /etc/sysconfig/networking/devices/ifcfg-eth0 /etc/sysconfig/network-scripts/

###############################################################
# /etc/sysconfig/networking/devices/ifcfg-eth1
### default eth1 config files
cat > /etc/sysconfig/networking/devices/ifcfg-eth1 <<EOF
DEVICE=eth1
ONBOOT=yes
TYPE=Ethernet
BOOTPROTO=dhcp
USERCTL=no
PEERDNS=yes
IPV6INIT=no
EOF
# make hard links
cp -lf /etc/sysconfig/networking/devices/ifcfg-eth1 /etc/sysconfig/networking/profiles/default/
cp -lf /etc/sysconfig/networking/devices/ifcfg-eth1 /etc/sysconfig/network-scripts/

###############################################################
# /etc/profile.d/setsysfont.sh
### setsysfont 
cat > /etc/profile.d/setsysfont.sh <<EOF
# setsysfont once
if [ ! -e /tmp/.sysfont_has_been_set ]; then
    touch /tmp/.sysfont_has_been_set
    /bin/setfont 2>/dev/null
    /sbin/setsysfont 2>/dev/null
fi
EOF
chmod 755 /etc/profile.d/setsysfont.sh

###############################################################
# /etc/profile.d/setsysfont.csh
### setsysfont 
cat > /etc/profile.d/setsysfont.csh <<EOF
# setsysfont once
if ( ! -e /tmp/.sysfont_has_been_set ) then
    touch /tmp/.sysfont_has_been_set
    /bin/setfont 2>/dev/null
    /sbin/setsysfont 2>/dev/null
endif
EOF
chmod 755 /etc/profile.d/setsysfont.csh

###############################################################
# /etc/cron.d/psi
### PSI specific cronjobs
cat > /etc/cron.d/psi <<EOF
MAILTO=""
# Update AFS users, if AFS is available
#00 * * * * root [ -x /afs/psi.ch/sys/common/update_user.pl ] && /afs/psi.ch/sys/common/update_user.pl >/dev/null 2>&1
# Update SEPP links, if AFS is available
#05 * * * * root [ -x /afs/psi.ch/sys/common/update_sepp.pl ] && /afs/psi.ch/sys/common/update_sepp.pl >/dev/null 2>&1
EOF

if [ ! $PSI ]; then
    rm -f /etc/cron.d/psi
fi


###############################################################
echo "done."


###############################################################
# Configure services
###############################################################

echo "Configure services ..."

# off
if [ $PSI ]; then
    chkconfig cfenvd off
    chkconfig cfexecd off
    chkconfig cfservd off
fi
chkconfig microcode_ctl off
chkconfig cups off
chkconfig yum off
chkconfig xinetd off 
chkconfig afs off
chkconfig rhnsd off
chkconfig nfslock off
chkconfig ip6tables off
chkconfig mdmonitor off
chkconfig mdmpd off
chkconfig hpoj off
chkconfig sendmail off
chkconfig sshd off
chkconfig portmap off
chkconfig snmptrapd off
chkconfig snmpd off
chkconfig smartd off
chkconfig cups-config-daemon off
chkconfig sysstat off
chkconfig lm_sensors off
chkconfig exim off
chkconfig ntpd off

# we do kudzu-auto
chkconfig kudzu off

# on
if [ $PSI ]; then
    chkconfig vpnclient_init on
fi
chkconfig apmd on
chkconfig acpid on
chkconfig pcmcia on
# chkconfig kudzu on
chkconfig haldaemon on
chkconfig autofs on

echo "done."


###############################################################
# Empty files
###############################################################

echo "Empty files ..."

### /etc/security/users
cat > /etc/security/users <<EOF
EOF

### Files to empty
FILES_TOUCH="/etc/sysconfig/hwconf \
             /etc/resolv.conf \
             /etc/adjtime \
             /etc/modprobe.conf \
             /etc/dhclient-eth0.conf"

for file in $FILES_TOUCH; do
    rm -rf $file
    touch $file
done

echo "done."

###############################################################
