// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_internal.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type NodeType int32

const (
	NodeType_SERVER     NodeType = 0
	NodeType_CONTROLLER NodeType = 1
	NodeType_MEDIA      NodeType = 2
	NodeType_TURN       NodeType = 4
	NodeType_SWEEPER    NodeType = 5
	NodeType_DIRECTOR   NodeType = 6
)

// Enum value maps for NodeType.
var (
	NodeType_name = map[int32]string{
		0: "SERVER",
		1: "CONTROLLER",
		2: "MEDIA",
		4: "TURN",
		5: "SWEEPER",
		6: "DIRECTOR",
	}
	NodeType_value = map[string]int32{
		"SERVER":     0,
		"CONTROLLER": 1,
		"MEDIA":      2,
		"TURN":       4,
		"SWEEPER":    5,
		"DIRECTOR":   6,
	}
)

func (x NodeType) Enum() *NodeType {
	p := new(NodeType)
	*p = x
	return p
}

func (x NodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_internal_proto_enumTypes[0].Descriptor()
}

func (NodeType) Type() protoreflect.EnumType {
	return &file_livekit_internal_proto_enumTypes[0]
}

func (x NodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeType.Descriptor instead.
func (NodeType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{0}
}

type NodeState int32

const (
	NodeState_STARTING_UP   NodeState = 0
	NodeState_SERVING       NodeState = 1
	NodeState_SHUTTING_DOWN NodeState = 2
)

// Enum value maps for NodeState.
var (
	NodeState_name = map[int32]string{
		0: "STARTING_UP",
		1: "SERVING",
		2: "SHUTTING_DOWN",
	}
	NodeState_value = map[string]int32{
		"STARTING_UP":   0,
		"SERVING":       1,
		"SHUTTING_DOWN": 2,
	}
)

func (x NodeState) Enum() *NodeState {
	p := new(NodeState)
	*p = x
	return p
}

func (x NodeState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeState) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_internal_proto_enumTypes[1].Descriptor()
}

func (NodeState) Type() protoreflect.EnumType {
	return &file_livekit_internal_proto_enumTypes[1]
}

func (x NodeState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeState.Descriptor instead.
func (NodeState) EnumDescriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{1}
}

type ICECandidateType int32

const (
	ICECandidateType_ICT_NONE ICECandidateType = 0
	ICECandidateType_ICT_TCP  ICECandidateType = 1
	ICECandidateType_ICT_TLS  ICECandidateType = 2
)

// Enum value maps for ICECandidateType.
var (
	ICECandidateType_name = map[int32]string{
		0: "ICT_NONE",
		1: "ICT_TCP",
		2: "ICT_TLS",
	}
	ICECandidateType_value = map[string]int32{
		"ICT_NONE": 0,
		"ICT_TCP":  1,
		"ICT_TLS":  2,
	}
)

func (x ICECandidateType) Enum() *ICECandidateType {
	p := new(ICECandidateType)
	*p = x
	return p
}

func (x ICECandidateType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ICECandidateType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_internal_proto_enumTypes[2].Descriptor()
}

func (ICECandidateType) Type() protoreflect.EnumType {
	return &file_livekit_internal_proto_enumTypes[2]
}

func (x ICECandidateType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ICECandidateType.Descriptor instead.
func (ICECandidateType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{2}
}

type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id      string     `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Ip      string     `protobuf:"bytes,2,opt,name=ip,proto3" json:"ip,omitempty"`
	NumCpus uint32     `protobuf:"varint,3,opt,name=num_cpus,json=numCpus,proto3" json:"num_cpus,omitempty"`
	Stats   *NodeStats `protobuf:"bytes,4,opt,name=stats,proto3" json:"stats,omitempty"`
	Type    NodeType   `protobuf:"varint,5,opt,name=type,proto3,enum=livekit.NodeType" json:"type,omitempty"`
	State   NodeState  `protobuf:"varint,6,opt,name=state,proto3,enum=livekit.NodeState" json:"state,omitempty"`
	Region  string     `protobuf:"bytes,7,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_internal_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_internal_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{0}
}

func (x *Node) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Node) GetIp() string {
	if x != nil {
		return x.Ip
	}
	return ""
}

func (x *Node) GetNumCpus() uint32 {
	if x != nil {
		return x.NumCpus
	}
	return 0
}

func (x *Node) GetStats() *NodeStats {
	if x != nil {
		return x.Stats
	}
	return nil
}

func (x *Node) GetType() NodeType {
	if x != nil {
		return x.Type
	}
	return NodeType_SERVER
}

func (x *Node) GetState() NodeState {
	if x != nil {
		return x.State
	}
	return NodeState_STARTING_UP
}

func (x *Node) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

type NodeStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// when server was started
	StartedAt int64 `protobuf:"varint,1,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// when server last reported its status
	UpdatedAt int64 `protobuf:"varint,2,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// room
	NumRooms                     int32   `protobuf:"varint,3,opt,name=num_rooms,json=numRooms,proto3" json:"num_rooms,omitempty"`
	NumClients                   int32   `protobuf:"varint,4,opt,name=num_clients,json=numClients,proto3" json:"num_clients,omitempty"`
	NumTracksIn                  int32   `protobuf:"varint,5,opt,name=num_tracks_in,json=numTracksIn,proto3" json:"num_tracks_in,omitempty"`
	NumTracksOut                 int32   `protobuf:"varint,6,opt,name=num_tracks_out,json=numTracksOut,proto3" json:"num_tracks_out,omitempty"`
	NumTrackPublishAttempts      int32   `protobuf:"varint,36,opt,name=num_track_publish_attempts,json=numTrackPublishAttempts,proto3" json:"num_track_publish_attempts,omitempty"`
	TrackPublishAttemptsPerSec   float32 `protobuf:"fixed32,37,opt,name=track_publish_attempts_per_sec,json=trackPublishAttemptsPerSec,proto3" json:"track_publish_attempts_per_sec,omitempty"`
	NumTrackPublishSuccess       int32   `protobuf:"varint,38,opt,name=num_track_publish_success,json=numTrackPublishSuccess,proto3" json:"num_track_publish_success,omitempty"`
	TrackPublishSuccessPerSec    float32 `protobuf:"fixed32,39,opt,name=track_publish_success_per_sec,json=trackPublishSuccessPerSec,proto3" json:"track_publish_success_per_sec,omitempty"`
	NumTrackSubscribeAttempts    int32   `protobuf:"varint,40,opt,name=num_track_subscribe_attempts,json=numTrackSubscribeAttempts,proto3" json:"num_track_subscribe_attempts,omitempty"`
	TrackSubscribeAttemptsPerSec float32 `protobuf:"fixed32,41,opt,name=track_subscribe_attempts_per_sec,json=trackSubscribeAttemptsPerSec,proto3" json:"track_subscribe_attempts_per_sec,omitempty"`
	NumTrackSubscribeSuccess     int32   `protobuf:"varint,42,opt,name=num_track_subscribe_success,json=numTrackSubscribeSuccess,proto3" json:"num_track_subscribe_success,omitempty"`
	TrackSubscribeSuccessPerSec  float32 `protobuf:"fixed32,43,opt,name=track_subscribe_success_per_sec,json=trackSubscribeSuccessPerSec,proto3" json:"track_subscribe_success_per_sec,omitempty"`
	// packet
	BytesIn          uint64  `protobuf:"varint,7,opt,name=bytes_in,json=bytesIn,proto3" json:"bytes_in,omitempty"`
	BytesOut         uint64  `protobuf:"varint,8,opt,name=bytes_out,json=bytesOut,proto3" json:"bytes_out,omitempty"`
	PacketsIn        uint64  `protobuf:"varint,9,opt,name=packets_in,json=packetsIn,proto3" json:"packets_in,omitempty"`
	PacketsOut       uint64  `protobuf:"varint,10,opt,name=packets_out,json=packetsOut,proto3" json:"packets_out,omitempty"`
	NackTotal        uint64  `protobuf:"varint,11,opt,name=nack_total,json=nackTotal,proto3" json:"nack_total,omitempty"`
	BytesInPerSec    float32 `protobuf:"fixed32,12,opt,name=bytes_in_per_sec,json=bytesInPerSec,proto3" json:"bytes_in_per_sec,omitempty"`
	BytesOutPerSec   float32 `protobuf:"fixed32,13,opt,name=bytes_out_per_sec,json=bytesOutPerSec,proto3" json:"bytes_out_per_sec,omitempty"`
	PacketsInPerSec  float32 `protobuf:"fixed32,14,opt,name=packets_in_per_sec,json=packetsInPerSec,proto3" json:"packets_in_per_sec,omitempty"`
	PacketsOutPerSec float32 `protobuf:"fixed32,15,opt,name=packets_out_per_sec,json=packetsOutPerSec,proto3" json:"packets_out_per_sec,omitempty"`
	NackPerSec       float32 `protobuf:"fixed32,16,opt,name=nack_per_sec,json=nackPerSec,proto3" json:"nack_per_sec,omitempty"`
	// system
	NumCpus                    uint32  `protobuf:"varint,17,opt,name=num_cpus,json=numCpus,proto3" json:"num_cpus,omitempty"`
	LoadAvgLast1Min            float32 `protobuf:"fixed32,18,opt,name=load_avg_last1min,json=loadAvgLast1min,proto3" json:"load_avg_last1min,omitempty"`
	LoadAvgLast5Min            float32 `protobuf:"fixed32,19,opt,name=load_avg_last5min,json=loadAvgLast5min,proto3" json:"load_avg_last5min,omitempty"`
	LoadAvgLast15Min           float32 `protobuf:"fixed32,20,opt,name=load_avg_last15min,json=loadAvgLast15min,proto3" json:"load_avg_last15min,omitempty"`
	CpuLoad                    float32 `protobuf:"fixed32,21,opt,name=cpu_load,json=cpuLoad,proto3" json:"cpu_load,omitempty"`
	MemoryLoad                 float32 `protobuf:"fixed32,33,opt,name=memory_load,json=memoryLoad,proto3" json:"memory_load,omitempty"` // deprecated
	MemoryTotal                uint64  `protobuf:"varint,34,opt,name=memory_total,json=memoryTotal,proto3" json:"memory_total,omitempty"`
	MemoryUsed                 uint64  `protobuf:"varint,35,opt,name=memory_used,json=memoryUsed,proto3" json:"memory_used,omitempty"`
	SysPacketsOut              uint32  `protobuf:"varint,28,opt,name=sys_packets_out,json=sysPacketsOut,proto3" json:"sys_packets_out,omitempty"`
	SysPacketsDropped          uint32  `protobuf:"varint,29,opt,name=sys_packets_dropped,json=sysPacketsDropped,proto3" json:"sys_packets_dropped,omitempty"`
	SysPacketsOutPerSec        float32 `protobuf:"fixed32,30,opt,name=sys_packets_out_per_sec,json=sysPacketsOutPerSec,proto3" json:"sys_packets_out_per_sec,omitempty"`
	SysPacketsDroppedPerSec    float32 `protobuf:"fixed32,31,opt,name=sys_packets_dropped_per_sec,json=sysPacketsDroppedPerSec,proto3" json:"sys_packets_dropped_per_sec,omitempty"`
	SysPacketsDroppedPctPerSec float32 `protobuf:"fixed32,32,opt,name=sys_packets_dropped_pct_per_sec,json=sysPacketsDroppedPctPerSec,proto3" json:"sys_packets_dropped_pct_per_sec,omitempty"`
	// retransmissions
	RetransmitBytesOut         uint64  `protobuf:"varint,22,opt,name=retransmit_bytes_out,json=retransmitBytesOut,proto3" json:"retransmit_bytes_out,omitempty"`
	RetransmitPacketsOut       uint64  `protobuf:"varint,23,opt,name=retransmit_packets_out,json=retransmitPacketsOut,proto3" json:"retransmit_packets_out,omitempty"`
	RetransmitBytesOutPerSec   float32 `protobuf:"fixed32,24,opt,name=retransmit_bytes_out_per_sec,json=retransmitBytesOutPerSec,proto3" json:"retransmit_bytes_out_per_sec,omitempty"`
	RetransmitPacketsOutPerSec float32 `protobuf:"fixed32,25,opt,name=retransmit_packets_out_per_sec,json=retransmitPacketsOutPerSec,proto3" json:"retransmit_packets_out_per_sec,omitempty"`
	// participant joins
	ParticipantSignalConnected       uint64  `protobuf:"varint,26,opt,name=participant_signal_connected,json=participantSignalConnected,proto3" json:"participant_signal_connected,omitempty"`
	ParticipantSignalConnectedPerSec float32 `protobuf:"fixed32,27,opt,name=participant_signal_connected_per_sec,json=participantSignalConnectedPerSec,proto3" json:"participant_signal_connected_per_sec,omitempty"`
	ParticipantRtcConnected          uint64  `protobuf:"varint,44,opt,name=participant_rtc_connected,json=participantRtcConnected,proto3" json:"participant_rtc_connected,omitempty"`
	ParticipantRtcConnectedPerSec    float32 `protobuf:"fixed32,45,opt,name=participant_rtc_connected_per_sec,json=participantRtcConnectedPerSec,proto3" json:"participant_rtc_connected_per_sec,omitempty"`
	ParticipantRtcInit               uint64  `protobuf:"varint,46,opt,name=participant_rtc_init,json=participantRtcInit,proto3" json:"participant_rtc_init,omitempty"`
	ParticipantRtcInitPerSec         float32 `protobuf:"fixed32,47,opt,name=participant_rtc_init_per_sec,json=participantRtcInitPerSec,proto3" json:"participant_rtc_init_per_sec,omitempty"`
}

func (x *NodeStats) Reset() {
	*x = NodeStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_internal_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeStats) ProtoMessage() {}

func (x *NodeStats) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_internal_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeStats.ProtoReflect.Descriptor instead.
func (*NodeStats) Descriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{1}
}

func (x *NodeStats) GetStartedAt() int64 {
	if x != nil {
		return x.StartedAt
	}
	return 0
}

func (x *NodeStats) GetUpdatedAt() int64 {
	if x != nil {
		return x.UpdatedAt
	}
	return 0
}

func (x *NodeStats) GetNumRooms() int32 {
	if x != nil {
		return x.NumRooms
	}
	return 0
}

func (x *NodeStats) GetNumClients() int32 {
	if x != nil {
		return x.NumClients
	}
	return 0
}

func (x *NodeStats) GetNumTracksIn() int32 {
	if x != nil {
		return x.NumTracksIn
	}
	return 0
}

func (x *NodeStats) GetNumTracksOut() int32 {
	if x != nil {
		return x.NumTracksOut
	}
	return 0
}

func (x *NodeStats) GetNumTrackPublishAttempts() int32 {
	if x != nil {
		return x.NumTrackPublishAttempts
	}
	return 0
}

func (x *NodeStats) GetTrackPublishAttemptsPerSec() float32 {
	if x != nil {
		return x.TrackPublishAttemptsPerSec
	}
	return 0
}

func (x *NodeStats) GetNumTrackPublishSuccess() int32 {
	if x != nil {
		return x.NumTrackPublishSuccess
	}
	return 0
}

func (x *NodeStats) GetTrackPublishSuccessPerSec() float32 {
	if x != nil {
		return x.TrackPublishSuccessPerSec
	}
	return 0
}

func (x *NodeStats) GetNumTrackSubscribeAttempts() int32 {
	if x != nil {
		return x.NumTrackSubscribeAttempts
	}
	return 0
}

func (x *NodeStats) GetTrackSubscribeAttemptsPerSec() float32 {
	if x != nil {
		return x.TrackSubscribeAttemptsPerSec
	}
	return 0
}

func (x *NodeStats) GetNumTrackSubscribeSuccess() int32 {
	if x != nil {
		return x.NumTrackSubscribeSuccess
	}
	return 0
}

func (x *NodeStats) GetTrackSubscribeSuccessPerSec() float32 {
	if x != nil {
		return x.TrackSubscribeSuccessPerSec
	}
	return 0
}

func (x *NodeStats) GetBytesIn() uint64 {
	if x != nil {
		return x.BytesIn
	}
	return 0
}

func (x *NodeStats) GetBytesOut() uint64 {
	if x != nil {
		return x.BytesOut
	}
	return 0
}

func (x *NodeStats) GetPacketsIn() uint64 {
	if x != nil {
		return x.PacketsIn
	}
	return 0
}

func (x *NodeStats) GetPacketsOut() uint64 {
	if x != nil {
		return x.PacketsOut
	}
	return 0
}

func (x *NodeStats) GetNackTotal() uint64 {
	if x != nil {
		return x.NackTotal
	}
	return 0
}

func (x *NodeStats) GetBytesInPerSec() float32 {
	if x != nil {
		return x.BytesInPerSec
	}
	return 0
}

func (x *NodeStats) GetBytesOutPerSec() float32 {
	if x != nil {
		return x.BytesOutPerSec
	}
	return 0
}

func (x *NodeStats) GetPacketsInPerSec() float32 {
	if x != nil {
		return x.PacketsInPerSec
	}
	return 0
}

func (x *NodeStats) GetPacketsOutPerSec() float32 {
	if x != nil {
		return x.PacketsOutPerSec
	}
	return 0
}

func (x *NodeStats) GetNackPerSec() float32 {
	if x != nil {
		return x.NackPerSec
	}
	return 0
}

func (x *NodeStats) GetNumCpus() uint32 {
	if x != nil {
		return x.NumCpus
	}
	return 0
}

func (x *NodeStats) GetLoadAvgLast1Min() float32 {
	if x != nil {
		return x.LoadAvgLast1Min
	}
	return 0
}

func (x *NodeStats) GetLoadAvgLast5Min() float32 {
	if x != nil {
		return x.LoadAvgLast5Min
	}
	return 0
}

func (x *NodeStats) GetLoadAvgLast15Min() float32 {
	if x != nil {
		return x.LoadAvgLast15Min
	}
	return 0
}

func (x *NodeStats) GetCpuLoad() float32 {
	if x != nil {
		return x.CpuLoad
	}
	return 0
}

func (x *NodeStats) GetMemoryLoad() float32 {
	if x != nil {
		return x.MemoryLoad
	}
	return 0
}

func (x *NodeStats) GetMemoryTotal() uint64 {
	if x != nil {
		return x.MemoryTotal
	}
	return 0
}

func (x *NodeStats) GetMemoryUsed() uint64 {
	if x != nil {
		return x.MemoryUsed
	}
	return 0
}

func (x *NodeStats) GetSysPacketsOut() uint32 {
	if x != nil {
		return x.SysPacketsOut
	}
	return 0
}

func (x *NodeStats) GetSysPacketsDropped() uint32 {
	if x != nil {
		return x.SysPacketsDropped
	}
	return 0
}

func (x *NodeStats) GetSysPacketsOutPerSec() float32 {
	if x != nil {
		return x.SysPacketsOutPerSec
	}
	return 0
}

func (x *NodeStats) GetSysPacketsDroppedPerSec() float32 {
	if x != nil {
		return x.SysPacketsDroppedPerSec
	}
	return 0
}

func (x *NodeStats) GetSysPacketsDroppedPctPerSec() float32 {
	if x != nil {
		return x.SysPacketsDroppedPctPerSec
	}
	return 0
}

func (x *NodeStats) GetRetransmitBytesOut() uint64 {
	if x != nil {
		return x.RetransmitBytesOut
	}
	return 0
}

func (x *NodeStats) GetRetransmitPacketsOut() uint64 {
	if x != nil {
		return x.RetransmitPacketsOut
	}
	return 0
}

func (x *NodeStats) GetRetransmitBytesOutPerSec() float32 {
	if x != nil {
		return x.RetransmitBytesOutPerSec
	}
	return 0
}

func (x *NodeStats) GetRetransmitPacketsOutPerSec() float32 {
	if x != nil {
		return x.RetransmitPacketsOutPerSec
	}
	return 0
}

func (x *NodeStats) GetParticipantSignalConnected() uint64 {
	if x != nil {
		return x.ParticipantSignalConnected
	}
	return 0
}

func (x *NodeStats) GetParticipantSignalConnectedPerSec() float32 {
	if x != nil {
		return x.ParticipantSignalConnectedPerSec
	}
	return 0
}

func (x *NodeStats) GetParticipantRtcConnected() uint64 {
	if x != nil {
		return x.ParticipantRtcConnected
	}
	return 0
}

func (x *NodeStats) GetParticipantRtcConnectedPerSec() float32 {
	if x != nil {
		return x.ParticipantRtcConnectedPerSec
	}
	return 0
}

func (x *NodeStats) GetParticipantRtcInit() uint64 {
	if x != nil {
		return x.ParticipantRtcInit
	}
	return 0
}

func (x *NodeStats) GetParticipantRtcInitPerSec() float32 {
	if x != nil {
		return x.ParticipantRtcInitPerSec
	}
	return 0
}

type StartSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	RoomName     string `protobuf:"bytes,1,opt,name=room_name,json=roomName,proto3" json:"room_name,omitempty"`
	Identity     string `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	ConnectionId string `protobuf:"bytes,3,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
	// if a client is reconnecting (i.e. resume instead of restart)
	Reconnect     bool        `protobuf:"varint,4,opt,name=reconnect,proto3" json:"reconnect,omitempty"`
	AutoSubscribe bool        `protobuf:"varint,9,opt,name=auto_subscribe,json=autoSubscribe,proto3" json:"auto_subscribe,omitempty"`
	Hidden        bool        `protobuf:"varint,10,opt,name=hidden,proto3" json:"hidden,omitempty"`
	Client        *ClientInfo `protobuf:"bytes,11,opt,name=client,proto3" json:"client,omitempty"`
	Recorder      bool        `protobuf:"varint,12,opt,name=recorder,proto3" json:"recorder,omitempty"`
	Name          string      `protobuf:"bytes,13,opt,name=name,proto3" json:"name,omitempty"`
	// A user's ClaimGrants serialized in JSON
	GrantsJson     string `protobuf:"bytes,14,opt,name=grants_json,json=grantsJson,proto3" json:"grants_json,omitempty"`
	AdaptiveStream bool   `protobuf:"varint,15,opt,name=adaptive_stream,json=adaptiveStream,proto3" json:"adaptive_stream,omitempty"`
	// if reconnect, client will set current sid
	ParticipantId        string          `protobuf:"bytes,16,opt,name=participant_id,json=participantId,proto3" json:"participant_id,omitempty"`
	ReconnectReason      ReconnectReason `protobuf:"varint,17,opt,name=reconnect_reason,json=reconnectReason,proto3,enum=livekit.ReconnectReason" json:"reconnect_reason,omitempty"`
	SubscriberAllowPause *bool           `protobuf:"varint,18,opt,name=subscriber_allow_pause,json=subscriberAllowPause,proto3,oneof" json:"subscriber_allow_pause,omitempty"`
}

func (x *StartSession) Reset() {
	*x = StartSession{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_internal_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartSession) ProtoMessage() {}

func (x *StartSession) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_internal_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartSession.ProtoReflect.Descriptor instead.
func (*StartSession) Descriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{2}
}

func (x *StartSession) GetRoomName() string {
	if x != nil {
		return x.RoomName
	}
	return ""
}

func (x *StartSession) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

func (x *StartSession) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

func (x *StartSession) GetReconnect() bool {
	if x != nil {
		return x.Reconnect
	}
	return false
}

func (x *StartSession) GetAutoSubscribe() bool {
	if x != nil {
		return x.AutoSubscribe
	}
	return false
}

func (x *StartSession) GetHidden() bool {
	if x != nil {
		return x.Hidden
	}
	return false
}

func (x *StartSession) GetClient() *ClientInfo {
	if x != nil {
		return x.Client
	}
	return nil
}

func (x *StartSession) GetRecorder() bool {
	if x != nil {
		return x.Recorder
	}
	return false
}

func (x *StartSession) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StartSession) GetGrantsJson() string {
	if x != nil {
		return x.GrantsJson
	}
	return ""
}

func (x *StartSession) GetAdaptiveStream() bool {
	if x != nil {
		return x.AdaptiveStream
	}
	return false
}

func (x *StartSession) GetParticipantId() string {
	if x != nil {
		return x.ParticipantId
	}
	return ""
}

func (x *StartSession) GetReconnectReason() ReconnectReason {
	if x != nil {
		return x.ReconnectReason
	}
	return ReconnectReason_RR_UNKNOWN
}

func (x *StartSession) GetSubscriberAllowPause() bool {
	if x != nil && x.SubscriberAllowPause != nil {
		return *x.SubscriberAllowPause
	}
	return false
}

// room info that should not be returned to clients
type RoomInternal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TrackEgress       *AutoTrackEgress       `protobuf:"bytes,1,opt,name=track_egress,json=trackEgress,proto3" json:"track_egress,omitempty"`
	ParticipantEgress *AutoParticipantEgress `protobuf:"bytes,2,opt,name=participant_egress,json=participantEgress,proto3" json:"participant_egress,omitempty"`
	PlayoutDelay      *PlayoutDelay          `protobuf:"bytes,3,opt,name=playout_delay,json=playoutDelay,proto3" json:"playout_delay,omitempty"`
	SyncStreams       bool                   `protobuf:"varint,4,opt,name=sync_streams,json=syncStreams,proto3" json:"sync_streams,omitempty"`
}

func (x *RoomInternal) Reset() {
	*x = RoomInternal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_internal_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RoomInternal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoomInternal) ProtoMessage() {}

func (x *RoomInternal) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_internal_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoomInternal.ProtoReflect.Descriptor instead.
func (*RoomInternal) Descriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{3}
}

func (x *RoomInternal) GetTrackEgress() *AutoTrackEgress {
	if x != nil {
		return x.TrackEgress
	}
	return nil
}

func (x *RoomInternal) GetParticipantEgress() *AutoParticipantEgress {
	if x != nil {
		return x.ParticipantEgress
	}
	return nil
}

func (x *RoomInternal) GetPlayoutDelay() *PlayoutDelay {
	if x != nil {
		return x.PlayoutDelay
	}
	return nil
}

func (x *RoomInternal) GetSyncStreams() bool {
	if x != nil {
		return x.SyncStreams
	}
	return false
}

type ICEConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PreferenceSubscriber ICECandidateType `protobuf:"varint,1,opt,name=preference_subscriber,json=preferenceSubscriber,proto3,enum=livekit.ICECandidateType" json:"preference_subscriber,omitempty"`
	PreferencePublisher  ICECandidateType `protobuf:"varint,2,opt,name=preference_publisher,json=preferencePublisher,proto3,enum=livekit.ICECandidateType" json:"preference_publisher,omitempty"`
}

func (x *ICEConfig) Reset() {
	*x = ICEConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_internal_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ICEConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ICEConfig) ProtoMessage() {}

func (x *ICEConfig) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_internal_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ICEConfig.ProtoReflect.Descriptor instead.
func (*ICEConfig) Descriptor() ([]byte, []int) {
	return file_livekit_internal_proto_rawDescGZIP(), []int{4}
}

func (x *ICEConfig) GetPreferenceSubscriber() ICECandidateType {
	if x != nil {
		return x.PreferenceSubscriber
	}
	return ICECandidateType_ICT_NONE
}

func (x *ICEConfig) GetPreferencePublisher() ICECandidateType {
	if x != nil {
		return x.PreferencePublisher
	}
	return ICECandidateType_ICT_NONE
}

var File_livekit_internal_proto protoreflect.FileDescriptor

var file_livekit_internal_proto_rawDesc = []byte{
	0x0a, 0x16, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x1a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x01,
	0x0a, 0x04, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x70, 0x12, 0x19, 0x0a, 0x08, 0x6e, 0x75, 0x6d, 0x5f, 0x63, 0x70,
	0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x43, 0x70, 0x75,
	0x73, 0x12, 0x28, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x28, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x22, 0xee, 0x11, 0x0a, 0x09, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x6f, 0x6f, 0x6d, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x52, 0x6f, 0x6f, 0x6d, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x6e, 0x75, 0x6d, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0a, 0x6e, 0x75, 0x6d, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x22,
	0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x5f, 0x69, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x73,
	0x49, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x73,
	0x5f, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x73, 0x4f, 0x75, 0x74, 0x12, 0x3b, 0x0a, 0x1a, 0x6e, 0x75, 0x6d, 0x5f,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x61, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x24, 0x20, 0x01, 0x28, 0x05, 0x52, 0x17, 0x6e, 0x75,
	0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x74, 0x74,
	0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x1e, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x25, 0x20, 0x01, 0x28, 0x02, 0x52, 0x1a, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x41, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x39, 0x0a, 0x19, 0x6e, 0x75, 0x6d,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x26, 0x20, 0x01, 0x28, 0x05, 0x52, 0x16, 0x6e, 0x75,
	0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x12, 0x40, 0x0a, 0x1d, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x27, 0x20, 0x01, 0x28, 0x02, 0x52, 0x19, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x3f, 0x0a, 0x1c, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x5f, 0x61, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18, 0x28, 0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x6e, 0x75,
	0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x41,
	0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x12, 0x46, 0x0a, 0x20, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x29, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x1c, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12,
	0x3d, 0x0a, 0x1b, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x2a,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x6e, 0x75, 0x6d, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x44,
	0x0a, 0x1f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x02, 0x52, 0x1b, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x53, 0x75,
	0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x50, 0x65,
	0x72, 0x53, 0x65, 0x63, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x69, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x07, 0x62, 0x79, 0x74, 0x65, 0x73, 0x49, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x08, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4f, 0x75, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x49, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0a, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x6e, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x09, 0x6e, 0x61, 0x63, 0x6b, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x27, 0x0a, 0x10, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x49, 0x6e, 0x50, 0x65,
	0x72, 0x53, 0x65, 0x63, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x6f, 0x75,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0e, 0x62, 0x79, 0x74, 0x65, 0x73, 0x4f, 0x75, 0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12,
	0x2b, 0x0a, 0x12, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x70, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x49, 0x6e, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x2d, 0x0a, 0x13,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x63, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x02, 0x52, 0x10, 0x70, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x4f, 0x75, 0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x20, 0x0a, 0x0c, 0x6e,
	0x61, 0x63, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x0a, 0x6e, 0x61, 0x63, 0x6b, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x19, 0x0a,
	0x08, 0x6e, 0x75, 0x6d, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x6e, 0x75, 0x6d, 0x43, 0x70, 0x75, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x61, 0x76, 0x67, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x31, 0x6d, 0x69, 0x6e, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0f, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x76, 0x67, 0x4c, 0x61, 0x73, 0x74,
	0x31, 0x6d, 0x69, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x61, 0x76, 0x67,
	0x5f, 0x6c, 0x61, 0x73, 0x74, 0x35, 0x6d, 0x69, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0f, 0x6c, 0x6f, 0x61, 0x64, 0x41, 0x76, 0x67, 0x4c, 0x61, 0x73, 0x74, 0x35, 0x6d, 0x69, 0x6e,
	0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x61, 0x76, 0x67, 0x5f, 0x6c, 0x61, 0x73,
	0x74, 0x31, 0x35, 0x6d, 0x69, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x02, 0x52, 0x10, 0x6c, 0x6f,
	0x61, 0x64, 0x41, 0x76, 0x67, 0x4c, 0x61, 0x73, 0x74, 0x31, 0x35, 0x6d, 0x69, 0x6e, 0x12, 0x19,
	0x0a, 0x08, 0x63, 0x70, 0x75, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x15, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x07, 0x63, 0x70, 0x75, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x21, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x6f, 0x61, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x18, 0x22, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x18, 0x23, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x65, 0x64, 0x12, 0x26,
	0x0a, 0x0f, 0x73, 0x79, 0x73, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6f, 0x75,
	0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0d, 0x73, 0x79, 0x73, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x79, 0x73, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x18, 0x1d, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x11, 0x73, 0x79, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x44,
	0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x17, 0x73, 0x79, 0x73, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x73, 0x79, 0x73, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x3c, 0x0a, 0x1b,
	0x73, 0x79, 0x73, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x64, 0x72, 0x6f, 0x70,
	0x70, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x1f, 0x20, 0x01, 0x28,
	0x02, 0x52, 0x17, 0x73, 0x79, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x44, 0x72, 0x6f,
	0x70, 0x70, 0x65, 0x64, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x43, 0x0a, 0x1f, 0x73, 0x79,
	0x73, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x70, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x20, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x1a, 0x73, 0x79, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x44,
	0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x50, 0x63, 0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12,
	0x30, 0x0a, 0x14, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x72,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x4f, 0x75,
	0x74, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x14, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x12, 0x3e, 0x0a, 0x1c, 0x72, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6d, 0x69, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x18, 0x20, 0x01, 0x28, 0x02, 0x52, 0x18, 0x72,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x4f, 0x75,
	0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x42, 0x0a, 0x1e, 0x72, 0x65, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6d, 0x69, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x6f, 0x75,
	0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x19, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x1a, 0x72, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x4f, 0x75, 0x74, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x1c, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x1a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x4e, 0x0a,
	0x24, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x67,
	0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x02, 0x52, 0x20, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x12, 0x3a, 0x0a,
	0x19, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x74, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x04,
	0x52, 0x17, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x74, 0x63,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x12, 0x48, 0x0a, 0x21, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x74, 0x63, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x2d,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x1d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x52, 0x74, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x65, 0x72,
	0x53, 0x65, 0x63, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x5f, 0x72, 0x74, 0x63, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x18, 0x2e, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x12, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x74,
	0x63, 0x49, 0x6e, 0x69, 0x74, 0x12, 0x3e, 0x0a, 0x1c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x5f, 0x72, 0x74, 0x63, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x02, 0x52, 0x18, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x74, 0x63, 0x49, 0x6e, 0x69, 0x74, 0x50,
	0x65, 0x72, 0x53, 0x65, 0x63, 0x22, 0xb2, 0x04, 0x0a, 0x0c, 0x53, 0x74, 0x61, 0x72, 0x74, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x6f, 0x6d, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x6f, 0x6f, 0x6d, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x62, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f,
	0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x69, 0x64,
	0x64, 0x65, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x68, 0x69, 0x64, 0x64, 0x65,
	0x6e, 0x12, 0x2b, 0x0a, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x43, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x1a,
	0x0a, 0x08, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x4a, 0x73, 0x6f, 0x6e, 0x12,
	0x27, 0x0a, 0x0f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x43, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x6b, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x16, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x72, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x14, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x61, 0x75, 0x73, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x19, 0x0a, 0x17, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x0c, 0x52,
	0x6f, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x12, 0x3b, 0x0a, 0x0c, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x54, 0x72, 0x61, 0x63, 0x6b, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0b, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x4d, 0x0a, 0x12, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x5f, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x45, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3a, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x44, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x0c, 0x70, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x79, 0x6e, 0x63, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x09, 0x49, 0x43, 0x45, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x43,
	0x45, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x14,
	0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x72, 0x12, 0x4c, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x19, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x49, 0x43, 0x45,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x13, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x2a, 0x56, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f,
	0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x45,
	0x44, 0x49, 0x41, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x55, 0x52, 0x4e, 0x10, 0x04, 0x12,
	0x0b, 0x0a, 0x07, 0x53, 0x57, 0x45, 0x45, 0x50, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x06, 0x2a, 0x3c, 0x0a, 0x09, 0x4e, 0x6f,
	0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x54, 0x41, 0x52, 0x54,
	0x49, 0x4e, 0x47, 0x5f, 0x55, 0x50, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x45, 0x52, 0x56,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x48, 0x55, 0x54, 0x54, 0x49, 0x4e,
	0x47, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x2a, 0x3a, 0x0a, 0x10, 0x49, 0x43, 0x45, 0x43,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08,
	0x49, 0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x43,
	0x54, 0x5f, 0x54, 0x43, 0x50, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x43, 0x54, 0x5f, 0x54,
	0x4c, 0x53, 0x10, 0x02, 0x42, 0x46, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c, 0x69,
	0x76, 0x65, 0x4b, 0x69, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c, 0x69,
	0x76, 0x65, 0x4b, 0x69, 0x74, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_internal_proto_rawDescOnce sync.Once
	file_livekit_internal_proto_rawDescData = file_livekit_internal_proto_rawDesc
)

func file_livekit_internal_proto_rawDescGZIP() []byte {
	file_livekit_internal_proto_rawDescOnce.Do(func() {
		file_livekit_internal_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_internal_proto_rawDescData)
	})
	return file_livekit_internal_proto_rawDescData
}

var file_livekit_internal_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_livekit_internal_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_livekit_internal_proto_goTypes = []interface{}{
	(NodeType)(0),                 // 0: livekit.NodeType
	(NodeState)(0),                // 1: livekit.NodeState
	(ICECandidateType)(0),         // 2: livekit.ICECandidateType
	(*Node)(nil),                  // 3: livekit.Node
	(*NodeStats)(nil),             // 4: livekit.NodeStats
	(*StartSession)(nil),          // 5: livekit.StartSession
	(*RoomInternal)(nil),          // 6: livekit.RoomInternal
	(*ICEConfig)(nil),             // 7: livekit.ICEConfig
	(*ClientInfo)(nil),            // 8: livekit.ClientInfo
	(ReconnectReason)(0),          // 9: livekit.ReconnectReason
	(*AutoTrackEgress)(nil),       // 10: livekit.AutoTrackEgress
	(*AutoParticipantEgress)(nil), // 11: livekit.AutoParticipantEgress
	(*PlayoutDelay)(nil),          // 12: livekit.PlayoutDelay
}
var file_livekit_internal_proto_depIdxs = []int32{
	4,  // 0: livekit.Node.stats:type_name -> livekit.NodeStats
	0,  // 1: livekit.Node.type:type_name -> livekit.NodeType
	1,  // 2: livekit.Node.state:type_name -> livekit.NodeState
	8,  // 3: livekit.StartSession.client:type_name -> livekit.ClientInfo
	9,  // 4: livekit.StartSession.reconnect_reason:type_name -> livekit.ReconnectReason
	10, // 5: livekit.RoomInternal.track_egress:type_name -> livekit.AutoTrackEgress
	11, // 6: livekit.RoomInternal.participant_egress:type_name -> livekit.AutoParticipantEgress
	12, // 7: livekit.RoomInternal.playout_delay:type_name -> livekit.PlayoutDelay
	2,  // 8: livekit.ICEConfig.preference_subscriber:type_name -> livekit.ICECandidateType
	2,  // 9: livekit.ICEConfig.preference_publisher:type_name -> livekit.ICECandidateType
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_livekit_internal_proto_init() }
func file_livekit_internal_proto_init() {
	if File_livekit_internal_proto != nil {
		return
	}
	file_livekit_models_proto_init()
	file_livekit_egress_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_livekit_internal_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_internal_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_internal_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartSession); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_internal_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RoomInternal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_internal_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ICEConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_internal_proto_msgTypes[2].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_internal_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_livekit_internal_proto_goTypes,
		DependencyIndexes: file_livekit_internal_proto_depIdxs,
		EnumInfos:         file_livekit_internal_proto_enumTypes,
		MessageInfos:      file_livekit_internal_proto_msgTypes,
	}.Build()
	File_livekit_internal_proto = out.File
	file_livekit_internal_proto_rawDesc = nil
	file_livekit_internal_proto_goTypes = nil
	file_livekit_internal_proto_depIdxs = nil
}
