// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal,
    clippy::upper_case_acronyms
)]
#![cfg_attr(docsrs, feature(doc_cfg))]

use glib_sys as glib;
use gstreamer_base_sys as gst_base;
use gstreamer_sys as gst;

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, off_t, size_t, ssize_t, time_t, uintptr_t, FILE,
};
#[cfg(unix)]
#[allow(unused_imports)]
use libc::{dev_t, gid_t, pid_t, socklen_t, uid_t};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Enums
pub type GstRTCPFBType = c_int;
pub const GST_RTCP_FB_TYPE_INVALID: GstRTCPFBType = 0;
pub const GST_RTCP_RTPFB_TYPE_NACK: GstRTCPFBType = 1;
pub const GST_RTCP_RTPFB_TYPE_TMMBR: GstRTCPFBType = 3;
pub const GST_RTCP_RTPFB_TYPE_TMMBN: GstRTCPFBType = 4;
pub const GST_RTCP_RTPFB_TYPE_RTCP_SR_REQ: GstRTCPFBType = 5;
pub const GST_RTCP_RTPFB_TYPE_TWCC: GstRTCPFBType = 15;
pub const GST_RTCP_PSFB_TYPE_PLI: GstRTCPFBType = 1;
pub const GST_RTCP_PSFB_TYPE_SLI: GstRTCPFBType = 2;
pub const GST_RTCP_PSFB_TYPE_RPSI: GstRTCPFBType = 3;
pub const GST_RTCP_PSFB_TYPE_AFB: GstRTCPFBType = 15;
pub const GST_RTCP_PSFB_TYPE_FIR: GstRTCPFBType = 4;
pub const GST_RTCP_PSFB_TYPE_TSTR: GstRTCPFBType = 5;
pub const GST_RTCP_PSFB_TYPE_TSTN: GstRTCPFBType = 6;
pub const GST_RTCP_PSFB_TYPE_VBCN: GstRTCPFBType = 7;

pub type GstRTCPSDESType = c_int;
pub const GST_RTCP_SDES_INVALID: GstRTCPSDESType = -1;
pub const GST_RTCP_SDES_END: GstRTCPSDESType = 0;
pub const GST_RTCP_SDES_CNAME: GstRTCPSDESType = 1;
pub const GST_RTCP_SDES_NAME: GstRTCPSDESType = 2;
pub const GST_RTCP_SDES_EMAIL: GstRTCPSDESType = 3;
pub const GST_RTCP_SDES_PHONE: GstRTCPSDESType = 4;
pub const GST_RTCP_SDES_LOC: GstRTCPSDESType = 5;
pub const GST_RTCP_SDES_TOOL: GstRTCPSDESType = 6;
pub const GST_RTCP_SDES_NOTE: GstRTCPSDESType = 7;
pub const GST_RTCP_SDES_PRIV: GstRTCPSDESType = 8;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_H323_CADDR: GstRTCPSDESType = 9;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_APSI: GstRTCPSDESType = 10;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_RGRP: GstRTCPSDESType = 11;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_RTP_STREAM_ID: GstRTCPSDESType = 12;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_REPAIRED_RTP_STREAM_ID: GstRTCPSDESType = 13;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_CCID: GstRTCPSDESType = 14;
#[cfg(feature = "v1_20")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
pub const GST_RTCP_SDES_MID: GstRTCPSDESType = 15;

pub type GstRTCPType = c_int;
pub const GST_RTCP_TYPE_INVALID: GstRTCPType = 0;
pub const GST_RTCP_TYPE_SR: GstRTCPType = 200;
pub const GST_RTCP_TYPE_RR: GstRTCPType = 201;
pub const GST_RTCP_TYPE_SDES: GstRTCPType = 202;
pub const GST_RTCP_TYPE_BYE: GstRTCPType = 203;
pub const GST_RTCP_TYPE_APP: GstRTCPType = 204;
pub const GST_RTCP_TYPE_RTPFB: GstRTCPType = 205;
pub const GST_RTCP_TYPE_PSFB: GstRTCPType = 206;
pub const GST_RTCP_TYPE_XR: GstRTCPType = 207;

pub type GstRTCPXRType = c_int;
pub const GST_RTCP_XR_TYPE_INVALID: GstRTCPXRType = -1;
pub const GST_RTCP_XR_TYPE_LRLE: GstRTCPXRType = 1;
pub const GST_RTCP_XR_TYPE_DRLE: GstRTCPXRType = 2;
pub const GST_RTCP_XR_TYPE_PRT: GstRTCPXRType = 3;
pub const GST_RTCP_XR_TYPE_RRT: GstRTCPXRType = 4;
pub const GST_RTCP_XR_TYPE_DLRR: GstRTCPXRType = 5;
pub const GST_RTCP_XR_TYPE_SSUMM: GstRTCPXRType = 6;
pub const GST_RTCP_XR_TYPE_VOIP_METRICS: GstRTCPXRType = 7;

pub type GstRTPPayload = c_int;
pub const GST_RTP_PAYLOAD_PCMU: GstRTPPayload = 0;
pub const GST_RTP_PAYLOAD_1016: GstRTPPayload = 1;
pub const GST_RTP_PAYLOAD_G721: GstRTPPayload = 2;
pub const GST_RTP_PAYLOAD_GSM: GstRTPPayload = 3;
pub const GST_RTP_PAYLOAD_G723: GstRTPPayload = 4;
pub const GST_RTP_PAYLOAD_DVI4_8000: GstRTPPayload = 5;
pub const GST_RTP_PAYLOAD_DVI4_16000: GstRTPPayload = 6;
pub const GST_RTP_PAYLOAD_LPC: GstRTPPayload = 7;
pub const GST_RTP_PAYLOAD_PCMA: GstRTPPayload = 8;
pub const GST_RTP_PAYLOAD_G722: GstRTPPayload = 9;
pub const GST_RTP_PAYLOAD_L16_STEREO: GstRTPPayload = 10;
pub const GST_RTP_PAYLOAD_L16_MONO: GstRTPPayload = 11;
pub const GST_RTP_PAYLOAD_QCELP: GstRTPPayload = 12;
pub const GST_RTP_PAYLOAD_CN: GstRTPPayload = 13;
pub const GST_RTP_PAYLOAD_MPA: GstRTPPayload = 14;
pub const GST_RTP_PAYLOAD_G728: GstRTPPayload = 15;
pub const GST_RTP_PAYLOAD_DVI4_11025: GstRTPPayload = 16;
pub const GST_RTP_PAYLOAD_DVI4_22050: GstRTPPayload = 17;
pub const GST_RTP_PAYLOAD_G729: GstRTPPayload = 18;
pub const GST_RTP_PAYLOAD_CELLB: GstRTPPayload = 25;
pub const GST_RTP_PAYLOAD_JPEG: GstRTPPayload = 26;
pub const GST_RTP_PAYLOAD_NV: GstRTPPayload = 28;
pub const GST_RTP_PAYLOAD_H261: GstRTPPayload = 31;
pub const GST_RTP_PAYLOAD_MPV: GstRTPPayload = 32;
pub const GST_RTP_PAYLOAD_MP2T: GstRTPPayload = 33;
pub const GST_RTP_PAYLOAD_H263: GstRTPPayload = 34;

pub type GstRTPProfile = c_int;
pub const GST_RTP_PROFILE_UNKNOWN: GstRTPProfile = 0;
pub const GST_RTP_PROFILE_AVP: GstRTPProfile = 1;
pub const GST_RTP_PROFILE_SAVP: GstRTPProfile = 2;
pub const GST_RTP_PROFILE_AVPF: GstRTPProfile = 3;
pub const GST_RTP_PROFILE_SAVPF: GstRTPProfile = 4;

// Constants
pub const GST_RTCP_MAX_BYE_SSRC_COUNT: c_int = 31;
pub const GST_RTCP_MAX_RB_COUNT: c_int = 31;
pub const GST_RTCP_MAX_SDES: c_int = 255;
pub const GST_RTCP_MAX_SDES_ITEM_COUNT: c_int = 31;
pub const GST_RTCP_REDUCED_SIZE_VALID_MASK: c_int = 49400;
pub const GST_RTCP_VALID_MASK: c_int = 57598;
pub const GST_RTCP_VALID_VALUE: c_int = 200;
pub const GST_RTCP_VERSION: c_int = 2;
pub const GST_RTP_HDREXT_BASE: &[u8] = b"urn:ietf:params:rtp-hdrext:\0";
pub const GST_RTP_HDREXT_ELEMENT_CLASS: &[u8] = b"Network/Extension/RTPHeader\0";
pub const GST_RTP_HDREXT_NTP_56: &[u8] = b"ntp-56\0";
pub const GST_RTP_HDREXT_NTP_56_SIZE: c_int = 7;
pub const GST_RTP_HDREXT_NTP_64: &[u8] = b"ntp-64\0";
pub const GST_RTP_HDREXT_NTP_64_SIZE: c_int = 8;
pub const GST_RTP_HEADER_EXTENSION_URI_METADATA_KEY: &[u8] = b"RTP-Header-Extension-URI\0";
pub const GST_RTP_PAYLOAD_1016_STRING: &[u8] = b"1\0";
pub const GST_RTP_PAYLOAD_CELLB_STRING: &[u8] = b"25\0";
pub const GST_RTP_PAYLOAD_CN_STRING: &[u8] = b"13\0";
pub const GST_RTP_PAYLOAD_DVI4_11025_STRING: &[u8] = b"16\0";
pub const GST_RTP_PAYLOAD_DVI4_16000_STRING: &[u8] = b"6\0";
pub const GST_RTP_PAYLOAD_DVI4_22050_STRING: &[u8] = b"17\0";
pub const GST_RTP_PAYLOAD_DVI4_8000_STRING: &[u8] = b"5\0";
pub const GST_RTP_PAYLOAD_DYNAMIC_STRING: &[u8] = b"[96, 127]\0";
pub const GST_RTP_PAYLOAD_G721_STRING: &[u8] = b"2\0";
pub const GST_RTP_PAYLOAD_G722_STRING: &[u8] = b"9\0";
pub const GST_RTP_PAYLOAD_G723_53: c_int = 17;
pub const GST_RTP_PAYLOAD_G723_53_STRING: &[u8] = b"17\0";
pub const GST_RTP_PAYLOAD_G723_63: c_int = 16;
pub const GST_RTP_PAYLOAD_G723_63_STRING: &[u8] = b"16\0";
pub const GST_RTP_PAYLOAD_G723_STRING: &[u8] = b"4\0";
pub const GST_RTP_PAYLOAD_G728_STRING: &[u8] = b"15\0";
pub const GST_RTP_PAYLOAD_G729_STRING: &[u8] = b"18\0";
pub const GST_RTP_PAYLOAD_GSM_STRING: &[u8] = b"3\0";
pub const GST_RTP_PAYLOAD_H261_STRING: &[u8] = b"31\0";
pub const GST_RTP_PAYLOAD_H263_STRING: &[u8] = b"34\0";
pub const GST_RTP_PAYLOAD_JPEG_STRING: &[u8] = b"26\0";
pub const GST_RTP_PAYLOAD_L16_MONO_STRING: &[u8] = b"11\0";
pub const GST_RTP_PAYLOAD_L16_STEREO_STRING: &[u8] = b"10\0";
pub const GST_RTP_PAYLOAD_LPC_STRING: &[u8] = b"7\0";
pub const GST_RTP_PAYLOAD_MP2T_STRING: &[u8] = b"33\0";
pub const GST_RTP_PAYLOAD_MPA_STRING: &[u8] = b"14\0";
pub const GST_RTP_PAYLOAD_MPV_STRING: &[u8] = b"32\0";
pub const GST_RTP_PAYLOAD_NV_STRING: &[u8] = b"28\0";
pub const GST_RTP_PAYLOAD_PCMA_STRING: &[u8] = b"8\0";
pub const GST_RTP_PAYLOAD_PCMU_STRING: &[u8] = b"0\0";
pub const GST_RTP_PAYLOAD_QCELP_STRING: &[u8] = b"12\0";
pub const GST_RTP_PAYLOAD_TS41: c_int = 19;
pub const GST_RTP_PAYLOAD_TS41_STRING: &[u8] = b"19\0";
pub const GST_RTP_PAYLOAD_TS48: c_int = 18;
pub const GST_RTP_PAYLOAD_TS48_STRING: &[u8] = b"18\0";
pub const GST_RTP_SOURCE_META_MAX_CSRC_COUNT: c_int = 15;
pub const GST_RTP_VERSION: c_int = 2;

// Flags
pub type GstRTPBufferFlags = c_uint;
pub const GST_RTP_BUFFER_FLAG_RETRANSMISSION: GstRTPBufferFlags = 1048576;
pub const GST_RTP_BUFFER_FLAG_REDUNDANT: GstRTPBufferFlags = 2097152;
pub const GST_RTP_BUFFER_FLAG_LAST: GstRTPBufferFlags = 268435456;

pub type GstRTPBufferMapFlags = c_uint;
pub const GST_RTP_BUFFER_MAP_FLAG_SKIP_PADDING: GstRTPBufferMapFlags = 65536;
pub const GST_RTP_BUFFER_MAP_FLAG_LAST: GstRTPBufferMapFlags = 16777216;

pub type GstRTPHeaderExtensionDirection = c_uint;
pub const GST_RTP_HEADER_EXTENSION_DIRECTION_INACTIVE: GstRTPHeaderExtensionDirection = 0;
pub const GST_RTP_HEADER_EXTENSION_DIRECTION_SENDONLY: GstRTPHeaderExtensionDirection = 1;
pub const GST_RTP_HEADER_EXTENSION_DIRECTION_RECVONLY: GstRTPHeaderExtensionDirection = 2;
pub const GST_RTP_HEADER_EXTENSION_DIRECTION_SENDRECV: GstRTPHeaderExtensionDirection = 3;
pub const GST_RTP_HEADER_EXTENSION_DIRECTION_INHERITED: GstRTPHeaderExtensionDirection = 4;

pub type GstRTPHeaderExtensionFlags = c_uint;
pub const GST_RTP_HEADER_EXTENSION_ONE_BYTE: GstRTPHeaderExtensionFlags = 1;
pub const GST_RTP_HEADER_EXTENSION_TWO_BYTE: GstRTPHeaderExtensionFlags = 2;

// Records
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTCPBuffer {
    pub buffer: *mut gst::GstBuffer,
    pub map: gst::GstMapInfo,
}

impl ::std::fmt::Debug for GstRTCPBuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTCPBuffer @ {self:p}"))
            .field("buffer", &self.buffer)
            .field("map", &self.map)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTCPPacket {
    pub rtcp: *mut GstRTCPBuffer,
    pub offset: c_uint,
    pub padding: gboolean,
    pub count: u8,
    pub type_: GstRTCPType,
    pub length: u16,
    pub item_offset: c_uint,
    pub item_count: c_uint,
    pub entry_offset: c_uint,
}

impl ::std::fmt::Debug for GstRTCPPacket {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTCPPacket @ {self:p}"))
            .field("rtcp", &self.rtcp)
            .field("offset", &self.offset)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBaseAudioPayloadClass {
    pub parent_class: GstRTPBasePayloadClass,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPBaseAudioPayloadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBaseAudioPayloadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
pub struct _GstRTPBaseAudioPayloadPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstRTPBaseAudioPayloadPrivate = _GstRTPBaseAudioPayloadPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBaseDepayloadClass {
    pub parent_class: gst::GstElementClass,
    pub set_caps:
        Option<unsafe extern "C" fn(*mut GstRTPBaseDepayload, *mut gst::GstCaps) -> gboolean>,
    pub process: Option<
        unsafe extern "C" fn(*mut GstRTPBaseDepayload, *mut gst::GstBuffer) -> *mut gst::GstBuffer,
    >,
    pub packet_lost:
        Option<unsafe extern "C" fn(*mut GstRTPBaseDepayload, *mut gst::GstEvent) -> gboolean>,
    pub handle_event:
        Option<unsafe extern "C" fn(*mut GstRTPBaseDepayload, *mut gst::GstEvent) -> gboolean>,
    pub process_rtp_packet: Option<
        unsafe extern "C" fn(*mut GstRTPBaseDepayload, *mut GstRTPBuffer) -> *mut gst::GstBuffer,
    >,
    pub _gst_reserved: [gpointer; 3],
}

impl ::std::fmt::Debug for GstRTPBaseDepayloadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBaseDepayloadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("set_caps", &self.set_caps)
            .field("process", &self.process)
            .field("packet_lost", &self.packet_lost)
            .field("handle_event", &self.handle_event)
            .field("process_rtp_packet", &self.process_rtp_packet)
            .finish()
    }
}

#[repr(C)]
pub struct _GstRTPBaseDepayloadPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstRTPBaseDepayloadPrivate = _GstRTPBaseDepayloadPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBasePayloadClass {
    pub parent_class: gst::GstElementClass,
    pub get_caps: Option<
        unsafe extern "C" fn(
            *mut GstRTPBasePayload,
            *mut gst::GstPad,
            *mut gst::GstCaps,
        ) -> *mut gst::GstCaps,
    >,
    pub set_caps:
        Option<unsafe extern "C" fn(*mut GstRTPBasePayload, *mut gst::GstCaps) -> gboolean>,
    pub handle_buffer: Option<
        unsafe extern "C" fn(*mut GstRTPBasePayload, *mut gst::GstBuffer) -> gst::GstFlowReturn,
    >,
    pub sink_event:
        Option<unsafe extern "C" fn(*mut GstRTPBasePayload, *mut gst::GstEvent) -> gboolean>,
    pub src_event:
        Option<unsafe extern "C" fn(*mut GstRTPBasePayload, *mut gst::GstEvent) -> gboolean>,
    pub query: Option<
        unsafe extern "C" fn(
            *mut GstRTPBasePayload,
            *mut gst::GstPad,
            *mut gst::GstQuery,
        ) -> gboolean,
    >,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPBasePayloadClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBasePayloadClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("get_caps", &self.get_caps)
            .field("set_caps", &self.set_caps)
            .field("handle_buffer", &self.handle_buffer)
            .field("sink_event", &self.sink_event)
            .field("src_event", &self.src_event)
            .field("query", &self.query)
            .finish()
    }
}

#[repr(C)]
pub struct _GstRTPBasePayloadPrivate {
    _data: [u8; 0],
    _marker: core::marker::PhantomData<(*mut u8, core::marker::PhantomPinned)>,
}

pub type GstRTPBasePayloadPrivate = _GstRTPBasePayloadPrivate;

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBuffer {
    pub buffer: *mut gst::GstBuffer,
    pub state: c_uint,
    pub data: [gpointer; 4],
    pub size: [size_t; 4],
    pub map: [gst::GstMapInfo; 4],
}

impl ::std::fmt::Debug for GstRTPBuffer {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBuffer @ {self:p}"))
            .field("buffer", &self.buffer)
            .field("state", &self.state)
            .field("data", &self.data)
            .field("size", &self.size)
            .field("map", &self.map)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPHeaderExtensionClass {
    pub parent_class: gst::GstElementClass,
    pub get_supported_flags:
        Option<unsafe extern "C" fn(*mut GstRTPHeaderExtension) -> GstRTPHeaderExtensionFlags>,
    pub get_max_size:
        Option<unsafe extern "C" fn(*mut GstRTPHeaderExtension, *const gst::GstBuffer) -> size_t>,
    pub write: Option<
        unsafe extern "C" fn(
            *mut GstRTPHeaderExtension,
            *const gst::GstBuffer,
            GstRTPHeaderExtensionFlags,
            *mut gst::GstBuffer,
            *mut u8,
            size_t,
        ) -> ssize_t,
    >,
    pub read: Option<
        unsafe extern "C" fn(
            *mut GstRTPHeaderExtension,
            GstRTPHeaderExtensionFlags,
            *const u8,
            size_t,
            *mut gst::GstBuffer,
        ) -> gboolean,
    >,
    pub set_non_rtp_sink_caps:
        Option<unsafe extern "C" fn(*mut GstRTPHeaderExtension, *mut gst::GstCaps) -> gboolean>,
    pub update_non_rtp_src_caps:
        Option<unsafe extern "C" fn(*mut GstRTPHeaderExtension, *mut gst::GstCaps) -> gboolean>,
    pub set_attributes: Option<
        unsafe extern "C" fn(
            *mut GstRTPHeaderExtension,
            GstRTPHeaderExtensionDirection,
            *const c_char,
        ) -> gboolean,
    >,
    pub set_caps_from_attributes:
        Option<unsafe extern "C" fn(*mut GstRTPHeaderExtension, *mut gst::GstCaps) -> gboolean>,
    pub _gst_reserved: [gpointer; 20],
}

impl ::std::fmt::Debug for GstRTPHeaderExtensionClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPHeaderExtensionClass @ {self:p}"))
            .field("parent_class", &self.parent_class)
            .field("get_supported_flags", &self.get_supported_flags)
            .field("get_max_size", &self.get_max_size)
            .field("write", &self.write)
            .field("read", &self.read)
            .field("set_non_rtp_sink_caps", &self.set_non_rtp_sink_caps)
            .field("update_non_rtp_src_caps", &self.update_non_rtp_src_caps)
            .field("set_attributes", &self.set_attributes)
            .field("set_caps_from_attributes", &self.set_caps_from_attributes)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPPayloadInfo {
    pub payload_type: u8,
    pub media: *const c_char,
    pub encoding_name: *const c_char,
    pub clock_rate: c_uint,
    pub encoding_parameters: *const c_char,
    pub bitrate: c_uint,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPPayloadInfo {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPPayloadInfo @ {self:p}"))
            .field("payload_type", &self.payload_type)
            .field("media", &self.media)
            .field("encoding_name", &self.encoding_name)
            .field("clock_rate", &self.clock_rate)
            .field("encoding_parameters", &self.encoding_parameters)
            .field("bitrate", &self.bitrate)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPSourceMeta {
    pub meta: gst::GstMeta,
    pub ssrc: u32,
    pub ssrc_valid: gboolean,
    pub csrc: [u32; 15],
    pub csrc_count: c_uint,
}

impl ::std::fmt::Debug for GstRTPSourceMeta {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPSourceMeta @ {self:p}"))
            .field("meta", &self.meta)
            .field("ssrc", &self.ssrc)
            .field("ssrc_valid", &self.ssrc_valid)
            .field("csrc", &self.csrc)
            .field("csrc_count", &self.csrc_count)
            .finish()
    }
}

// Classes
#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBaseAudioPayload {
    pub payload: GstRTPBasePayload,
    pub priv_: *mut GstRTPBaseAudioPayloadPrivate,
    pub base_ts: gst::GstClockTime,
    pub frame_size: c_int,
    pub frame_duration: c_int,
    pub sample_size: c_int,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPBaseAudioPayload {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBaseAudioPayload @ {self:p}"))
            .field("payload", &self.payload)
            .field("priv_", &self.priv_)
            .field("base_ts", &self.base_ts)
            .field("frame_size", &self.frame_size)
            .field("frame_duration", &self.frame_duration)
            .field("sample_size", &self.sample_size)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBaseDepayload {
    pub parent: gst::GstElement,
    pub sinkpad: *mut gst::GstPad,
    pub srcpad: *mut gst::GstPad,
    pub clock_rate: c_uint,
    pub segment: gst::GstSegment,
    pub need_newsegment: gboolean,
    pub priv_: *mut GstRTPBaseDepayloadPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPBaseDepayload {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBaseDepayload @ {self:p}"))
            .field("parent", &self.parent)
            .field("sinkpad", &self.sinkpad)
            .field("srcpad", &self.srcpad)
            .field("clock_rate", &self.clock_rate)
            .field("segment", &self.segment)
            .field("need_newsegment", &self.need_newsegment)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPBasePayload {
    pub element: gst::GstElement,
    pub sinkpad: *mut gst::GstPad,
    pub srcpad: *mut gst::GstPad,
    pub ts_base: u32,
    pub seqnum_base: u16,
    pub media: *mut c_char,
    pub encoding_name: *mut c_char,
    pub dynamic: gboolean,
    pub clock_rate: u32,
    pub ts_offset: i32,
    pub timestamp: u32,
    pub seqnum_offset: i16,
    pub seqnum: u16,
    pub max_ptime: i64,
    pub pt: c_uint,
    pub ssrc: c_uint,
    pub current_ssrc: c_uint,
    pub mtu: c_uint,
    pub segment: gst::GstSegment,
    pub min_ptime: u64,
    pub ptime: u64,
    pub ptime_multiple: u64,
    pub priv_: *mut GstRTPBasePayloadPrivate,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPBasePayload {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPBasePayload @ {self:p}"))
            .field("element", &self.element)
            .finish()
    }
}

#[derive(Copy, Clone)]
#[repr(C)]
pub struct GstRTPHeaderExtension {
    pub parent: gst::GstElement,
    pub _gst_reserved: [gpointer; 4],
}

impl ::std::fmt::Debug for GstRTPHeaderExtension {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("GstRTPHeaderExtension @ {self:p}"))
            .field("parent", &self.parent)
            .finish()
    }
}

#[link(name = "gstrtp-1.0")]
extern "C" {

    //=========================================================================
    // GstRTCPFBType
    //=========================================================================
    pub fn gst_rtcpfb_type_get_type() -> GType;

    //=========================================================================
    // GstRTCPSDESType
    //=========================================================================
    pub fn gst_rtcpsdes_type_get_type() -> GType;

    //=========================================================================
    // GstRTCPType
    //=========================================================================
    pub fn gst_rtcp_type_get_type() -> GType;

    //=========================================================================
    // GstRTCPXRType
    //=========================================================================
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcpxr_type_get_type() -> GType;

    //=========================================================================
    // GstRTPPayload
    //=========================================================================
    pub fn gst_rtp_payload_get_type() -> GType;

    //=========================================================================
    // GstRTPProfile
    //=========================================================================
    pub fn gst_rtp_profile_get_type() -> GType;

    //=========================================================================
    // GstRTPBufferFlags
    //=========================================================================
    pub fn gst_rtp_buffer_flags_get_type() -> GType;

    //=========================================================================
    // GstRTPBufferMapFlags
    //=========================================================================
    pub fn gst_rtp_buffer_map_flags_get_type() -> GType;

    //=========================================================================
    // GstRTPHeaderExtensionDirection
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_direction_get_type() -> GType;

    //=========================================================================
    // GstRTPHeaderExtensionFlags
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_flags_get_type() -> GType;

    //=========================================================================
    // GstRTCPBuffer
    //=========================================================================
    pub fn gst_rtcp_buffer_add_packet(
        rtcp: *mut GstRTCPBuffer,
        type_: GstRTCPType,
        packet: *mut GstRTCPPacket,
    ) -> gboolean;
    pub fn gst_rtcp_buffer_get_first_packet(
        rtcp: *mut GstRTCPBuffer,
        packet: *mut GstRTCPPacket,
    ) -> gboolean;
    pub fn gst_rtcp_buffer_get_packet_count(rtcp: *mut GstRTCPBuffer) -> c_uint;
    pub fn gst_rtcp_buffer_unmap(rtcp: *mut GstRTCPBuffer) -> gboolean;
    pub fn gst_rtcp_buffer_map(
        buffer: *mut gst::GstBuffer,
        flags: gst::GstMapFlags,
        rtcp: *mut GstRTCPBuffer,
    ) -> gboolean;
    pub fn gst_rtcp_buffer_new(mtu: c_uint) -> *mut gst::GstBuffer;
    pub fn gst_rtcp_buffer_new_copy_data(data: gconstpointer, len: c_uint) -> *mut gst::GstBuffer;
    pub fn gst_rtcp_buffer_new_take_data(data: gpointer, len: c_uint) -> *mut gst::GstBuffer;
    pub fn gst_rtcp_buffer_validate(buffer: *mut gst::GstBuffer) -> gboolean;
    pub fn gst_rtcp_buffer_validate_data(data: *mut u8, len: c_uint) -> gboolean;
    pub fn gst_rtcp_buffer_validate_data_reduced(data: *mut u8, len: c_uint) -> gboolean;
    pub fn gst_rtcp_buffer_validate_reduced(buffer: *mut gst::GstBuffer) -> gboolean;

    //=========================================================================
    // GstRTCPPacket
    //=========================================================================
    pub fn gst_rtcp_packet_add_profile_specific_ext(
        packet: *mut GstRTCPPacket,
        data: *const u8,
        len: c_uint,
    ) -> gboolean;
    pub fn gst_rtcp_packet_add_rb(
        packet: *mut GstRTCPPacket,
        ssrc: u32,
        fractionlost: u8,
        packetslost: i32,
        exthighestseq: u32,
        jitter: u32,
        lsr: u32,
        dlsr: u32,
    ) -> gboolean;
    pub fn gst_rtcp_packet_app_get_data(packet: *mut GstRTCPPacket) -> *mut u8;
    pub fn gst_rtcp_packet_app_get_data_length(packet: *mut GstRTCPPacket) -> u16;
    pub fn gst_rtcp_packet_app_get_name(packet: *mut GstRTCPPacket) -> *const c_char;
    pub fn gst_rtcp_packet_app_get_ssrc(packet: *mut GstRTCPPacket) -> u32;
    pub fn gst_rtcp_packet_app_get_subtype(packet: *mut GstRTCPPacket) -> u8;
    pub fn gst_rtcp_packet_app_set_data_length(
        packet: *mut GstRTCPPacket,
        wordlen: u16,
    ) -> gboolean;
    pub fn gst_rtcp_packet_app_set_name(packet: *mut GstRTCPPacket, name: *const c_char);
    pub fn gst_rtcp_packet_app_set_ssrc(packet: *mut GstRTCPPacket, ssrc: u32);
    pub fn gst_rtcp_packet_app_set_subtype(packet: *mut GstRTCPPacket, subtype: u8);
    pub fn gst_rtcp_packet_bye_add_ssrc(packet: *mut GstRTCPPacket, ssrc: u32) -> gboolean;
    pub fn gst_rtcp_packet_bye_add_ssrcs(
        packet: *mut GstRTCPPacket,
        ssrc: *mut u32,
        len: c_uint,
    ) -> gboolean;
    pub fn gst_rtcp_packet_bye_get_nth_ssrc(packet: *mut GstRTCPPacket, nth: c_uint) -> u32;
    pub fn gst_rtcp_packet_bye_get_reason(packet: *mut GstRTCPPacket) -> *mut c_char;
    pub fn gst_rtcp_packet_bye_get_reason_len(packet: *mut GstRTCPPacket) -> u8;
    pub fn gst_rtcp_packet_bye_get_ssrc_count(packet: *mut GstRTCPPacket) -> c_uint;
    pub fn gst_rtcp_packet_bye_set_reason(
        packet: *mut GstRTCPPacket,
        reason: *const c_char,
    ) -> gboolean;
    pub fn gst_rtcp_packet_copy_profile_specific_ext(
        packet: *mut GstRTCPPacket,
        data: *mut *mut u8,
        len: *mut c_uint,
    ) -> gboolean;
    pub fn gst_rtcp_packet_fb_get_fci(packet: *mut GstRTCPPacket) -> *mut u8;
    pub fn gst_rtcp_packet_fb_get_fci_length(packet: *mut GstRTCPPacket) -> u16;
    pub fn gst_rtcp_packet_fb_get_media_ssrc(packet: *mut GstRTCPPacket) -> u32;
    pub fn gst_rtcp_packet_fb_get_sender_ssrc(packet: *mut GstRTCPPacket) -> u32;
    pub fn gst_rtcp_packet_fb_get_type(packet: *mut GstRTCPPacket) -> GstRTCPFBType;
    pub fn gst_rtcp_packet_fb_set_fci_length(packet: *mut GstRTCPPacket, wordlen: u16) -> gboolean;
    pub fn gst_rtcp_packet_fb_set_media_ssrc(packet: *mut GstRTCPPacket, ssrc: u32);
    pub fn gst_rtcp_packet_fb_set_sender_ssrc(packet: *mut GstRTCPPacket, ssrc: u32);
    pub fn gst_rtcp_packet_fb_set_type(packet: *mut GstRTCPPacket, type_: GstRTCPFBType);
    pub fn gst_rtcp_packet_get_count(packet: *mut GstRTCPPacket) -> u8;
    pub fn gst_rtcp_packet_get_length(packet: *mut GstRTCPPacket) -> u16;
    pub fn gst_rtcp_packet_get_padding(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_get_profile_specific_ext(
        packet: *mut GstRTCPPacket,
        data: *mut *mut u8,
        len: *mut c_uint,
    ) -> gboolean;
    pub fn gst_rtcp_packet_get_profile_specific_ext_length(packet: *mut GstRTCPPacket) -> u16;
    pub fn gst_rtcp_packet_get_rb(
        packet: *mut GstRTCPPacket,
        nth: c_uint,
        ssrc: *mut u32,
        fractionlost: *mut u8,
        packetslost: *mut i32,
        exthighestseq: *mut u32,
        jitter: *mut u32,
        lsr: *mut u32,
        dlsr: *mut u32,
    );
    pub fn gst_rtcp_packet_get_rb_count(packet: *mut GstRTCPPacket) -> c_uint;
    pub fn gst_rtcp_packet_get_type(packet: *mut GstRTCPPacket) -> GstRTCPType;
    pub fn gst_rtcp_packet_move_to_next(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_remove(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_rr_get_ssrc(packet: *mut GstRTCPPacket) -> u32;
    pub fn gst_rtcp_packet_rr_set_ssrc(packet: *mut GstRTCPPacket, ssrc: u32);
    pub fn gst_rtcp_packet_sdes_add_entry(
        packet: *mut GstRTCPPacket,
        type_: GstRTCPSDESType,
        len: u8,
        data: *const u8,
    ) -> gboolean;
    pub fn gst_rtcp_packet_sdes_add_item(packet: *mut GstRTCPPacket, ssrc: u32) -> gboolean;
    pub fn gst_rtcp_packet_sdes_copy_entry(
        packet: *mut GstRTCPPacket,
        type_: *mut GstRTCPSDESType,
        len: *mut u8,
        data: *mut *mut u8,
    ) -> gboolean;
    pub fn gst_rtcp_packet_sdes_first_entry(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_sdes_first_item(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_sdes_get_entry(
        packet: *mut GstRTCPPacket,
        type_: *mut GstRTCPSDESType,
        len: *mut u8,
        data: *mut *mut u8,
    ) -> gboolean;
    pub fn gst_rtcp_packet_sdes_get_item_count(packet: *mut GstRTCPPacket) -> c_uint;
    pub fn gst_rtcp_packet_sdes_get_ssrc(packet: *mut GstRTCPPacket) -> u32;
    pub fn gst_rtcp_packet_sdes_next_entry(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_sdes_next_item(packet: *mut GstRTCPPacket) -> gboolean;
    pub fn gst_rtcp_packet_set_rb(
        packet: *mut GstRTCPPacket,
        nth: c_uint,
        ssrc: u32,
        fractionlost: u8,
        packetslost: i32,
        exthighestseq: u32,
        jitter: u32,
        lsr: u32,
        dlsr: u32,
    );
    pub fn gst_rtcp_packet_sr_get_sender_info(
        packet: *mut GstRTCPPacket,
        ssrc: *mut u32,
        ntptime: *mut u64,
        rtptime: *mut u32,
        packet_count: *mut u32,
        octet_count: *mut u32,
    );
    pub fn gst_rtcp_packet_sr_set_sender_info(
        packet: *mut GstRTCPPacket,
        ssrc: u32,
        ntptime: u64,
        rtptime: u32,
        packet_count: u32,
        octet_count: u32,
    );
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_first_rb(packet: *mut GstRTCPPacket) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_block_length(packet: *mut GstRTCPPacket) -> u16;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_block_type(packet: *mut GstRTCPPacket) -> GstRTCPXRType;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_dlrr_block(
        packet: *mut GstRTCPPacket,
        nth: c_uint,
        ssrc: *mut u32,
        last_rr: *mut u32,
        delay: *mut u32,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_prt_by_seq(
        packet: *mut GstRTCPPacket,
        seq: u16,
        receipt_time: *mut u32,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_prt_info(
        packet: *mut GstRTCPPacket,
        ssrc: *mut u32,
        thinning: *mut u8,
        begin_seq: *mut u16,
        end_seq: *mut u16,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_rle_info(
        packet: *mut GstRTCPPacket,
        ssrc: *mut u32,
        thinning: *mut u8,
        begin_seq: *mut u16,
        end_seq: *mut u16,
        chunk_count: *mut u32,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_rle_nth_chunk(
        packet: *mut GstRTCPPacket,
        nth: c_uint,
        chunk: *mut u16,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_rrt(packet: *mut GstRTCPPacket, timestamp: *mut u64) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_ssrc(packet: *mut GstRTCPPacket) -> u32;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_summary_info(
        packet: *mut GstRTCPPacket,
        ssrc: *mut u32,
        begin_seq: *mut u16,
        end_seq: *mut u16,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_summary_jitter(
        packet: *mut GstRTCPPacket,
        min_jitter: *mut u32,
        max_jitter: *mut u32,
        mean_jitter: *mut u32,
        dev_jitter: *mut u32,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_summary_pkt(
        packet: *mut GstRTCPPacket,
        lost_packets: *mut u32,
        dup_packets: *mut u32,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_summary_ttl(
        packet: *mut GstRTCPPacket,
        is_ipv4: *mut gboolean,
        min_ttl: *mut u8,
        max_ttl: *mut u8,
        mean_ttl: *mut u8,
        dev_ttl: *mut u8,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_burst_metrics(
        packet: *mut GstRTCPPacket,
        burst_density: *mut u8,
        gap_density: *mut u8,
        burst_duration: *mut u16,
        gap_duration: *mut u16,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_configuration_params(
        packet: *mut GstRTCPPacket,
        gmin: *mut u8,
        rx_config: *mut u8,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_delay_metrics(
        packet: *mut GstRTCPPacket,
        roundtrip_delay: *mut u16,
        end_system_delay: *mut u16,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_jitter_buffer_params(
        packet: *mut GstRTCPPacket,
        jb_nominal: *mut u16,
        jb_maximum: *mut u16,
        jb_abs_max: *mut u16,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_metrics_ssrc(
        packet: *mut GstRTCPPacket,
        ssrc: *mut u32,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_packet_metrics(
        packet: *mut GstRTCPPacket,
        loss_rate: *mut u8,
        discard_rate: *mut u8,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_quality_metrics(
        packet: *mut GstRTCPPacket,
        r_factor: *mut u8,
        ext_r_factor: *mut u8,
        mos_lq: *mut u8,
        mos_cq: *mut u8,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_get_voip_signal_metrics(
        packet: *mut GstRTCPPacket,
        signal_level: *mut u8,
        noise_level: *mut u8,
        rerl: *mut u8,
        gmin: *mut u8,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtcp_packet_xr_next_rb(packet: *mut GstRTCPPacket) -> gboolean;

    //=========================================================================
    // GstRTPBuffer
    //=========================================================================
    pub fn gst_rtp_buffer_add_extension_onebyte_header(
        rtp: *mut GstRTPBuffer,
        id: u8,
        data: gconstpointer,
        size: c_uint,
    ) -> gboolean;
    pub fn gst_rtp_buffer_add_extension_twobytes_header(
        rtp: *mut GstRTPBuffer,
        appbits: u8,
        id: u8,
        data: gconstpointer,
        size: c_uint,
    ) -> gboolean;
    pub fn gst_rtp_buffer_get_csrc(rtp: *mut GstRTPBuffer, idx: u8) -> u32;
    pub fn gst_rtp_buffer_get_csrc_count(rtp: *mut GstRTPBuffer) -> u8;
    pub fn gst_rtp_buffer_get_extension(rtp: *mut GstRTPBuffer) -> gboolean;
    pub fn gst_rtp_buffer_get_extension_bytes(
        rtp: *mut GstRTPBuffer,
        bits: *mut u16,
    ) -> *mut glib::GBytes;
    pub fn gst_rtp_buffer_get_extension_data(
        rtp: *mut GstRTPBuffer,
        bits: *mut u16,
        data: *mut u8,
        wordlen: *mut c_uint,
    ) -> gboolean;
    pub fn gst_rtp_buffer_get_extension_onebyte_header(
        rtp: *mut GstRTPBuffer,
        id: u8,
        nth: c_uint,
        data: *mut u8,
        size: *mut c_uint,
    ) -> gboolean;
    pub fn gst_rtp_buffer_get_extension_twobytes_header(
        rtp: *mut GstRTPBuffer,
        appbits: *mut u8,
        id: u8,
        nth: c_uint,
        data: *mut u8,
        size: *mut c_uint,
    ) -> gboolean;
    pub fn gst_rtp_buffer_get_header_len(rtp: *mut GstRTPBuffer) -> c_uint;
    pub fn gst_rtp_buffer_get_marker(rtp: *mut GstRTPBuffer) -> gboolean;
    pub fn gst_rtp_buffer_get_packet_len(rtp: *mut GstRTPBuffer) -> c_uint;
    pub fn gst_rtp_buffer_get_padding(rtp: *mut GstRTPBuffer) -> gboolean;
    pub fn gst_rtp_buffer_get_payload(rtp: *mut GstRTPBuffer) -> gpointer;
    pub fn gst_rtp_buffer_get_payload_buffer(rtp: *mut GstRTPBuffer) -> *mut gst::GstBuffer;
    pub fn gst_rtp_buffer_get_payload_bytes(rtp: *mut GstRTPBuffer) -> *mut glib::GBytes;
    pub fn gst_rtp_buffer_get_payload_len(rtp: *mut GstRTPBuffer) -> c_uint;
    pub fn gst_rtp_buffer_get_payload_subbuffer(
        rtp: *mut GstRTPBuffer,
        offset: c_uint,
        len: c_uint,
    ) -> *mut gst::GstBuffer;
    pub fn gst_rtp_buffer_get_payload_type(rtp: *mut GstRTPBuffer) -> u8;
    pub fn gst_rtp_buffer_get_seq(rtp: *mut GstRTPBuffer) -> u16;
    pub fn gst_rtp_buffer_get_ssrc(rtp: *mut GstRTPBuffer) -> u32;
    pub fn gst_rtp_buffer_get_timestamp(rtp: *mut GstRTPBuffer) -> u32;
    pub fn gst_rtp_buffer_get_version(rtp: *mut GstRTPBuffer) -> u8;
    pub fn gst_rtp_buffer_pad_to(rtp: *mut GstRTPBuffer, len: c_uint);
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_buffer_remove_extension_data(rtp: *mut GstRTPBuffer);
    pub fn gst_rtp_buffer_set_csrc(rtp: *mut GstRTPBuffer, idx: u8, csrc: u32);
    pub fn gst_rtp_buffer_set_extension(rtp: *mut GstRTPBuffer, extension: gboolean);
    pub fn gst_rtp_buffer_set_extension_data(
        rtp: *mut GstRTPBuffer,
        bits: u16,
        length: u16,
    ) -> gboolean;
    pub fn gst_rtp_buffer_set_marker(rtp: *mut GstRTPBuffer, marker: gboolean);
    pub fn gst_rtp_buffer_set_packet_len(rtp: *mut GstRTPBuffer, len: c_uint);
    pub fn gst_rtp_buffer_set_padding(rtp: *mut GstRTPBuffer, padding: gboolean);
    pub fn gst_rtp_buffer_set_payload_type(rtp: *mut GstRTPBuffer, payload_type: u8);
    pub fn gst_rtp_buffer_set_seq(rtp: *mut GstRTPBuffer, seq: u16);
    pub fn gst_rtp_buffer_set_ssrc(rtp: *mut GstRTPBuffer, ssrc: u32);
    pub fn gst_rtp_buffer_set_timestamp(rtp: *mut GstRTPBuffer, timestamp: u32);
    pub fn gst_rtp_buffer_set_version(rtp: *mut GstRTPBuffer, version: u8);
    pub fn gst_rtp_buffer_unmap(rtp: *mut GstRTPBuffer);
    pub fn gst_rtp_buffer_allocate_data(
        buffer: *mut gst::GstBuffer,
        payload_len: c_uint,
        pad_len: u8,
        csrc_count: u8,
    );
    pub fn gst_rtp_buffer_calc_header_len(csrc_count: u8) -> c_uint;
    pub fn gst_rtp_buffer_calc_packet_len(
        payload_len: c_uint,
        pad_len: u8,
        csrc_count: u8,
    ) -> c_uint;
    pub fn gst_rtp_buffer_calc_payload_len(
        packet_len: c_uint,
        pad_len: u8,
        csrc_count: u8,
    ) -> c_uint;
    pub fn gst_rtp_buffer_compare_seqnum(seqnum1: u16, seqnum2: u16) -> c_int;
    pub fn gst_rtp_buffer_default_clock_rate(payload_type: u8) -> u32;
    pub fn gst_rtp_buffer_ext_timestamp(exttimestamp: *mut u64, timestamp: u32) -> u64;
    #[cfg(feature = "v1_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    pub fn gst_rtp_buffer_get_extension_onebyte_header_from_bytes(
        bytes: *mut glib::GBytes,
        bit_pattern: u16,
        id: u8,
        nth: c_uint,
        data: *mut u8,
        size: *mut c_uint,
    ) -> gboolean;
    pub fn gst_rtp_buffer_map(
        buffer: *mut gst::GstBuffer,
        flags: gst::GstMapFlags,
        rtp: *mut GstRTPBuffer,
    ) -> gboolean;
    pub fn gst_rtp_buffer_new_allocate(
        payload_len: c_uint,
        pad_len: u8,
        csrc_count: u8,
    ) -> *mut gst::GstBuffer;
    pub fn gst_rtp_buffer_new_allocate_len(
        packet_len: c_uint,
        pad_len: u8,
        csrc_count: u8,
    ) -> *mut gst::GstBuffer;
    pub fn gst_rtp_buffer_new_copy_data(data: gconstpointer, len: size_t) -> *mut gst::GstBuffer;
    pub fn gst_rtp_buffer_new_take_data(data: gpointer, len: size_t) -> *mut gst::GstBuffer;

    //=========================================================================
    // GstRTPHeaderExtensionClass
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_class_set_uri(
        klass: *mut GstRTPHeaderExtensionClass,
        uri: *const c_char,
    );

    //=========================================================================
    // GstRTPPayloadInfo
    //=========================================================================
    pub fn gst_rtp_payload_info_for_name(
        media: *const c_char,
        encoding_name: *const c_char,
    ) -> *const GstRTPPayloadInfo;
    pub fn gst_rtp_payload_info_for_pt(payload_type: u8) -> *const GstRTPPayloadInfo;

    //=========================================================================
    // GstRTPSourceMeta
    //=========================================================================
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_source_meta_append_csrc(
        meta: *mut GstRTPSourceMeta,
        csrc: *const u32,
        csrc_count: c_uint,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_source_meta_get_source_count(meta: *const GstRTPSourceMeta) -> c_uint;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_source_meta_set_ssrc(meta: *mut GstRTPSourceMeta, ssrc: *mut u32) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_source_meta_get_info() -> *const gst::GstMetaInfo;

    //=========================================================================
    // GstRTPBaseAudioPayload
    //=========================================================================
    pub fn gst_rtp_base_audio_payload_get_type() -> GType;
    pub fn gst_rtp_base_audio_payload_flush(
        baseaudiopayload: *mut GstRTPBaseAudioPayload,
        payload_len: c_uint,
        timestamp: gst::GstClockTime,
    ) -> gst::GstFlowReturn;
    pub fn gst_rtp_base_audio_payload_get_adapter(
        rtpbaseaudiopayload: *mut GstRTPBaseAudioPayload,
    ) -> *mut gst_base::GstAdapter;
    pub fn gst_rtp_base_audio_payload_push(
        baseaudiopayload: *mut GstRTPBaseAudioPayload,
        data: *const u8,
        payload_len: c_uint,
        timestamp: gst::GstClockTime,
    ) -> gst::GstFlowReturn;
    pub fn gst_rtp_base_audio_payload_set_frame_based(
        rtpbaseaudiopayload: *mut GstRTPBaseAudioPayload,
    );
    pub fn gst_rtp_base_audio_payload_set_frame_options(
        rtpbaseaudiopayload: *mut GstRTPBaseAudioPayload,
        frame_duration: c_int,
        frame_size: c_int,
    );
    pub fn gst_rtp_base_audio_payload_set_sample_based(
        rtpbaseaudiopayload: *mut GstRTPBaseAudioPayload,
    );
    pub fn gst_rtp_base_audio_payload_set_sample_options(
        rtpbaseaudiopayload: *mut GstRTPBaseAudioPayload,
        sample_size: c_int,
    );
    pub fn gst_rtp_base_audio_payload_set_samplebits_options(
        rtpbaseaudiopayload: *mut GstRTPBaseAudioPayload,
        sample_size: c_int,
    );

    //=========================================================================
    // GstRTPBaseDepayload
    //=========================================================================
    pub fn gst_rtp_base_depayload_get_type() -> GType;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_rtp_base_depayload_delayed(depayload: *mut GstRTPBaseDepayload);
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_rtp_base_depayload_dropped(depayload: *mut GstRTPBaseDepayload);
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_rtp_base_depayload_flush(
        depayload: *mut GstRTPBaseDepayload,
        keep_current: gboolean,
    );
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_rtp_base_depayload_is_aggregate_hdrext_enabled(
        depayload: *mut GstRTPBaseDepayload,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_base_depayload_is_source_info_enabled(
        depayload: *mut GstRTPBaseDepayload,
    ) -> gboolean;
    pub fn gst_rtp_base_depayload_push(
        filter: *mut GstRTPBaseDepayload,
        out_buf: *mut gst::GstBuffer,
    ) -> gst::GstFlowReturn;
    pub fn gst_rtp_base_depayload_push_list(
        filter: *mut GstRTPBaseDepayload,
        out_list: *mut gst::GstBufferList,
    ) -> gst::GstFlowReturn;
    #[cfg(feature = "v1_24")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_24")))]
    pub fn gst_rtp_base_depayload_set_aggregate_hdrext_enabled(
        depayload: *mut GstRTPBaseDepayload,
        enable: gboolean,
    );
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_base_depayload_set_source_info_enabled(
        depayload: *mut GstRTPBaseDepayload,
        enable: gboolean,
    );

    //=========================================================================
    // GstRTPBasePayload
    //=========================================================================
    pub fn gst_rtp_base_payload_get_type() -> GType;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_base_payload_allocate_output_buffer(
        payload: *mut GstRTPBasePayload,
        payload_len: c_uint,
        pad_len: u8,
        csrc_count: u8,
    ) -> *mut gst::GstBuffer;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_base_payload_get_source_count(
        payload: *mut GstRTPBasePayload,
        buffer: *mut gst::GstBuffer,
    ) -> c_uint;
    pub fn gst_rtp_base_payload_is_filled(
        payload: *mut GstRTPBasePayload,
        size: c_uint,
        duration: gst::GstClockTime,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_base_payload_is_source_info_enabled(payload: *mut GstRTPBasePayload)
        -> gboolean;
    pub fn gst_rtp_base_payload_push(
        payload: *mut GstRTPBasePayload,
        buffer: *mut gst::GstBuffer,
    ) -> gst::GstFlowReturn;
    pub fn gst_rtp_base_payload_push_list(
        payload: *mut GstRTPBasePayload,
        list: *mut gst::GstBufferList,
    ) -> gst::GstFlowReturn;
    pub fn gst_rtp_base_payload_set_options(
        payload: *mut GstRTPBasePayload,
        media: *const c_char,
        dynamic: gboolean,
        encoding_name: *const c_char,
        clock_rate: u32,
    );
    pub fn gst_rtp_base_payload_set_outcaps(
        payload: *mut GstRTPBasePayload,
        fieldname: *const c_char,
        ...
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_base_payload_set_outcaps_structure(
        payload: *mut GstRTPBasePayload,
        s: *mut gst::GstStructure,
    ) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_base_payload_set_source_info_enabled(
        payload: *mut GstRTPBasePayload,
        enable: gboolean,
    );

    //=========================================================================
    // GstRTPHeaderExtension
    //=========================================================================
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_type() -> GType;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_create_from_uri(
        uri: *const c_char,
    ) -> *mut GstRTPHeaderExtension;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_direction(
        ext: *mut GstRTPHeaderExtension,
    ) -> GstRTPHeaderExtensionDirection;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_id(ext: *mut GstRTPHeaderExtension) -> c_uint;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_max_size(
        ext: *mut GstRTPHeaderExtension,
        input_meta: *const gst::GstBuffer,
    ) -> size_t;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_sdp_caps_field_name(
        ext: *mut GstRTPHeaderExtension,
    ) -> *mut c_char;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_supported_flags(
        ext: *mut GstRTPHeaderExtension,
    ) -> GstRTPHeaderExtensionFlags;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_get_uri(ext: *mut GstRTPHeaderExtension) -> *const c_char;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_read(
        ext: *mut GstRTPHeaderExtension,
        read_flags: GstRTPHeaderExtensionFlags,
        data: *const u8,
        size: size_t,
        buffer: *mut gst::GstBuffer,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_attributes_from_caps(
        ext: *mut GstRTPHeaderExtension,
        caps: *const gst::GstCaps,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_caps_from_attributes(
        ext: *mut GstRTPHeaderExtension,
        caps: *mut gst::GstCaps,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_caps_from_attributes_helper(
        ext: *mut GstRTPHeaderExtension,
        caps: *mut gst::GstCaps,
        attributes: *const c_char,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_direction(
        ext: *mut GstRTPHeaderExtension,
        direction: GstRTPHeaderExtensionDirection,
    );
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_id(ext: *mut GstRTPHeaderExtension, ext_id: c_uint);
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_non_rtp_sink_caps(
        ext: *mut GstRTPHeaderExtension,
        caps: *const gst::GstCaps,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_set_wants_update_non_rtp_src_caps(
        ext: *mut GstRTPHeaderExtension,
        state: gboolean,
    );
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_update_non_rtp_src_caps(
        ext: *mut GstRTPHeaderExtension,
        caps: *mut gst::GstCaps,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_wants_update_non_rtp_src_caps(
        ext: *mut GstRTPHeaderExtension,
    ) -> gboolean;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_header_extension_write(
        ext: *mut GstRTPHeaderExtension,
        input_meta: *const gst::GstBuffer,
        write_flags: GstRTPHeaderExtensionFlags,
        output: *mut gst::GstBuffer,
        data: *mut u8,
        size: size_t,
    ) -> ssize_t;

    //=========================================================================
    // Other functions
    //=========================================================================
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_buffer_add_rtp_source_meta(
        buffer: *mut gst::GstBuffer,
        ssrc: *const u32,
        csrc: *const u32,
        csrc_count: c_uint,
    ) -> *mut GstRTPSourceMeta;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_buffer_get_rtp_source_meta(buffer: *mut gst::GstBuffer) -> *mut GstRTPSourceMeta;
    pub fn gst_rtcp_ntp_to_unix(ntptime: u64) -> u64;
    pub fn gst_rtcp_sdes_name_to_type(name: *const c_char) -> GstRTCPSDESType;
    pub fn gst_rtcp_sdes_type_to_name(type_: GstRTCPSDESType) -> *const c_char;
    pub fn gst_rtcp_unix_to_ntp(unixtime: u64) -> u64;
    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    pub fn gst_rtp_get_header_extension_list() -> *mut glib::GList;
    pub fn gst_rtp_hdrext_get_ntp_56(data: gpointer, size: c_uint, ntptime: *mut u64) -> gboolean;
    pub fn gst_rtp_hdrext_get_ntp_64(data: gpointer, size: c_uint, ntptime: *mut u64) -> gboolean;
    pub fn gst_rtp_hdrext_set_ntp_56(data: gpointer, size: c_uint, ntptime: u64) -> gboolean;
    pub fn gst_rtp_hdrext_set_ntp_64(data: gpointer, size: c_uint, ntptime: u64) -> gboolean;
    #[cfg(feature = "v1_16")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_16")))]
    pub fn gst_rtp_source_meta_api_get_type() -> GType;

}
