// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains set of transcription results from one or more audio segments, along with additional information about the parameters included in your request. For example, channel definitions, partial result stabilization, sentiment, and issue detection.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UtteranceEvent {
    /// <p>The unique identifier that is associated with the specified <code>UtteranceEvent</code>.</p>
    pub utterance_id: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial (<code>TRUE</code>).</p>
    pub is_partial: bool,
    /// <p>Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.</p>
    pub participant_role: ::std::option::Option<crate::types::ParticipantRole>,
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub begin_offset_millis: ::std::option::Option<i64>,
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub end_offset_millis: ::std::option::Option<i64>,
    /// <p>Contains transcribed text.</p>
    pub transcript: ::std::option::Option<::std::string::String>,
    /// <p>Contains words, phrases, or punctuation marks that are associated with the specified <code>UtteranceEvent</code>.</p>
    pub items: ::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsItem>>,
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub entities: ::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsEntity>>,
    /// <p>Provides the sentiment that was detected in the specified segment.</p>
    pub sentiment: ::std::option::Option<crate::types::Sentiment>,
    /// <p>Provides the issue that was detected in the specified segment.</p>
    pub issues_detected: ::std::option::Option<::std::vec::Vec<crate::types::IssueDetected>>,
}
impl UtteranceEvent {
    /// <p>The unique identifier that is associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn utterance_id(&self) -> ::std::option::Option<&str> {
        self.utterance_id.as_deref()
    }
    /// <p>Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial (<code>TRUE</code>).</p>
    pub fn is_partial(&self) -> bool {
        self.is_partial
    }
    /// <p>Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.</p>
    pub fn participant_role(&self) -> ::std::option::Option<&crate::types::ParticipantRole> {
        self.participant_role.as_ref()
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn begin_offset_millis(&self) -> ::std::option::Option<i64> {
        self.begin_offset_millis
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn end_offset_millis(&self) -> ::std::option::Option<i64> {
        self.end_offset_millis
    }
    /// <p>Contains transcribed text.</p>
    pub fn transcript(&self) -> ::std::option::Option<&str> {
        self.transcript.as_deref()
    }
    /// <p>Contains words, phrases, or punctuation marks that are associated with the specified <code>UtteranceEvent</code>.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.items.is_none()`.
    pub fn items(&self) -> &[crate::types::CallAnalyticsItem] {
        self.items.as_deref().unwrap_or_default()
    }
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.entities.is_none()`.
    pub fn entities(&self) -> &[crate::types::CallAnalyticsEntity] {
        self.entities.as_deref().unwrap_or_default()
    }
    /// <p>Provides the sentiment that was detected in the specified segment.</p>
    pub fn sentiment(&self) -> ::std::option::Option<&crate::types::Sentiment> {
        self.sentiment.as_ref()
    }
    /// <p>Provides the issue that was detected in the specified segment.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.issues_detected.is_none()`.
    pub fn issues_detected(&self) -> &[crate::types::IssueDetected] {
        self.issues_detected.as_deref().unwrap_or_default()
    }
}
impl UtteranceEvent {
    /// Creates a new builder-style object to manufacture [`UtteranceEvent`](crate::types::UtteranceEvent).
    pub fn builder() -> crate::types::builders::UtteranceEventBuilder {
        crate::types::builders::UtteranceEventBuilder::default()
    }
}

/// A builder for [`UtteranceEvent`](crate::types::UtteranceEvent).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct UtteranceEventBuilder {
    pub(crate) utterance_id: ::std::option::Option<::std::string::String>,
    pub(crate) is_partial: ::std::option::Option<bool>,
    pub(crate) participant_role: ::std::option::Option<crate::types::ParticipantRole>,
    pub(crate) begin_offset_millis: ::std::option::Option<i64>,
    pub(crate) end_offset_millis: ::std::option::Option<i64>,
    pub(crate) transcript: ::std::option::Option<::std::string::String>,
    pub(crate) items: ::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsItem>>,
    pub(crate) entities: ::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsEntity>>,
    pub(crate) sentiment: ::std::option::Option<crate::types::Sentiment>,
    pub(crate) issues_detected: ::std::option::Option<::std::vec::Vec<crate::types::IssueDetected>>,
}
impl UtteranceEventBuilder {
    /// <p>The unique identifier that is associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn utterance_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.utterance_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier that is associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn set_utterance_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.utterance_id = input;
        self
    }
    /// <p>The unique identifier that is associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn get_utterance_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.utterance_id
    }
    /// <p>Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial (<code>TRUE</code>).</p>
    pub fn is_partial(mut self, input: bool) -> Self {
        self.is_partial = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial (<code>TRUE</code>).</p>
    pub fn set_is_partial(mut self, input: ::std::option::Option<bool>) -> Self {
        self.is_partial = input;
        self
    }
    /// <p>Indicates whether the segment in the <code>UtteranceEvent</code> is complete (<code>FALSE</code>) or partial (<code>TRUE</code>).</p>
    pub fn get_is_partial(&self) -> &::std::option::Option<bool> {
        &self.is_partial
    }
    /// <p>Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.</p>
    pub fn participant_role(mut self, input: crate::types::ParticipantRole) -> Self {
        self.participant_role = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.</p>
    pub fn set_participant_role(mut self, input: ::std::option::Option<crate::types::ParticipantRole>) -> Self {
        self.participant_role = input;
        self
    }
    /// <p>Provides the role of the speaker for each audio channel, either <code>CUSTOMER</code> or <code>AGENT</code>.</p>
    pub fn get_participant_role(&self) -> &::std::option::Option<crate::types::ParticipantRole> {
        &self.participant_role
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn begin_offset_millis(mut self, input: i64) -> Self {
        self.begin_offset_millis = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn set_begin_offset_millis(mut self, input: ::std::option::Option<i64>) -> Self {
        self.begin_offset_millis = input;
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn get_begin_offset_millis(&self) -> &::std::option::Option<i64> {
        &self.begin_offset_millis
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn end_offset_millis(mut self, input: i64) -> Self {
        self.end_offset_millis = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn set_end_offset_millis(mut self, input: ::std::option::Option<i64>) -> Self {
        self.end_offset_millis = input;
        self
    }
    /// <p>The time, in milliseconds, from the beginning of the audio stream to the start of the <code>UtteranceEvent</code>.</p>
    pub fn get_end_offset_millis(&self) -> &::std::option::Option<i64> {
        &self.end_offset_millis
    }
    /// <p>Contains transcribed text.</p>
    pub fn transcript(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.transcript = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Contains transcribed text.</p>
    pub fn set_transcript(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.transcript = input;
        self
    }
    /// <p>Contains transcribed text.</p>
    pub fn get_transcript(&self) -> &::std::option::Option<::std::string::String> {
        &self.transcript
    }
    /// Appends an item to `items`.
    ///
    /// To override the contents of this collection use [`set_items`](Self::set_items).
    ///
    /// <p>Contains words, phrases, or punctuation marks that are associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn items(mut self, input: crate::types::CallAnalyticsItem) -> Self {
        let mut v = self.items.unwrap_or_default();
        v.push(input);
        self.items = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains words, phrases, or punctuation marks that are associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn set_items(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsItem>>) -> Self {
        self.items = input;
        self
    }
    /// <p>Contains words, phrases, or punctuation marks that are associated with the specified <code>UtteranceEvent</code>.</p>
    pub fn get_items(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsItem>> {
        &self.items
    }
    /// Appends an item to `entities`.
    ///
    /// To override the contents of this collection use [`set_entities`](Self::set_entities).
    ///
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub fn entities(mut self, input: crate::types::CallAnalyticsEntity) -> Self {
        let mut v = self.entities.unwrap_or_default();
        v.push(input);
        self.entities = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub fn set_entities(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsEntity>>) -> Self {
        self.entities = input;
        self
    }
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub fn get_entities(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::CallAnalyticsEntity>> {
        &self.entities
    }
    /// <p>Provides the sentiment that was detected in the specified segment.</p>
    pub fn sentiment(mut self, input: crate::types::Sentiment) -> Self {
        self.sentiment = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the sentiment that was detected in the specified segment.</p>
    pub fn set_sentiment(mut self, input: ::std::option::Option<crate::types::Sentiment>) -> Self {
        self.sentiment = input;
        self
    }
    /// <p>Provides the sentiment that was detected in the specified segment.</p>
    pub fn get_sentiment(&self) -> &::std::option::Option<crate::types::Sentiment> {
        &self.sentiment
    }
    /// Appends an item to `issues_detected`.
    ///
    /// To override the contents of this collection use [`set_issues_detected`](Self::set_issues_detected).
    ///
    /// <p>Provides the issue that was detected in the specified segment.</p>
    pub fn issues_detected(mut self, input: crate::types::IssueDetected) -> Self {
        let mut v = self.issues_detected.unwrap_or_default();
        v.push(input);
        self.issues_detected = ::std::option::Option::Some(v);
        self
    }
    /// <p>Provides the issue that was detected in the specified segment.</p>
    pub fn set_issues_detected(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::IssueDetected>>) -> Self {
        self.issues_detected = input;
        self
    }
    /// <p>Provides the issue that was detected in the specified segment.</p>
    pub fn get_issues_detected(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::IssueDetected>> {
        &self.issues_detected
    }
    /// Consumes the builder and constructs a [`UtteranceEvent`](crate::types::UtteranceEvent).
    pub fn build(self) -> crate::types::UtteranceEvent {
        crate::types::UtteranceEvent {
            utterance_id: self.utterance_id,
            is_partial: self.is_partial.unwrap_or_default(),
            participant_role: self.participant_role,
            begin_offset_millis: self.begin_offset_millis,
            end_offset_millis: self.end_offset_millis,
            transcript: self.transcript,
            items: self.items,
            entities: self.entities,
            sentiment: self.sentiment,
            issues_detected: self.issues_detected,
        }
    }
}
