// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A list of possible alternative transcriptions for the input audio. Each alternative may contain one or more of <code>Items</code>, <code>Entities</code>, or <code>Transcript</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Alternative {
    /// <p>Contains transcribed text.</p>
    pub transcript: ::std::option::Option<::std::string::String>,
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub items: ::std::option::Option<::std::vec::Vec<crate::types::Item>>,
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub entities: ::std::option::Option<::std::vec::Vec<crate::types::Entity>>,
}
impl Alternative {
    /// <p>Contains transcribed text.</p>
    pub fn transcript(&self) -> ::std::option::Option<&str> {
        self.transcript.as_deref()
    }
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.items.is_none()`.
    pub fn items(&self) -> &[crate::types::Item] {
        self.items.as_deref().unwrap_or_default()
    }
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.entities.is_none()`.
    pub fn entities(&self) -> &[crate::types::Entity] {
        self.entities.as_deref().unwrap_or_default()
    }
}
impl Alternative {
    /// Creates a new builder-style object to manufacture [`Alternative`](crate::types::Alternative).
    pub fn builder() -> crate::types::builders::AlternativeBuilder {
        crate::types::builders::AlternativeBuilder::default()
    }
}

/// A builder for [`Alternative`](crate::types::Alternative).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct AlternativeBuilder {
    pub(crate) transcript: ::std::option::Option<::std::string::String>,
    pub(crate) items: ::std::option::Option<::std::vec::Vec<crate::types::Item>>,
    pub(crate) entities: ::std::option::Option<::std::vec::Vec<crate::types::Entity>>,
}
impl AlternativeBuilder {
    /// <p>Contains transcribed text.</p>
    pub fn transcript(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.transcript = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Contains transcribed text.</p>
    pub fn set_transcript(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.transcript = input;
        self
    }
    /// <p>Contains transcribed text.</p>
    pub fn get_transcript(&self) -> &::std::option::Option<::std::string::String> {
        &self.transcript
    }
    /// Appends an item to `items`.
    ///
    /// To override the contents of this collection use [`set_items`](Self::set_items).
    ///
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub fn items(mut self, input: crate::types::Item) -> Self {
        let mut v = self.items.unwrap_or_default();
        v.push(input);
        self.items = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub fn set_items(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Item>>) -> Self {
        self.items = input;
        self
    }
    /// <p>Contains words, phrases, or punctuation marks in your transcription output.</p>
    pub fn get_items(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Item>> {
        &self.items
    }
    /// Appends an item to `entities`.
    ///
    /// To override the contents of this collection use [`set_entities`](Self::set_entities).
    ///
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub fn entities(mut self, input: crate::types::Entity) -> Self {
        let mut v = self.entities.unwrap_or_default();
        v.push(input);
        self.entities = ::std::option::Option::Some(v);
        self
    }
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub fn set_entities(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Entity>>) -> Self {
        self.entities = input;
        self
    }
    /// <p>Contains entities identified as personally identifiable information (PII) in your transcription output.</p>
    pub fn get_entities(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Entity>> {
        &self.entities
    }
    /// Consumes the builder and constructs a [`Alternative`](crate::types::Alternative).
    pub fn build(self) -> crate::types::Alternative {
        crate::types::Alternative {
            transcript: self.transcript,
            items: self.items,
            entities: self.entities,
        }
    }
}
