// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartMedicalStreamTranscription`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language_code(LanguageCode)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_language_code):<br>required: **true**<br><p>Specify the language code that represents the language spoken in your audio.</p><important>  <p>Amazon Transcribe Medical only supports US English (<code>en-US</code>).</p> </important><br>
    ///   - [`media_sample_rate_hertz(i32)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::media_sample_rate_hertz) / [`set_media_sample_rate_hertz(Option<i32>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_media_sample_rate_hertz):<br>required: **true**<br><p>The sample rate of the input audio (in hertz). Amazon Transcribe Medical supports a range from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p><br>
    ///   - [`media_encoding(MediaEncoding)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::media_encoding) / [`set_media_encoding(Option<MediaEncoding>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_media_encoding):<br>required: **true**<br><p>Specify the encoding used for the input audio. Supported formats are:</p> <ul>  <li>   <p>FLAC</p></li>  <li>   <p>OPUS-encoded audio in an Ogg container</p></li>  <li>   <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p><br>
    ///   - [`vocabulary_name(impl Into<String>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::vocabulary_name) / [`set_vocabulary_name(Option<String>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_vocabulary_name):<br>required: **false**<br><p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p><br>
    ///   - [`specialty(Specialty)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::specialty) / [`set_specialty(Option<Specialty>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_specialty):<br>required: **true**<br><p>Specify the medical specialty contained in your audio.</p><br>
    ///   - [`r#type(Type)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::type) / [`set_type(Option<Type>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_type):<br>required: **true**<br><p>Specify the type of input audio. For example, choose <code>DICTATION</code> for a provider dictating patient notes and <code>CONVERSATION</code> for a dialogue between a patient and a medical professional.</p><br>
    ///   - [`show_speaker_label(bool)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::show_speaker_label) / [`set_show_speaker_label(Option<bool>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_show_speaker_label):<br>required: **false**<br><p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p><br>
    ///   - [`session_id(impl Into<String>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::session_id) / [`set_session_id(Option<String>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_session_id):<br>required: **false**<br><p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe Medical generates an ID and returns it in the response.</p> <p>You can use a session ID to retry a streaming session.</p><br>
    ///   - [`audio_stream(EventStreamSender<AudioStream, AudioStreamError>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::audio_stream) / [`set_audio_stream(EventStreamSender<AudioStream, AudioStreamError>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_audio_stream):<br>required: **true**<br><p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p><br>
    ///   - [`enable_channel_identification(bool)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::enable_channel_identification) / [`set_enable_channel_identification(Option<bool>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_enable_channel_identification):<br>required: **false**<br><p>Enables channel identification in multi-channel audio.</p> <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p> <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p><br>
    ///   - [`number_of_channels(i32)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::number_of_channels) / [`set_number_of_channels(Option<i32>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_number_of_channels):<br>required: **false**<br><p>Specify the number of channels in your audio stream. Up to two channels are supported.</p><br>
    ///   - [`content_identification_type(MedicalContentIdentificationType)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::content_identification_type) / [`set_content_identification_type(Option<MedicalContentIdentificationType>)`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::set_content_identification_type):<br>required: **false**<br><p>Labels all personal health information (PHI) identified in your transcript.</p> <p>Content identification is performed at the segment level; PHI is flagged upon complete transcription of an audio segment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI) in a transcription</a>.</p><br>
    /// - On success, responds with [`StartMedicalStreamTranscriptionOutput`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::request_id): <p>Provides the identifier for your streaming request.</p>
    ///   - [`language_code(Option<LanguageCode>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::language_code): <p>Provides the language code that you specified in your request. This must be <code>en-US</code>.</p>
    ///   - [`media_sample_rate_hertz(Option<i32>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::media_sample_rate_hertz): <p>Provides the sample rate that you specified in your request.</p>
    ///   - [`media_encoding(Option<MediaEncoding>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::media_encoding): <p>Provides the media encoding you specified in your request.</p>
    ///   - [`vocabulary_name(Option<String>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::vocabulary_name): <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    ///   - [`specialty(Option<Specialty>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::specialty): <p>Provides the medical specialty that you specified in your request.</p>
    ///   - [`r#type(Option<Type>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::type): <p>Provides the type of audio you specified in your request.</p>
    ///   - [`show_speaker_label(bool)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::show_speaker_label): <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    ///   - [`session_id(Option<String>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::session_id): <p>Provides the identifier for your transcription session.</p>
    ///   - [`transcript_result_stream(EventReceiver<MedicalTranscriptResultStream, MedicalTranscriptResultStreamError>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::transcript_result_stream): <p>Provides detailed information about your streaming session.</p>
    ///   - [`enable_channel_identification(bool)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::enable_channel_identification): <p>Shows whether channel identification was enabled for your transcription.</p>
    ///   - [`number_of_channels(Option<i32>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::number_of_channels): <p>Provides the number of channels that you specified in your request.</p>
    ///   - [`content_identification_type(Option<MedicalContentIdentificationType>)`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput::content_identification_type): <p>Shows whether content identification was enabled for your transcription.</p>
    /// - On failure, responds with [`SdkError<StartMedicalStreamTranscriptionError>`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionError)
    pub fn start_medical_stream_transcription(
        &self,
    ) -> crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder {
        crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionFluentBuilder::new(self.handle.clone())
    }
}
