// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Container for the expiration for the lifecycle of the object.</p>
/// <p>For more information see, <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html">Managing your storage lifecycle</a> in the <i>Amazon S3 User Guide</i>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct LifecycleExpiration {
    /// <p>Indicates at what date the object is to be moved or deleted. The date value must conform to the ISO 8601 format. The time is always midnight UTC.</p>
    pub date: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub days: ::std::option::Option<i32>,
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub expired_object_delete_marker: ::std::option::Option<bool>,
}
impl LifecycleExpiration {
    /// <p>Indicates at what date the object is to be moved or deleted. The date value must conform to the ISO 8601 format. The time is always midnight UTC.</p>
    pub fn date(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub fn days(&self) -> ::std::option::Option<i32> {
        self.days
    }
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub fn expired_object_delete_marker(&self) -> ::std::option::Option<bool> {
        self.expired_object_delete_marker
    }
}
impl LifecycleExpiration {
    /// Creates a new builder-style object to manufacture [`LifecycleExpiration`](crate::types::LifecycleExpiration).
    pub fn builder() -> crate::types::builders::LifecycleExpirationBuilder {
        crate::types::builders::LifecycleExpirationBuilder::default()
    }
}

/// A builder for [`LifecycleExpiration`](crate::types::LifecycleExpiration).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct LifecycleExpirationBuilder {
    pub(crate) date: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) days: ::std::option::Option<i32>,
    pub(crate) expired_object_delete_marker: ::std::option::Option<bool>,
}
impl LifecycleExpirationBuilder {
    /// <p>Indicates at what date the object is to be moved or deleted. The date value must conform to the ISO 8601 format. The time is always midnight UTC.</p>
    pub fn date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.date = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates at what date the object is to be moved or deleted. The date value must conform to the ISO 8601 format. The time is always midnight UTC.</p>
    pub fn set_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.date = input;
        self
    }
    /// <p>Indicates at what date the object is to be moved or deleted. The date value must conform to the ISO 8601 format. The time is always midnight UTC.</p>
    pub fn get_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.date
    }
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub fn days(mut self, input: i32) -> Self {
        self.days = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub fn set_days(mut self, input: ::std::option::Option<i32>) -> Self {
        self.days = input;
        self
    }
    /// <p>Indicates the lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.</p>
    pub fn get_days(&self) -> &::std::option::Option<i32> {
        &self.days
    }
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub fn expired_object_delete_marker(mut self, input: bool) -> Self {
        self.expired_object_delete_marker = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub fn set_expired_object_delete_marker(mut self, input: ::std::option::Option<bool>) -> Self {
        self.expired_object_delete_marker = input;
        self
    }
    /// <p>Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to true, the delete marker will be expired; if set to false the policy takes no action. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.</p>
    pub fn get_expired_object_delete_marker(&self) -> &::std::option::Option<bool> {
        &self.expired_object_delete_marker
    }
    /// Consumes the builder and constructs a [`LifecycleExpiration`](crate::types::LifecycleExpiration).
    pub fn build(self) -> crate::types::LifecycleExpiration {
        crate::types::LifecycleExpiration {
            date: self.date,
            days: self.days,
            expired_object_delete_marker: self.expired_object_delete_marker,
        }
    }
}
