// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `Event`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let event = unimplemented!();
/// match event {
///     Event::S3IntelligentTiering => { /* ... */ },
///     Event::S3LifecycleExpiration => { /* ... */ },
///     Event::S3LifecycleExpirationDelete => { /* ... */ },
///     Event::S3LifecycleExpirationDeleteMarkerCreated => { /* ... */ },
///     Event::S3LifecycleTransition => { /* ... */ },
///     Event::S3ObjectAclPut => { /* ... */ },
///     Event::S3ObjectCreated => { /* ... */ },
///     Event::S3ObjectCreatedCompleteMultipartUpload => { /* ... */ },
///     Event::S3ObjectCreatedCopy => { /* ... */ },
///     Event::S3ObjectCreatedPost => { /* ... */ },
///     Event::S3ObjectCreatedPut => { /* ... */ },
///     Event::S3ObjectRemoved => { /* ... */ },
///     Event::S3ObjectRemovedDelete => { /* ... */ },
///     Event::S3ObjectRemovedDeleteMarkerCreated => { /* ... */ },
///     Event::S3ObjectRestore => { /* ... */ },
///     Event::S3ObjectRestoreCompleted => { /* ... */ },
///     Event::S3ObjectRestoreDelete => { /* ... */ },
///     Event::S3ObjectRestorePost => { /* ... */ },
///     Event::S3ObjectTagging => { /* ... */ },
///     Event::S3ObjectTaggingDelete => { /* ... */ },
///     Event::S3ObjectTaggingPut => { /* ... */ },
///     Event::S3ReducedRedundancyLostObject => { /* ... */ },
///     Event::S3Replication => { /* ... */ },
///     Event::S3ReplicationOperationFailedReplication => { /* ... */ },
///     Event::S3ReplicationOperationMissedThreshold => { /* ... */ },
///     Event::S3ReplicationOperationNotTracked => { /* ... */ },
///     Event::S3ReplicationOperationReplicatedAfterThreshold => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `event` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `Event::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `Event::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `Event::NewFeature` is defined.
/// Specifically, when `event` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `Event::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
/// <p>The bucket event for which to send notifications.</p>
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum Event {
    #[allow(missing_docs)] // documentation missing in model
    S3IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    S3LifecycleExpiration,
    #[allow(missing_docs)] // documentation missing in model
    S3LifecycleExpirationDelete,
    #[allow(missing_docs)] // documentation missing in model
    S3LifecycleExpirationDeleteMarkerCreated,
    #[allow(missing_docs)] // documentation missing in model
    S3LifecycleTransition,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectAclPut,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectCreated,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectCreatedCompleteMultipartUpload,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectCreatedCopy,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectCreatedPost,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectCreatedPut,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRemoved,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRemovedDelete,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRemovedDeleteMarkerCreated,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRestore,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRestoreCompleted,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRestoreDelete,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectRestorePost,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectTagging,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectTaggingDelete,
    #[allow(missing_docs)] // documentation missing in model
    S3ObjectTaggingPut,
    #[allow(missing_docs)] // documentation missing in model
    S3ReducedRedundancyLostObject,
    #[allow(missing_docs)] // documentation missing in model
    S3Replication,
    #[allow(missing_docs)] // documentation missing in model
    S3ReplicationOperationFailedReplication,
    #[allow(missing_docs)] // documentation missing in model
    S3ReplicationOperationMissedThreshold,
    #[allow(missing_docs)] // documentation missing in model
    S3ReplicationOperationNotTracked,
    #[allow(missing_docs)] // documentation missing in model
    S3ReplicationOperationReplicatedAfterThreshold,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for Event {
    fn from(s: &str) -> Self {
        match s {
            "s3:IntelligentTiering" => Event::S3IntelligentTiering,
            "s3:LifecycleExpiration:*" => Event::S3LifecycleExpiration,
            "s3:LifecycleExpiration:Delete" => Event::S3LifecycleExpirationDelete,
            "s3:LifecycleExpiration:DeleteMarkerCreated" => Event::S3LifecycleExpirationDeleteMarkerCreated,
            "s3:LifecycleTransition" => Event::S3LifecycleTransition,
            "s3:ObjectAcl:Put" => Event::S3ObjectAclPut,
            "s3:ObjectCreated:*" => Event::S3ObjectCreated,
            "s3:ObjectCreated:CompleteMultipartUpload" => Event::S3ObjectCreatedCompleteMultipartUpload,
            "s3:ObjectCreated:Copy" => Event::S3ObjectCreatedCopy,
            "s3:ObjectCreated:Post" => Event::S3ObjectCreatedPost,
            "s3:ObjectCreated:Put" => Event::S3ObjectCreatedPut,
            "s3:ObjectRemoved:*" => Event::S3ObjectRemoved,
            "s3:ObjectRemoved:Delete" => Event::S3ObjectRemovedDelete,
            "s3:ObjectRemoved:DeleteMarkerCreated" => Event::S3ObjectRemovedDeleteMarkerCreated,
            "s3:ObjectRestore:*" => Event::S3ObjectRestore,
            "s3:ObjectRestore:Completed" => Event::S3ObjectRestoreCompleted,
            "s3:ObjectRestore:Delete" => Event::S3ObjectRestoreDelete,
            "s3:ObjectRestore:Post" => Event::S3ObjectRestorePost,
            "s3:ObjectTagging:*" => Event::S3ObjectTagging,
            "s3:ObjectTagging:Delete" => Event::S3ObjectTaggingDelete,
            "s3:ObjectTagging:Put" => Event::S3ObjectTaggingPut,
            "s3:ReducedRedundancyLostObject" => Event::S3ReducedRedundancyLostObject,
            "s3:Replication:*" => Event::S3Replication,
            "s3:Replication:OperationFailedReplication" => Event::S3ReplicationOperationFailedReplication,
            "s3:Replication:OperationMissedThreshold" => Event::S3ReplicationOperationMissedThreshold,
            "s3:Replication:OperationNotTracked" => Event::S3ReplicationOperationNotTracked,
            "s3:Replication:OperationReplicatedAfterThreshold" => Event::S3ReplicationOperationReplicatedAfterThreshold,
            other => Event::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for Event {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(Event::from(s))
    }
}
impl Event {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Event::S3IntelligentTiering => "s3:IntelligentTiering",
            Event::S3LifecycleExpiration => "s3:LifecycleExpiration:*",
            Event::S3LifecycleExpirationDelete => "s3:LifecycleExpiration:Delete",
            Event::S3LifecycleExpirationDeleteMarkerCreated => "s3:LifecycleExpiration:DeleteMarkerCreated",
            Event::S3LifecycleTransition => "s3:LifecycleTransition",
            Event::S3ObjectAclPut => "s3:ObjectAcl:Put",
            Event::S3ObjectCreated => "s3:ObjectCreated:*",
            Event::S3ObjectCreatedCompleteMultipartUpload => "s3:ObjectCreated:CompleteMultipartUpload",
            Event::S3ObjectCreatedCopy => "s3:ObjectCreated:Copy",
            Event::S3ObjectCreatedPost => "s3:ObjectCreated:Post",
            Event::S3ObjectCreatedPut => "s3:ObjectCreated:Put",
            Event::S3ObjectRemoved => "s3:ObjectRemoved:*",
            Event::S3ObjectRemovedDelete => "s3:ObjectRemoved:Delete",
            Event::S3ObjectRemovedDeleteMarkerCreated => "s3:ObjectRemoved:DeleteMarkerCreated",
            Event::S3ObjectRestore => "s3:ObjectRestore:*",
            Event::S3ObjectRestoreCompleted => "s3:ObjectRestore:Completed",
            Event::S3ObjectRestoreDelete => "s3:ObjectRestore:Delete",
            Event::S3ObjectRestorePost => "s3:ObjectRestore:Post",
            Event::S3ObjectTagging => "s3:ObjectTagging:*",
            Event::S3ObjectTaggingDelete => "s3:ObjectTagging:Delete",
            Event::S3ObjectTaggingPut => "s3:ObjectTagging:Put",
            Event::S3ReducedRedundancyLostObject => "s3:ReducedRedundancyLostObject",
            Event::S3Replication => "s3:Replication:*",
            Event::S3ReplicationOperationFailedReplication => "s3:Replication:OperationFailedReplication",
            Event::S3ReplicationOperationMissedThreshold => "s3:Replication:OperationMissedThreshold",
            Event::S3ReplicationOperationNotTracked => "s3:Replication:OperationNotTracked",
            Event::S3ReplicationOperationReplicatedAfterThreshold => "s3:Replication:OperationReplicatedAfterThreshold",
            Event::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "s3:IntelligentTiering",
            "s3:LifecycleExpiration:*",
            "s3:LifecycleExpiration:Delete",
            "s3:LifecycleExpiration:DeleteMarkerCreated",
            "s3:LifecycleTransition",
            "s3:ObjectAcl:Put",
            "s3:ObjectCreated:*",
            "s3:ObjectCreated:CompleteMultipartUpload",
            "s3:ObjectCreated:Copy",
            "s3:ObjectCreated:Post",
            "s3:ObjectCreated:Put",
            "s3:ObjectRemoved:*",
            "s3:ObjectRemoved:Delete",
            "s3:ObjectRemoved:DeleteMarkerCreated",
            "s3:ObjectRestore:*",
            "s3:ObjectRestore:Completed",
            "s3:ObjectRestore:Delete",
            "s3:ObjectRestore:Post",
            "s3:ObjectTagging:*",
            "s3:ObjectTagging:Delete",
            "s3:ObjectTagging:Put",
            "s3:ReducedRedundancyLostObject",
            "s3:Replication:*",
            "s3:Replication:OperationFailedReplication",
            "s3:Replication:OperationMissedThreshold",
            "s3:Replication:OperationNotTracked",
            "s3:Replication:OperationReplicatedAfterThreshold",
        ]
    }
}
impl ::std::convert::AsRef<str> for Event {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl Event {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for Event {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            Event::S3IntelligentTiering => write!(f, "s3:IntelligentTiering"),
            Event::S3LifecycleExpiration => write!(f, "s3:LifecycleExpiration:*"),
            Event::S3LifecycleExpirationDelete => write!(f, "s3:LifecycleExpiration:Delete"),
            Event::S3LifecycleExpirationDeleteMarkerCreated => write!(f, "s3:LifecycleExpiration:DeleteMarkerCreated"),
            Event::S3LifecycleTransition => write!(f, "s3:LifecycleTransition"),
            Event::S3ObjectAclPut => write!(f, "s3:ObjectAcl:Put"),
            Event::S3ObjectCreated => write!(f, "s3:ObjectCreated:*"),
            Event::S3ObjectCreatedCompleteMultipartUpload => write!(f, "s3:ObjectCreated:CompleteMultipartUpload"),
            Event::S3ObjectCreatedCopy => write!(f, "s3:ObjectCreated:Copy"),
            Event::S3ObjectCreatedPost => write!(f, "s3:ObjectCreated:Post"),
            Event::S3ObjectCreatedPut => write!(f, "s3:ObjectCreated:Put"),
            Event::S3ObjectRemoved => write!(f, "s3:ObjectRemoved:*"),
            Event::S3ObjectRemovedDelete => write!(f, "s3:ObjectRemoved:Delete"),
            Event::S3ObjectRemovedDeleteMarkerCreated => write!(f, "s3:ObjectRemoved:DeleteMarkerCreated"),
            Event::S3ObjectRestore => write!(f, "s3:ObjectRestore:*"),
            Event::S3ObjectRestoreCompleted => write!(f, "s3:ObjectRestore:Completed"),
            Event::S3ObjectRestoreDelete => write!(f, "s3:ObjectRestore:Delete"),
            Event::S3ObjectRestorePost => write!(f, "s3:ObjectRestore:Post"),
            Event::S3ObjectTagging => write!(f, "s3:ObjectTagging:*"),
            Event::S3ObjectTaggingDelete => write!(f, "s3:ObjectTagging:Delete"),
            Event::S3ObjectTaggingPut => write!(f, "s3:ObjectTagging:Put"),
            Event::S3ReducedRedundancyLostObject => write!(f, "s3:ReducedRedundancyLostObject"),
            Event::S3Replication => write!(f, "s3:Replication:*"),
            Event::S3ReplicationOperationFailedReplication => write!(f, "s3:Replication:OperationFailedReplication"),
            Event::S3ReplicationOperationMissedThreshold => write!(f, "s3:Replication:OperationMissedThreshold"),
            Event::S3ReplicationOperationNotTracked => write!(f, "s3:Replication:OperationNotTracked"),
            Event::S3ReplicationOperationReplicatedAfterThreshold => write!(f, "s3:Replication:OperationReplicatedAfterThreshold"),
            Event::Unknown(value) => write!(f, "{}", value),
        }
    }
}
