// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Information about the deleted object.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DeletedObject {
    /// <p>The name of the deleted object.</p>
    pub key: ::std::option::Option<::std::string::String>,
    /// <p>The version ID of the deleted object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub version_id: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub delete_marker: ::std::option::Option<bool>,
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub delete_marker_version_id: ::std::option::Option<::std::string::String>,
}
impl DeletedObject {
    /// <p>The name of the deleted object.</p>
    pub fn key(&self) -> ::std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The version ID of the deleted object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn version_id(&self) -> ::std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn delete_marker(&self) -> ::std::option::Option<bool> {
        self.delete_marker
    }
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn delete_marker_version_id(&self) -> ::std::option::Option<&str> {
        self.delete_marker_version_id.as_deref()
    }
}
impl DeletedObject {
    /// Creates a new builder-style object to manufacture [`DeletedObject`](crate::types::DeletedObject).
    pub fn builder() -> crate::types::builders::DeletedObjectBuilder {
        crate::types::builders::DeletedObjectBuilder::default()
    }
}

/// A builder for [`DeletedObject`](crate::types::DeletedObject).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct DeletedObjectBuilder {
    pub(crate) key: ::std::option::Option<::std::string::String>,
    pub(crate) version_id: ::std::option::Option<::std::string::String>,
    pub(crate) delete_marker: ::std::option::Option<bool>,
    pub(crate) delete_marker_version_id: ::std::option::Option<::std::string::String>,
}
impl DeletedObjectBuilder {
    /// <p>The name of the deleted object.</p>
    pub fn key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the deleted object.</p>
    pub fn set_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key = input;
        self
    }
    /// <p>The name of the deleted object.</p>
    pub fn get_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.key
    }
    /// <p>The version ID of the deleted object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn version_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.version_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version ID of the deleted object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_version_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.version_id = input;
        self
    }
    /// <p>The version ID of the deleted object.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_version_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.version_id
    }
    /// <p>Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn delete_marker(mut self, input: bool) -> Self {
        self.delete_marker = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_delete_marker(mut self, input: ::std::option::Option<bool>) -> Self {
        self.delete_marker = input;
        self
    }
    /// <p>Indicates whether the specified object version that was permanently deleted was (true) or was not (false) a delete marker before deletion. In a simple DELETE, this header indicates whether (true) or not (false) the current version of the object is a delete marker.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_delete_marker(&self) -> &::std::option::Option<bool> {
        &self.delete_marker
    }
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn delete_marker_version_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.delete_marker_version_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_delete_marker_version_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.delete_marker_version_id = input;
        self
    }
    /// <p>The version ID of the delete marker created as a result of the DELETE operation. If you delete a specific object version, the value returned by this header is the version ID of the object version deleted.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_delete_marker_version_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.delete_marker_version_id
    }
    /// Consumes the builder and constructs a [`DeletedObject`](crate::types::DeletedObject).
    pub fn build(self) -> crate::types::DeletedObject {
        crate::types::DeletedObject {
            key: self.key,
            version_id: self.version_id,
            delete_marker: self.delete_marker,
            delete_marker_version_id: self.delete_marker_version_id,
        }
    }
}
