// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_head_bucket_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::head_bucket::HeadBucketOutput, crate::operation::head_bucket::HeadBucketError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::head_bucket::HeadBucketError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::head_bucket::HeadBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "NotFound" => crate::operation::head_bucket::HeadBucketError::NotFound({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::NotFoundBuilder::default();
                output = crate::protocol_serde::shape_not_found::de_not_found_xml_err(_response_body, output)
                    .map_err(crate::operation::head_bucket::HeadBucketError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        _ => crate::operation::head_bucket::HeadBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_head_bucket_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::head_bucket::HeadBucketOutput, crate::operation::head_bucket::HeadBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::head_bucket::builders::HeadBucketOutputBuilder::default();
        output = output.set_access_point_alias(
            crate::protocol_serde::shape_head_bucket_output::de_access_point_alias_header(_response_headers).map_err(|_| {
                crate::operation::head_bucket::HeadBucketError::unhandled("Failed to parse AccessPointAlias from header `x-amz-access-point-alias")
            })?,
        );
        output = output.set_bucket_location_name(
            crate::protocol_serde::shape_head_bucket_output::de_bucket_location_name_header(_response_headers).map_err(|_| {
                crate::operation::head_bucket::HeadBucketError::unhandled(
                    "Failed to parse BucketLocationName from header `x-amz-bucket-location-name",
                )
            })?,
        );
        output = output.set_bucket_location_type(
            crate::protocol_serde::shape_head_bucket_output::de_bucket_location_type_header(_response_headers).map_err(|_| {
                crate::operation::head_bucket::HeadBucketError::unhandled(
                    "Failed to parse BucketLocationType from header `x-amz-bucket-location-type",
                )
            })?,
        );
        output = output.set_bucket_region(
            crate::protocol_serde::shape_head_bucket_output::de_bucket_region_header(_response_headers).map_err(|_| {
                crate::operation::head_bucket::HeadBucketError::unhandled("Failed to parse BucketRegion from header `x-amz-bucket-region")
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_head_bucket_headers(
    input: &crate::operation::head_bucket::HeadBucketInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.expected_bucket_owner {
        let formatted_2 = inner_1.as_str();
        if !formatted_2.is_empty() {
            let header_value = formatted_2;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "expected_bucket_owner",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-expected-bucket-owner", header_value);
        }
    }
    Ok(builder)
}
