// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_delete_objects_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::delete_objects::DeleteObjectsOutput, crate::operation::delete_objects::DeleteObjectsError> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::delete_objects::DeleteObjectsError::unhandled)?;
    generic_builder = crate::s3_request_id::apply_extended_request_id(generic_builder, _response_headers);
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    Err(crate::operation::delete_objects::DeleteObjectsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_delete_objects_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<crate::operation::delete_objects::DeleteObjectsOutput, crate::operation::delete_objects::DeleteObjectsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::delete_objects::builders::DeleteObjectsOutputBuilder::default();
        output = crate::protocol_serde::shape_delete_objects::de_delete_objects(_response_body, output)
            .map_err(crate::operation::delete_objects::DeleteObjectsError::unhandled)?;
        output = output.set_request_charged(
            crate::protocol_serde::shape_delete_objects_output::de_request_charged_header(_response_headers).map_err(|_| {
                crate::operation::delete_objects::DeleteObjectsError::unhandled("Failed to parse RequestCharged from header `x-amz-request-charged")
            })?,
        );
        output._set_extended_request_id(crate::s3_request_id::RequestIdExt::extended_request_id(_response_headers).map(str::to_string));
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

pub fn ser_delete_objects_headers(
    input: &crate::operation::delete_objects::DeleteObjectsInput,
    mut builder: ::http::request::Builder,
) -> std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
    if let ::std::option::Option::Some(inner_1) = &input.mfa {
        let formatted_2 = inner_1.as_str();
        if !formatted_2.is_empty() {
            let header_value = formatted_2;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "mfa",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-mfa", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_3) = &input.request_payer {
        let formatted_4 = inner_3.as_str();
        if !formatted_4.is_empty() {
            let header_value = formatted_4;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "request_payer",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-request-payer", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_5) = &input.bypass_governance_retention {
        let mut encoder = ::aws_smithy_types::primitive::Encoder::from(*inner_5);
        let formatted_6 = encoder.encode();
        if !formatted_6.is_empty() {
            let header_value = formatted_6;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "bypass_governance_retention",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-bypass-governance-retention", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_7) = &input.expected_bucket_owner {
        let formatted_8 = inner_7.as_str();
        if !formatted_8.is_empty() {
            let header_value = formatted_8;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "expected_bucket_owner",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-expected-bucket-owner", header_value);
        }
    }
    if let ::std::option::Option::Some(inner_9) = &input.checksum_algorithm {
        let formatted_10 = inner_9.as_str();
        if !formatted_10.is_empty() {
            let header_value = formatted_10;
            let header_value: ::http::HeaderValue = header_value.parse().map_err(|err| {
                ::aws_smithy_types::error::operation::BuildError::invalid_field(
                    "checksum_algorithm",
                    format!("`{}` cannot be used as a header value: {}", &header_value, err),
                )
            })?;
            builder = builder.header("x-amz-sdk-checksum-algorithm", header_value);
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn de_delete_objects(
    inp: &[u8],
    mut builder: crate::operation::delete_objects::builders::DeleteObjectsOutputBuilder,
) -> Result<crate::operation::delete_objects::builders::DeleteObjectsOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError> {
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !start_el.matches("DeleteResult") {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "encountered invalid XML root: expected DeleteResult but got {:?}. This is likely a bug in the SDK.",
            start_el
        )));
    }
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Error") /* Errors com.amazonaws.s3.synthetic#DeleteObjectsOutput$Errors */ =>  {
                let var_11 =
                    Some(
                        Result::<::std::vec::Vec::<crate::types::Error>, ::aws_smithy_xml::decode::XmlDecodeError>::Ok({
                            let mut list_12 = builder.errors.take().unwrap_or_default();
                            list_12.push(
                                crate::protocol_serde::shape_error::de_error(&mut tag)
                                ?
                            );
                            list_12
                        })
                        ?
                    )
                ;
                builder = builder.set_errors(var_11);
            }
            ,
            s if s.matches("Deleted") /* Deleted com.amazonaws.s3.synthetic#DeleteObjectsOutput$Deleted */ =>  {
                let var_13 =
                    Some(
                        Result::<::std::vec::Vec::<crate::types::DeletedObject>, ::aws_smithy_xml::decode::XmlDecodeError>::Ok({
                            let mut list_14 = builder.deleted.take().unwrap_or_default();
                            list_14.push(
                                crate::protocol_serde::shape_deleted_object::de_deleted_object(&mut tag)
                                ?
                            );
                            list_14
                        })
                        ?
                    )
                ;
                builder = builder.set_deleted(var_13);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}
