// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketPolicy`](crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder::set_bucket):<br>required: **true**<br><p>The bucket name to get the bucket policy for.</p> <p><b>Directory buckets </b> - When you use this operation with a directory bucket, you must use path-style requests in the format <code>https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must also follow the format <code> <i>bucket_base_name</i>--<i>az_id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i></p> <p><b>Access points</b> - When you use this API operation with an access point, provide the alias of the access point in place of the bucket name.</p> <p><b>Object Lambda access points</b> - When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code <code>InvalidAccessPointAliasError</code> is returned. For more information about <code>InvalidAccessPointAliasError</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.</p><note>  <p>Access points and Object Lambda access points are not supported by directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><note>  <p>For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code <code>501 Not Implemented</code>.</p> </note><br>
    /// - On success, responds with [`GetBucketPolicyOutput`](crate::operation::get_bucket_policy::GetBucketPolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::operation::get_bucket_policy::GetBucketPolicyOutput::policy): <p>The bucket policy as a JSON document.</p>
    /// - On failure, responds with [`SdkError<GetBucketPolicyError>`](crate::operation::get_bucket_policy::GetBucketPolicyError)
    pub fn get_bucket_policy(&self) -> crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder {
        crate::operation::get_bucket_policy::builders::GetBucketPolicyFluentBuilder::new(self.handle.clone())
    }
}
