// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_ice_server_config::_get_ice_server_config_output::GetIceServerConfigOutputBuilder;

pub use crate::operation::get_ice_server_config::_get_ice_server_config_input::GetIceServerConfigInputBuilder;

impl GetIceServerConfigInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_ice_server_config::GetIceServerConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_ice_server_config::GetIceServerConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_ice_server_config();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetIceServerConfig`.
///
/// <p>Gets the Interactive Connectivity Establishment (ICE) server configuration information, including URIs, username, and password which can be used to configure the WebRTC connection. The ICE component uses this configuration information to setup the WebRTC connection, including authenticating with the Traversal Using Relays around NAT (TURN) relay server.</p>
/// <p>TURN is a protocol that is used to improve the connectivity of peer-to-peer applications. By providing a cloud-based relay service, TURN ensures that a connection can be established even when one or more peers are incapable of a direct peer-to-peer connection. For more information, see <a href="https://tools.ietf.org/html/draft-uberti-rtcweb-turn-rest-00">A REST API For Access To TURN Services</a>.</p>
/// <p>You can invoke this API to establish a fallback mechanism in case either of the peers is unable to establish a direct peer-to-peer connection over a signaling channel. You must specify either a signaling channel ARN or the client ID in order to invoke this API.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetIceServerConfigFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_ice_server_config::builders::GetIceServerConfigInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_ice_server_config::GetIceServerConfigOutput,
        crate::operation::get_ice_server_config::GetIceServerConfigError,
    > for GetIceServerConfigFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_ice_server_config::GetIceServerConfigOutput,
            crate::operation::get_ice_server_config::GetIceServerConfigError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetIceServerConfigFluentBuilder {
    /// Creates a new `GetIceServerConfig`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetIceServerConfig as a reference.
    pub fn as_input(&self) -> &crate::operation::get_ice_server_config::builders::GetIceServerConfigInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_ice_server_config::GetIceServerConfigOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_ice_server_config::GetIceServerConfigError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_ice_server_config::GetIceServerConfig::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_ice_server_config::GetIceServerConfig::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_ice_server_config::GetIceServerConfigOutput,
        crate::operation::get_ice_server_config::GetIceServerConfigError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.</p>
    pub fn channel_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.channel_arn(input.into());
        self
    }
    /// <p>The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.</p>
    pub fn set_channel_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_channel_arn(input);
        self
    }
    /// <p>The ARN of the signaling channel to be used for the peer-to-peer connection between configured peers.</p>
    pub fn get_channel_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_channel_arn()
    }
    /// <p>Unique identifier for the viewer. Must be unique within the signaling channel.</p>
    pub fn client_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.client_id(input.into());
        self
    }
    /// <p>Unique identifier for the viewer. Must be unique within the signaling channel.</p>
    pub fn set_client_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_client_id(input);
        self
    }
    /// <p>Unique identifier for the viewer. Must be unique within the signaling channel.</p>
    pub fn get_client_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_client_id()
    }
    /// <p>Specifies the desired service. Currently, <code>TURN</code> is the only valid value.</p>
    pub fn service(mut self, input: crate::types::Service) -> Self {
        self.inner = self.inner.service(input);
        self
    }
    /// <p>Specifies the desired service. Currently, <code>TURN</code> is the only valid value.</p>
    pub fn set_service(mut self, input: ::std::option::Option<crate::types::Service>) -> Self {
        self.inner = self.inner.set_service(input);
        self
    }
    /// <p>Specifies the desired service. Currently, <code>TURN</code> is the only valid value.</p>
    pub fn get_service(&self) -> &::std::option::Option<crate::types::Service> {
        self.inner.get_service()
    }
    /// <p>An optional user ID to be associated with the credentials.</p>
    pub fn username(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.username(input.into());
        self
    }
    /// <p>An optional user ID to be associated with the credentials.</p>
    pub fn set_username(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_username(input);
        self
    }
    /// <p>An optional user ID to be associated with the credentials.</p>
    pub fn get_username(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_username()
    }
}
