// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A structure that encapsulates a signaling channel's metadata and properties.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ChannelInfo {
    /// <p>The name of the signaling channel.</p>
    pub channel_name: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
    pub channel_arn: ::std::option::Option<::std::string::String>,
    /// <p>The type of the signaling channel.</p>
    pub channel_type: ::std::option::Option<crate::types::ChannelType>,
    /// <p>Current status of the signaling channel.</p>
    pub channel_status: ::std::option::Option<crate::types::Status>,
    /// <p>The time at which the signaling channel was created.</p>
    pub creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub single_master_configuration: ::std::option::Option<crate::types::SingleMasterConfiguration>,
    /// <p>The current version of the signaling channel.</p>
    pub version: ::std::option::Option<::std::string::String>,
}
impl ChannelInfo {
    /// <p>The name of the signaling channel.</p>
    pub fn channel_name(&self) -> ::std::option::Option<&str> {
        self.channel_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
    pub fn channel_arn(&self) -> ::std::option::Option<&str> {
        self.channel_arn.as_deref()
    }
    /// <p>The type of the signaling channel.</p>
    pub fn channel_type(&self) -> ::std::option::Option<&crate::types::ChannelType> {
        self.channel_type.as_ref()
    }
    /// <p>Current status of the signaling channel.</p>
    pub fn channel_status(&self) -> ::std::option::Option<&crate::types::Status> {
        self.channel_status.as_ref()
    }
    /// <p>The time at which the signaling channel was created.</p>
    pub fn creation_time(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn single_master_configuration(&self) -> ::std::option::Option<&crate::types::SingleMasterConfiguration> {
        self.single_master_configuration.as_ref()
    }
    /// <p>The current version of the signaling channel.</p>
    pub fn version(&self) -> ::std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl ChannelInfo {
    /// Creates a new builder-style object to manufacture [`ChannelInfo`](crate::types::ChannelInfo).
    pub fn builder() -> crate::types::builders::ChannelInfoBuilder {
        crate::types::builders::ChannelInfoBuilder::default()
    }
}

/// A builder for [`ChannelInfo`](crate::types::ChannelInfo).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct ChannelInfoBuilder {
    pub(crate) channel_name: ::std::option::Option<::std::string::String>,
    pub(crate) channel_arn: ::std::option::Option<::std::string::String>,
    pub(crate) channel_type: ::std::option::Option<crate::types::ChannelType>,
    pub(crate) channel_status: ::std::option::Option<crate::types::Status>,
    pub(crate) creation_time: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) single_master_configuration: ::std::option::Option<crate::types::SingleMasterConfiguration>,
    pub(crate) version: ::std::option::Option<::std::string::String>,
}
impl ChannelInfoBuilder {
    /// <p>The name of the signaling channel.</p>
    pub fn channel_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.channel_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the signaling channel.</p>
    pub fn set_channel_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.channel_name = input;
        self
    }
    /// <p>The name of the signaling channel.</p>
    pub fn get_channel_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.channel_name
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
    pub fn channel_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.channel_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
    pub fn set_channel_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.channel_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the signaling channel.</p>
    pub fn get_channel_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.channel_arn
    }
    /// <p>The type of the signaling channel.</p>
    pub fn channel_type(mut self, input: crate::types::ChannelType) -> Self {
        self.channel_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>The type of the signaling channel.</p>
    pub fn set_channel_type(mut self, input: ::std::option::Option<crate::types::ChannelType>) -> Self {
        self.channel_type = input;
        self
    }
    /// <p>The type of the signaling channel.</p>
    pub fn get_channel_type(&self) -> &::std::option::Option<crate::types::ChannelType> {
        &self.channel_type
    }
    /// <p>Current status of the signaling channel.</p>
    pub fn channel_status(mut self, input: crate::types::Status) -> Self {
        self.channel_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Current status of the signaling channel.</p>
    pub fn set_channel_status(mut self, input: ::std::option::Option<crate::types::Status>) -> Self {
        self.channel_status = input;
        self
    }
    /// <p>Current status of the signaling channel.</p>
    pub fn get_channel_status(&self) -> &::std::option::Option<crate::types::Status> {
        &self.channel_status
    }
    /// <p>The time at which the signaling channel was created.</p>
    pub fn creation_time(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.creation_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time at which the signaling channel was created.</p>
    pub fn set_creation_time(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.creation_time = input;
        self
    }
    /// <p>The time at which the signaling channel was created.</p>
    pub fn get_creation_time(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.creation_time
    }
    /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn single_master_configuration(mut self, input: crate::types::SingleMasterConfiguration) -> Self {
        self.single_master_configuration = ::std::option::Option::Some(input);
        self
    }
    /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn set_single_master_configuration(mut self, input: ::std::option::Option<crate::types::SingleMasterConfiguration>) -> Self {
        self.single_master_configuration = input;
        self
    }
    /// <p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn get_single_master_configuration(&self) -> &::std::option::Option<crate::types::SingleMasterConfiguration> {
        &self.single_master_configuration
    }
    /// <p>The current version of the signaling channel.</p>
    pub fn version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The current version of the signaling channel.</p>
    pub fn set_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.version = input;
        self
    }
    /// <p>The current version of the signaling channel.</p>
    pub fn get_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.version
    }
    /// Consumes the builder and constructs a [`ChannelInfo`](crate::types::ChannelInfo).
    pub fn build(self) -> crate::types::ChannelInfo {
        crate::types::ChannelInfo {
            channel_name: self.channel_name,
            channel_arn: self.channel_arn,
            channel_type: self.channel_type,
            channel_status: self.channel_status,
            creation_time: self.creation_time,
            single_master_configuration: self.single_master_configuration,
            version: self.version,
        }
    }
}
