// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::update_data_retention::_update_data_retention_output::UpdateDataRetentionOutputBuilder;

pub use crate::operation::update_data_retention::_update_data_retention_input::UpdateDataRetentionInputBuilder;

impl UpdateDataRetentionInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::update_data_retention::UpdateDataRetentionOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_data_retention::UpdateDataRetentionError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.update_data_retention();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `UpdateDataRetention`.
///
/// <p>Increases or decreases the stream's data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the <code>Operation</code> parameter in the request body. In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>.</p>
/// <p>This operation requires permission for the <code>KinesisVideo:UpdateDataRetention</code> action.</p>
/// <p>Changing the data retention period affects the data in the stream as follows:</p>
/// <ul>
/// <li>
/// <p>If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.</p></li>
/// <li>
/// <p>If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.</p></li>
/// </ul>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct UpdateDataRetentionFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::update_data_retention::builders::UpdateDataRetentionInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::update_data_retention::UpdateDataRetentionOutput,
        crate::operation::update_data_retention::UpdateDataRetentionError,
    > for UpdateDataRetentionFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::update_data_retention::UpdateDataRetentionOutput,
            crate::operation::update_data_retention::UpdateDataRetentionError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl UpdateDataRetentionFluentBuilder {
    /// Creates a new `UpdateDataRetention`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the UpdateDataRetention as a reference.
    pub fn as_input(&self) -> &crate::operation::update_data_retention::builders::UpdateDataRetentionInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::update_data_retention::UpdateDataRetentionOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::update_data_retention::UpdateDataRetentionError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::update_data_retention::UpdateDataRetention::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::update_data_retention::UpdateDataRetention::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::update_data_retention::UpdateDataRetentionOutput,
        crate::operation::update_data_retention::UpdateDataRetentionError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl Into<crate::config::Builder>) -> Self {
        self.set_config_override(Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The name of the stream whose retention period you want to change.</p>
    pub fn stream_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.stream_name(input.into());
        self
    }
    /// <p>The name of the stream whose retention period you want to change.</p>
    pub fn set_stream_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_stream_name(input);
        self
    }
    /// <p>The name of the stream whose retention period you want to change.</p>
    pub fn get_stream_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_stream_name()
    }
    /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.stream_arn(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_stream_arn(input);
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_stream_arn()
    }
    /// <p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>
    pub fn current_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.current_version(input.into());
        self
    }
    /// <p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>
    pub fn set_current_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_current_version(input);
        self
    }
    /// <p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>
    pub fn get_current_version(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_current_version()
    }
    /// <p>Indicates whether you want to increase or decrease the retention period.</p>
    pub fn operation(mut self, input: crate::types::UpdateDataRetentionOperation) -> Self {
        self.inner = self.inner.operation(input);
        self
    }
    /// <p>Indicates whether you want to increase or decrease the retention period.</p>
    pub fn set_operation(mut self, input: ::std::option::Option<crate::types::UpdateDataRetentionOperation>) -> Self {
        self.inner = self.inner.set_operation(input);
        self
    }
    /// <p>Indicates whether you want to increase or decrease the retention period.</p>
    pub fn get_operation(&self) -> &::std::option::Option<crate::types::UpdateDataRetentionOperation> {
        self.inner.get_operation()
    }
    /// <p>The number of hours to adjust the current retention by. The value you specify is added to or subtracted from the current value, depending on the <code>operation</code>.</p>
    /// <p>The minimum value for data retention is 0 and the maximum value is 87600 (ten years).</p>
    pub fn data_retention_change_in_hours(mut self, input: i32) -> Self {
        self.inner = self.inner.data_retention_change_in_hours(input);
        self
    }
    /// <p>The number of hours to adjust the current retention by. The value you specify is added to or subtracted from the current value, depending on the <code>operation</code>.</p>
    /// <p>The minimum value for data retention is 0 and the maximum value is 87600 (ten years).</p>
    pub fn set_data_retention_change_in_hours(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_data_retention_change_in_hours(input);
        self
    }
    /// <p>The number of hours to adjust the current retention by. The value you specify is added to or subtracted from the current value, depending on the <code>operation</code>.</p>
    /// <p>The minimum value for data retention is 0 and the maximum value is 87600 (ten years).</p>
    pub fn get_data_retention_change_in_hours(&self) -> &::std::option::Option<i32> {
        self.inner.get_data_retention_change_in_hours()
    }
}
