DESCRIPTION="Xorg is a freely redistributable, open-source implementation of the X Window System."
# Xorg Build Environment
# Graphite2 is a rendering engine for graphite fonts. These are TrueType fonts with additional tables containing smart rendering information and were originally developed to support complex non-Roman writing systems. They may contain rules for e.g. ligatures, glyph substitution, kerning, justification - this can make them useful even on text written in Roman writing systems such as English. Note that firefox by default provides an internal copy of the graphite engine and cannot use a system version (although it can now be patched to use it), but it too should benefit from the availability of graphite fonts.

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=7.0

export XORG_PREFIX="/usr"

export XORG_CONFIG="--prefix=$XORG_PREFIX --sysconfdir=/etc \
    --localstatedir=/var --disable-static"

cat > /etc/profile.d/xorg.sh << EOF
XORG_PREFIX="$XORG_PREFIX"
XORG_CONFIG="--prefix=\$XORG_PREFIX --sysconfdir=/etc --localstatedir=/var --disable-static"
export XORG_PREFIX XORG_CONFIG
EOF
chmod 644 /etc/profile.d/xorg.sh

cat >> /etc/profile.d/xorg.sh << "EOF"

pathappend $XORG_PREFIX/bin             PATH
pathappend $XORG_PREFIX/lib/pkgconfig   PKG_CONFIG_PATH
pathappend $XORG_PREFIX/share/pkgconfig PKG_CONFIG_PATH

pathappend $XORG_PREFIX/lib             LIBRARY_PATH
pathappend $XORG_PREFIX/include         C_INCLUDE_PATH
pathappend $XORG_PREFIX/include         CPLUS_INCLUDE_PATH

ACLOCAL="aclocal -I $XORG_PREFIX/share/aclocal"

export PATH PKG_CONFIG_PATH ACLOCAL LIBRARY_PATH C_INCLUDE_PATH CPLUS_INCLUDE_PATH
EOF

# As root:
if [[ -d /etc/sudoers.d ]]; then
cat > /etc/sudoers.d/xorg << EOF
Defaults env_keep += XORG_PREFIX
Defaults env_keep += XORG_CONFIG
EOF
fi

source /etc/profile
source /etc/profile.d/xorg.sh

echo "$XORG_PREFIX/lib" >> /etc/ld.so.conf

sed -e "s@X11R6/man@X11R6/share/man@g" \
    -e "s@/usr/X11R6@$XORG_PREFIX@g"   \
    -i /etc/man_db.conf
	
if [[ $XORG_PREFIX != "/usr" ]]; then
	[ -h /usr/share/X11 ] && ln -svf $XORG_PREFIX/share/X11 /usr/share/X11

	[ -h /usr/X11R6 ] && ln -svf ln -svf $XORG_PREFIX /usr/X11R6
else
	[ ! -d /usr/share/X11 ] && mkdir -p /usr/share/X11
	[ ! -d /usr/X11R6 ] && mkdir -p /usr/X11R6
fi

update_version_list Xorg_Build_Env-$EXT_VERSION
