DESCRIPTION="The Xine Libraries package contains xine libraries."

EXT_VERSION=$(basename $PKG_XINE_LIB .tar.xz | cut -d "-" -f 3) 

[ -f ../$(basename $PATCH_XINE_LIB) ] && patch -Np1 -i ../$(basename $PATCH_XINE_LIB)
[ -f ../$(basename $PATCH_XINE_LIB_GCC15) ] && \
[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && \
patch -Np1 -i ../$(basename $PATCH_XINE_LIB_GCC15)

./configure --prefix=/usr          \
            --disable-vcd          \
            --with-external-dvdnav \
            --docdir=/usr/share/doc/xine-lib-$EXT_VERSION
make

doxygen doc/Doxyfile

# As root:
make install

install -v -m755 -d /usr/share/doc/xine-lib-${EXT_VERSION}/api &&
install -v -m644    doc/api/* \
                    /usr/share/doc/xine-lib-${EXT_VERSION}/api

update_version_list $PKG_XINE_LIB
