DESCRIPTION="x265 package provides a library for encoding video streams into the H.265/HEVC format."

[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5" || OPTIONS=""
[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && sed -r '/cmake_policy.*(0025|0054)/d' -i source/CMakeLists.txt

EXT_VERSION=$(basename $PKG_X265 .tar.xz | cut -d "_" -f 2) 

mkdir bld &&
cd    bld &&

cmake -D CMAKE_INSTALL_PREFIX=/usr \
      -D GIT_ARCHETYPE=1           \
      -W no-dev                    \
      $OPTIONS ../source
make

# As root:
make install &&
rm -vf /usr/lib/libx265.a

update_version_list x265-$EXT_VERSION
