DESCRIPTION="Wayland is a project to define a protocol for a compositor to talk to its clients as well as a library implementation of the protocol."

EXT_VERSION=$(basename $PKG_WAYLAND .tar.xz | cut -d "-" -f 2) 

mkdir build
cd    build

[[ $(command -v doxygen) != "" ]] && [[ $(command -v dot) != "" ]] && [[ $(command -v xmlto) != "" ]] && \
[[ $(cat /etc/extension/installed_version.list | grep docbook4_xml) != "" ]] && \
[[ $(cat /etc/extension/installed_version.list | grep docbook_xsl_nons) != "" ]] && \
[[ $(command -v xslt-config) != "" ]] && [[ $(dot -Tpng -V && echo $?) != "" ]] && \
OPTIONS="-D documentation=true" || OPTIONS="-D documentation=false"

cat /etc/extension/installed_version.list | grep docbook4_xml

meson setup ..            \
	  --prefix=/usr       \
	  --buildtype=release \
	  $OPTIONS
ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf * &&
	CC="gcc -m32" CXX="g++ -m32"         \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
	meson setup ..                       \
		  --prefix=/usr                  \
		  --libdir=/usr/lib32            \
		  --buildtype=release            \
		  -D documentation=false &&

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf * &&
	CC="gcc -mx32" CXX="g++ -mx32"       	\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	meson setup ..                       	\
		  --prefix=/usr                  	\
		  --libdir=/usr/libx32           	\
		  --buildtype=release            	\
		  -D documentation=false &&

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_WAYLAND
