DESCRIPTION="VLC is a media player, streamer, and encoder."
# VLC
# VLC is a media player, streamer, and encoder. It can play from many inputs, such as files, network streams, capture devices, desktops, or DVD, SVCD, VCD, and audio CD. It can use most audio and video codecs (MPEG 1/2/4, H264, VC-1, DivX, WMV, Vorbis, AC3, AAC, etc.), and it can also convert to different formats and/or send streams through the network. 

# Contents
# Installed Programs: cvlc, nvlc, rvlc, svlc, vlc and vlc-wrapper
# Installed Libraries: libvlccore.so, libvlc.so, and many plugins in /usr/lib/vlc/plugins
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/{include,lib,share}/vlc, /usr/share/kde4, and /usr/share/doc/vlc-3.0.21

# Short Descriptions
# cvlc - is a script to run VLC with the dummy interface
# nvlc - is a script to run VLC with the ncurses interface
# rvlc - is a script to run VLC with a command line interface
# svlc - is a script to run VLC with the skins interface
# vlc - is the VLC media player
# vlc-wrapper - is a wrapper to drop privileges with VLC

# Required
# None

# Recommended
# alsa-lib-1.2.13, desktop-file-utils-0.28, FFmpeg-7.1, liba52-0.8.0, libgcrypt-1.11.0 libmad-0.15.1b, Lua-5.4.7, and a graphical environment

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# dbus-1.16.0, libidn-1.42, and libssh2-1.11.1

# Optional input plugins
# libarchive-3.7.7, libcddb-1.3.2, libdv-1.0.0, libdvdcss-1.4.3, libdvdread-6.1.3, libdvdnav-6.1.1, opencv-4.11.0, Samba-4.21.4, v4l-utils-1.28.1, libbluray, libdc1394, libnfs, libproxy, libraw1394, Live555, and VCDImager (requires libcdio-2.1.0)

# Optional mux/demux plugins
# libogg-1.3.5, Game Music Emu, libdvbpsi, libshout, libmatroska (requires libebml), libmodplug, Musepack, and sidplay-libs

# Optional codec plugins
# FAAD2-2.11.1, FLAC-1.5.0, libaom-3.12.0, libass-0.17.3, libmpeg2-0.5.1, libpng-1.6.46, libva-2.22.0, libvorbis-1.3.7, Opus-1.5.2, Speex-1.2.1, libvpx-1.15.0, x264-20250212, aribb24, dav1d, Dirac, FluidLite, FluidSynth, libdca, libkate, libtheora, OpenMAX, Schroedinger, Shine, SoX, Tremor, Twolame, and Zapping VBI

# Optional video plugins
# AAlib-1.4rc5, Fontconfig-2.16.0, FreeType-2.13.3, FriBidi-1.0.16, libplacebo-7.349.0 (currently broken), librsvg-2.59.2, libvdpau-1.5, sdl12-compat-1.2.68, libcaca, and libmfx

# Optional audio plugins
# PulseAudio-17.0, libsamplerate-0.2.2, spatialaudio, and JACK

# Optional interface plugins
# FreeRDP-3.12.0, libtar, libvncclient, and LIRC

# Optional visualisations and video filter plugins
# Goom, libvsxu, and projectM

# Optional service discovery plugins
# Avahi-0.8, libmtp and libupnp

# Miscellaneous options
# GnuTLS-3.8.9, libnotify-0.8.4, libxml2-2.13.6, Protobuf-29.3, taglib-2.0.2, xdg-utils-1.2.1 (runtime), AtmoLight, libmicrodns, and Srt

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_VLC .tar.xz | cut -d "-" -f 2) 

[[ -f ../$(basename $PATCH_VLC_TAGLIB) ]] && patch -Np1 -i ../$(basename $PATCH_VLC_TAGLIB)
[[ -f ../$(basename $PATCH_VLC_FFMPEG) ]] && patch -Np1 -i ../$(basename $PATCH_VLC_FFMPEG)

BUILDCC=gcc ./configure --prefix=/usr --disable-libplacebo
make

# As root:
make docdir=/usr/share/doc/vlc-$EXT_VERSION install

#gtk-update-icon-cache -qtf /usr/share/icons/hicolor &&
#update-desktop-database -q

update_version_list $PKG_VLC
