DESCRIPTION="Valgrind is an instrumentation framework for building dynamic analysis tools."
# Valgrind
# Valgrind is an instrumentation framework for building dynamic analysis tools. There are Valgrind tools that can automatically detect many memory management and threading bugs, and profile programs in detail. Valgrind can also be used to build new tools. 

# Contents
# Installed Programs: callgrind_annotate, callgrind_control, cg_annotate, cg_diff, cg_merge, ms_print, valgrind, valgrind-di-server, valgrind-listener, and vgdb
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/valgrind, /usr/libexec/valgrind, /usr/include/valgrind, and /usr/share/doc/valgrind-3.24.0

# Short Descriptions
# valgrind - is a program for debugging and profiling Linux executables
# callgrind_annotate - takes an output file produced by the Valgrind tool Callgrind and prints the information in an easy-to-read form
# callgrind_control - controls programs being run by the Valgrind tool Callgrind
# cg_annotate - is a post-processing tool for the Valgrind tool Cachegrind
# cg_diff - compares two Cachegrind output files
# cg_merge - merges multiple Cachegrind output files into one
# ms_print - takes an output file produced by the Valgrind tool Massif and prints the information in an easy-to-read form
# valgrind-di-server - is a server that reads debuginfo from objects stored on a different machine
# valgrind-listener - listens on a socket for Valgrind commentary
# vgdb - is an intermediary between Valgrind and GDB or a shell

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_VALGRIND .tar.bz2 | cut -d "-" -f 2) 

sed -i 's|/doc/valgrind||' docs/Makefile.in &&

./configure --prefix=/usr \
			--enable-lto=yes \
            --datadir=/usr/share/doc/valgrind-$EXT_VERSION
make

# As root:
make install

update_version_list $PKG_VALGRIND
