DESCRIPTION="v4l-utils provides a series of utilities for media devices, allowing the ability to handle the proprietary formats available from most webcams (libv4l), and providing tools to test V4L devices."

EXT_VERSION=$(basename $PKG_V4L_UTILS .tar.xz | cut -d "-" -f 3) 

unset CPLUS_INCLUDE_PATH

# If you've installed both LLVM and libbpf (not in BLFS), either enable 
# the BPF target (via -D LLVM_TARGETS_TO_BUILD=) when building LLVM, or 
# disable the infrared remote control decoders based on BPF:

# sed -i '/^ir_bpf_enabled/s/=.*/= false/' utils/keytable/meson.build

mkdir build &&
cd    build &&

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D gconv=disabled   \
      -D doxygen-doc=disabled &&
ninja

# As root:
ninja install

for prog in v4l2gl v4l2grab
do
   cp -v contrib/test/$prog /usr/bin
done

update_version_list $PKG_V4L_UTILS
