DESCRIPTION="Unbound is a validating, recursive, and caching DNS resolver."

EXT_VERSION=$(basename $PKG_UNBOUND .tar.gz | cut -d "-" -f 2) 

[[ $(command -v event_rpcgen.py) != "" ]] && OPTION="--with-libevent" | OPTION=""

[[ $(cat /etc/group | grep unbound) == "" ]] && groupadd -g 88 unbound

[[ $(cat /etc/passwd | grep unbound:) == "" ]] && useradd -c "Unbound DNS Resolver" -d /var/lib/unbound -u 88 -g unbound -s /bin/false unbound


./configure --prefix=/usr     \
            --sysconfdir=/etc \
            --disable-static  \
            --with-pidfile=/run/unbound.pid \
			$OPTION
make

[[ $(command -v doxygen) != "" ]] && make doc

# As root:
make install &&
mv -v /usr/sbin/unbound-host /usr/bin/

install -v -m755 -d /usr/share/doc/unbound-$EXT_VERSION
install -v -m644 doc/html/* /usr/share/doc/unbound-$EXT_VERSION

update_version_list $PKG_UNBOUND
