DESCRIPTION="The Tripwire package contains programs used to verify the integrity of the files on a given system."

EXT_VERSION=$(basename $PKG_TRIPWIRE .tar.gz | cut -d "-" -f 4) 

sed -e '/^CLOBBER/s/false/true/'         \
    -e 's|TWDB="${prefix}|TWDB="/var|'   \
    -e '/TWMAN/ s|${prefix}|/usr/share|' \
    -e '/TWDOCS/s|${prefix}/doc/tripwire|/usr/share/doc/tripwire-${EXT_VERSION}|' \
    -i installer/install.cfg 

find . -name Makefile.am | xargs                           \
    sed -i 's/^[[:alpha:]_]*_HEADERS.*=/noinst_HEADERS =/'

sed '/dist/d' -i man/man?/Makefile.am 
autoreconf -fi 

./configure --prefix=/usr --sysconfdir=/etc/tripwire 
make CPPFLAGS=-std=c++11

# As root:
sed -i -e 's@installer/install.sh@& -n -s changeme -l changeme@' Makefile
sed '/-t 0/,+3d' -i installer/install.sh

make install

mkdir -p /usr/share/doc/tripwire-${EXT_VERSION}

cp -v policy/*.txt /usr/share/doc/tripwire-$EXT_VERSION

update_version_list tripwire-$EXT_VERSION
