DESCRIPTION="Tinysparql is a low-footprint RDF triple store with a SPARQL 1.1 interface."
# tinysparql
# Tinysparql is a low-footprint RDF triple store with a SPARQL 1.1 interface. 

# Contents
# Installed Programs: tinysparql
# Installed Libraries: libtinysparql-3.0.so and libtracker-sparql-3.0.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/{include,lib}/tinysparql-3.0 and /usr/share/doc/tinysparql-3.8.2 (optional)

# Short Descriptions
# tinysparql - is a control program for TinySPARQL databases
# libtinysparql-3.0.so - contains functions for administering TinySPARQL databases
# libtracker-sparql-3.0.so - contains resource management and database functions

# Required
# JSON-GLib-1.10.6 and Vala-0.56.17

# Recommended
# GLib-2.82.5 (with GObject Introspection), ICU-76.1, libsoup-3.6.4, localsearch-3.8.2 (runtime), PyGObject-3.50.0, and SQLite-3.49.1

# Recommended_Runtime
# None

# Optional
# asciidoc-10.2.1, Avahi-0.8, Graphviz-12.2.1, and bash-completion

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_TINYSPARQL .tar.xz | cut -d "-" -f 2) 

rm -fv /usr/lib/systemd/user/tracker-xdg-portal-3.service

mv docs/reference/libtracker-sparql/doc/{Tsparql-3.0,tinysparql-$EXT_VERSION}
sed '/docs_name/s/Tsparql-3.0/tinysparql-$EXT_VERSION/' \
    -i docs/reference/libtracker-sparql/meson.build

mkdir build
cd    build

meson setup --prefix=/usr       \
            --buildtype=release \
            -D man=false        \
            ..
ninja

# As root:
ninja install

update_version_list $PKG_TINYSPARQL
