DESCRIPTION="The texlive Documentation System"
# texlive

## Contents
# Installed Programs: Over 300 binaries and symlinks to scripts
# Installed Libraries: libkpathsea.so, libptexenc.so, libsynctex.so, libtexlua52.so, libtexluajit.so
# Installed Directories: $TEXLIVE_PREFIX/bin, $TEXLIVE_PREFIX/include, $TEXLIVE_PREFIX/lib, $TEXLIVE_PREFIX/texmf-dist

## Short Descriptions
# TeX programs: The programs included in TeX are too numerous to individually list. Please refer to the individual program HTML and PDF pages in the various html, man, or pdf files within the subdirectories 
#				of 2024/texmf-dist/. Using 'texdoc pdflatex' ( replace pdflatex with the command name ) may also be useful
# libkpathsea.so: (kpathsearch) exists to look up a file in a list of directories and is used by 'kpsewhich'
# libptexenc.so: is a library for Japanese pTeX (publishing TeX)
#libsynctex.so: is the SyncTeX (Synchronize TeXnology) parser library
#libtexlua52.so: provides Lua 5.2, modified for use with LuaTeX
#libtexluajit.so: provides LuaJIT, modified for use with LuaJITTeX

VERSION_EXT=$(basename $PKG_TEXLIVE .tar.xz | cut -d "-" -f 2) 

export TEXARCH=$(uname -m | sed -e 's/i.86/i386/' -e 's/$/-linux/')

cat > /etc/profile.d/texlive.sh << EOF
# Begin texlive setup
TEXLIVE_PREFIX=/opt/texlive/2025
export TEXLIVE_PREFIX

pathappend \$TEXLIVE_PREFIX/texmf-dist/doc/info INFOPATH
pathappend \$TEXLIVE_PREFIX/bin/$TEXARCH

TEXMFCNF=\$TEXLIVE_PREFIX/texmf-dist/web2c
export TEXMFCNF

# End texlive setup
EOF

source /etc/profile

[ -f ../$(basename $PATCH_TEXLIVE) ] && patch -Np1 -i ../$(basename $PATCH_TEXLIVE)

mkdir texlive-build
cd    texlive-build

# echo "####################################"
# echo " texlive_min=$texlive_min"
# echo "####################################"

GCC15=""
[[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ]] && GCC15="gcc -std=gnu17"

[[ $ALLOW_GRAPHICS == false ]] && XORG_OPTION="--without-x" || XORG_OPTION=""
#fatal error: X11/Xlib.h: No such file or directory

../configure CC="$GCC15" -C                       \
    --prefix=$TEXLIVE_PREFIX                      \
    --bindir=$TEXLIVE_PREFIX/bin/$TEXARCH         \
    --datarootdir=$TEXLIVE_PREFIX                 \
    --includedir=$TEXLIVE_PREFIX/include          \
    --infodir=$TEXLIVE_PREFIX/texmf-dist/doc/info \
    --libdir=$TEXLIVE_PREFIX/lib                  \
    --mandir=$TEXLIVE_PREFIX/texmf-dist/doc/man   \
    --disable-native-texlive-build                \
    --disable-static --enable-shared              \
    --disable-dvisvgm                             \
    --with-system-cairo                           \
    --with-system-fontconfig                      \
    --with-system-freetype2                       \
    --with-system-gmp                             \
    --with-system-graphite2                       \
    --with-system-harfbuzz                        \
    --with-system-icu                             \
    --with-system-libgs                           \
    --with-system-libpaper                        \
    --with-system-libpng                          \
    --with-system-mpfr                            \
    --with-system-pixman                          \
    --with-system-zlib $XORG_OPTION               \
    --with-banner-add=" - Portholes"

make

if $RUN_TESTS
then
    set +e
    make -k check
    set -e
fi

# As root:
make install-strip

# Only run make texlinks once. If it is rerun, it can change all the program symlinks so that they point to themselves and are useless.
[ ! -f /etc/extension/texlive_texlinks ] && make texlinks && touch /etc/extension/texlive_texlinks

mkdir -pv                                $TEXLIVE_PREFIX/tlpkg/TeXLive/
install -v -m644 ../texk/tests/TeXLive/* $TEXLIVE_PREFIX/tlpkg/TeXLive/

# Now install the additional files as the root user:
tar -xf ../../$(basename $PKG_TEXLIVE_TLPDB) -C $TEXLIVE_PREFIX/tlpkg --strip-components=2

tar -xf ../../$(basename $PKG_TEXLIVE_TEXMF) -C $TEXLIVE_PREFIX --strip-components=1

# Still as the root user, initialize the new system (the command fmtutil-sys --all will produce a lot of output):
mktexlsr
fmtutil-sys --all

# To allow Evince-46.3.1 or dvisvgm-3.4 to link to libkpathsea.so, as the root user (re)create a symlink from /usr/lib:
ln -svf $TEXLIVE_PREFIX/lib/libkpathsea.so{,.6} /usr/lib

update_version_list $PKG_TEXLIVE
