echo "# $EXTENSION/build_order.txt" 				 	 > $EXTENSION/build_order.txt
echo "# <scriptname> (without .sh)" 					>> $EXTENSION/build_order.txt
echo "" 												>> $EXTENSION/build_order.txt

source /etc/profile

# Required
[[ $(command -v libpng-config) == "" ]] && echo "Installing libpng" && extension --install libpng && echo "Finished libpng"
# Recommended
if [[ $INSTALL_RECOMMENDED != false ]]; then 
	[[ $(command -v cairo-trace) == "" ]] && echo "Installing cairo" && extension --install cairo && echo "Finished cairo"
	[[ $(command -v fc-list) == "" ]] && echo "Installing fontconfig" && extension --install fontconfig && echo "Finished fontconfig"
	[[ $(command -v freetype-config) == "" ]] && echo "Installing freetype" && extension --install freetype && echo "Finished freetype"
	[ ! -f /lib/libgc.so ] && echo "Installing gc" && extension --install gc && echo "Finished gc"
	[[ $(command -v gr2fonttest) == "" ]] && echo "Installing graphite2" && extension --install graphite2 && echo "Finished graphite2"
	[[ $(hb-info --version | grep graphite2) == "" ]] && echo "Installing harfbuzz" && extension --install harfbuzz && echo "Finished harfbuzz"
	[[ $(command -v derb) == "" ]] && echo "Installing icu" && extension --install icu && echo "Finished icu"
	[[ $(command -v paper) == "" ]] && echo "Installing libpaper" && extension --install libpaper && echo "Finished libpaper"
	[[ $(command -v pngfix) == "" ]] && echo "Installing libpng" && extension --install libpng && echo "Finished libpng"
	[[ $(command -v cairo-trace) == "" ]] && echo "Installing cairo" && extension --install cairo && echo "Finished cairo"
	[ ! -f /lib/libpixman-1.so ] && echo "Installing pixman" && extension --install pixman && echo "Finished pixman"
fi
# Graphics
if [[ $ALLOW_GRAPHICS != false ]]; then 
	[ ! -f /lib/libX11.so ] && echo "Installing libx11" && extension --install libx11  && echo "Finished libx11"
	[ ! -f /lib/libXaw.so ] && echo "Installing libxaw" && extension --install libxaw && echo "Finished libxaw"
fi

if [[ $BUILD_ALL == "false" ]] && [[ $(command -v texdoc) == "" ]]; then
	echo "texlive" 										>> $EXTENSION/build_order.txt
fi
if [[ $BUILD_ALL == "true" ]]; then
	echo "texlive" 										>> $EXTENSION/build_order.txt
fi
echo "complete _" 										>> $EXTENSION/build_order.txt
