DESCRIPTION="The texlive Documentation System"

VERSION_EXT=$(basename $PKG_TEXLIVE .tar.xz | cut -d "-" -f 2) 

sed -e '182 s/internal_font_number/boolean/' \
    -e '301 s/internal_font_number/boolean/' \
    -i texk/web2c/pdftexdir/pdftex.ch

export TEXARCH=$(uname -m | sed -e 's/i.86/i386/' -e 's/$/-linux/')

cat > /etc/profile.d/texlive.sh << EOF
# Begin texlive setup
TEXLIVE_PREFIX=/opt/texlive/2024
export TEXLIVE_PREFIX

pathappend \$TEXLIVE_PREFIX/texmf-dist/doc/info INFOPATH
pathappend \$TEXLIVE_PREFIX/bin/$TEXARCH

TEXMFCNF=\$TEXLIVE_PREFIX/texmf-dist/web2c
export TEXMFCNF

# End texlive setup
EOF

source /etc/profile

[[ -f ../$(basename $PATCH_TEXLIVE) ]] && patch -Np1 -i ../$(basename $PATCH_TEXLIVE)

mkdir texlive-build
cd    texlive-build

echo "####################################"
echo " texlive_min=$texlive_min"
echo "####################################"

[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && CC="gcc -std=gnu17"

[[ $ALLOW_GRAPHICS == false ]] && XORG_OPTION="--without-x" || XORG_OPTION=""
# if [[ $(command -v doxygen) == "" ]]; then
# ../configure -C                                   \
    # --prefix=$TEXLIVE_PREFIX                      \
    # --bindir=$TEXLIVE_PREFIX/bin/$TEXARCH         \
    # --datarootdir=$TEXLIVE_PREFIX                 \
    # --includedir=$TEXLIVE_PREFIX/include          \
    # --infodir=$TEXLIVE_PREFIX/texmf-dist/doc/info \
    # --libdir=$TEXLIVE_PREFIX/lib                  \
    # --mandir=$TEXLIVE_PREFIX/texmf-dist/doc/man   \
    # --disable-native-texlive-build                \
    # --disable-static								\
	# --enable-shared								\
    # --disable-dvisvgm								\
	# --disable-xdvik	
# fi
# if [[ $(command -v doxygen) != "" ]]; then
../configure CC="$CC" -C							\
    --prefix=$TEXLIVE_PREFIX						\
    --bindir=$TEXLIVE_PREFIX/bin/$TEXARCH			\
    --datarootdir=$TEXLIVE_PREFIX					\
    --includedir=$TEXLIVE_PREFIX/include			\
    --infodir=$TEXLIVE_PREFIX/texmf-dist/doc/info	\
    --libdir=$TEXLIVE_PREFIX/lib					\
    --mandir=$TEXLIVE_PREFIX/texmf-dist/doc/man		\
    --disable-native-texlive-build					\
    --disable-static 								\
	--enable-shared									\
    --disable-dvisvgm								\
    --with-system-cairo								\
    --with-system-fontconfig						\
    --with-system-freetype2							\
    --with-system-gmp								\
    --with-system-graphite2							\
    --with-system-harfbuzz							\
    --with-system-icu								\
    --with-system-libgs								\
    --with-system-libpaper							\
    --with-system-libpng							\
    --with-system-mpfr								\
    --with-system-pixman							\
    --with-system-zlib $XORG_OPTION					\
    --with-banner-add=" - Portals"
# [ -f /etc/extension/texlive_min ] && texlive_min=false 
# fi

make

if $RUN_TESTS
then
    set +e
    make -k check
    set -e
fi

# As root:
make install-strip

# Only run make texlinks once. If it is rerun, it can change all the program symlinks so that they point to themselves and are useless.
[ ! -f /etc/extension/texlive_texlinks ] && make texlinks && touch /etc/extension/texlive_texlinks

mkdir -pv                                $TEXLIVE_PREFIX/tlpkg/TeXLive/
install -v -m644 ../texk/tests/TeXLive/* $TEXLIVE_PREFIX/tlpkg/TeXLive/

# Now install the additional files as the root user:
tar -xf ../../$(basename $PKG_TEXLIVE_TLPDB) -C $TEXLIVE_PREFIX/tlpkg --strip-components=2

tar -xf ../../$(basename $PKG_TEXLIVE_TEXMF) -C $TEXLIVE_PREFIX --strip-components=1

# Still as the root user, initialize the new system (the command fmtutil-sys --all will produce a lot of output):
mktexlsr
fmtutil-sys --all

# To allow Evince-46.3.1 or dvisvgm-3.4 to link to libkpathsea.so, as the root user (re)create a symlink from /usr/lib:
ln -svf $TEXLIVE_PREFIX/lib/libkpathsea.so{,.6} /usr/lib

# [ $texlive_min == "true" ] && touch /etc/extension/texlive_min

# [ $texlive_min == "false" ] && [ -f /etc/extension/texlive_min ] && rm /etc/extension/texlive_min

update_version_list $PKG_TEXLIVE
