DESCRIPTION="The SystemD system utilities"

EXT_VERSION=$(basename $PKG_SYSTEMD .tar.gz | cut -d "-" -f 2) 

sed -i -e 's/GROUP="render"/GROUP="video"/' \
       -e 's/GROUP="sgx", //' rules.d/50-udev-default.rules.in

mkdir build &&
cd    build &&

meson setup ..                 \
      --prefix=/usr            \
      --buildtype=release      \
      -D default-dnssec=no     \
      -D firstboot=false       \
      -D install-tests=false   \
      -D ldconfig=false        \
      -D man=auto              \
      -D sysusers=false        \
      -D rpmmacrosdir=no       \
      -D homed=disabled        \
      -D userdb=false          \
      -D mode=release          \
      -D pam=enabled           \
      -D pamconfdir=/etc/pam.d \
      -D dev-kvm-mode=0660     \
      -D nobody-group=nogroup  \
      -D sysupdate=disabled    \
      -D ukify=disabled        \
      -D docdir=/usr/share/doc/systemd-$EXT_VERSION

ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf * &&
	LANG=en_US.UTF-8                     \
	meson setup --cross-file lib32       \
				--prefix=/usr            \
				--libdir=/usr/lib32      \
				--buildtype=release      \
				-D default-dnssec=no     \
				-D firstboot=false       \
				-D install-tests=false   \
				-D ldconfig=false        \
				-D man=disabled          \
				-D sysusers=false        \
				-D rpmmacrosdir=no       \
				-D homed=disabled        \
				-D userdb=false          \
				-D mode=release          \
				-D pam=enabled           \
				-D pamconfdir=/etc/pam.d \
				.. &&

	LANG=en_US.UTF-8 ninja

	LANG=en_US.UTF-8 DESTDIR=$PWD/DESTDIR ninja install          &&
	cp -vR DESTDIR/usr/lib32/security       /usr/lib32           &&
	cp -va DESTDIR/usr/lib32/libsystemd.so* /usr/lib32           &&
	cp -va DESTDIR/usr/lib32/libudev.so*    /usr/lib32           &&
	cp -v  DESTDIR/usr/lib32/pkgconfig/*    /usr/lib32/pkgconfig &&
	rm -rf DESTDIR
fi
if $MULTILIB_X32
then
	rm -rf * &&
	LANG=en_US.UTF-8                     \
	meson setup --cross-file libx32      \
				--prefix=/usr            \
				--libdir=/usr/libx32     \
				--buildtype=release      \
				-D default-dnssec=no     \
				-D firstboot=false       \
				-D install-tests=false   \
				-D ldconfig=false        \
				-D man=disabled          \
				-D sysusers=false        \
				-D rpmmacrosdir=no       \
				-D homed=disabled        \
				-D userdb=false          \
				-D mode=release          \
				-D pam=enabled           \
				-D pamconfdir=/etc/pam.d \
				.. &&

	LANG=en_US.UTF-8 ninja

	LANG=en_US.UTF-8 DESTDIR=$PWD/DESTDIR ninja install
	cp -vR DESTDIR/usr/libx32/security       /usr/libx32 
	cp -va DESTDIR/usr/libx32/libsystemd.so* /usr/libx32
	cp -va DESTDIR/usr/libx32/libudev.so*    /usr/libx32 
	cp -v  DESTDIR/usr/libx32/pkgconfig/*    /usr/libx32/pkgconfig
	rm -rf DESTDIR
fi

update_version_list $PKG_SYSTEMD
