DESCRIPTION="The SQLite package is a software library that implements a self-contained, serverless, zero-configuration, transactional SQL database engine."

EXT_VERSION=$(basename $PKG_SQLITE .tar.xz | cut -d "-" -f 3)

$(pkg-config libarchive --exists) && unzip -q ../$(basename $DOCS_SQLITE)

./configure --prefix=/usr     \
            --disable-static  \
            --enable-fts{4,5} \
            CPPFLAGS="-D SQLITE_ENABLE_COLUMN_METADATA=1 \
                      -D SQLITE_ENABLE_UNLOCK_NOTIFY=1   \
                      -D SQLITE_ENABLE_DBSTAT_VTAB=1     \
                      -D SQLITE_SECURE_DELETE=1"
make

# As root:
make install

install -v -m755 -d /usr/share/doc/sqlite-$EXT_VERSION
[ -d $(basename $DOCS_SQLITE .zip) ] && cp -v -R $(basename $DOCS_SQLITE .zip)/* /usr/share/doc/sqlite-$EXT_VERSION

if $MULTILIB
then
	make distclean 
	CC="gcc -m32" CXX="g++ -m32"         \
	./configure --prefix=/usr            \
				--libdir=/usr/lib32      \
				--host=i686-pc-linux-gnu \
				--disable-static         \
				--enable-fts{4,5}        \
				CPPFLAGS="-D SQLITE_ENABLE_COLUMN_METADATA=1 \
						  -D SQLITE_ENABLE_UNLOCK_NOTIFY=1   \
						  -D SQLITE_ENABLE_DBSTAT_VTAB=1     \
						  -D SQLITE_SECURE_DELETE=1"
	make LDFLAGS.rpath=""
	make DESTDIR=$PWD/DESTDIR install
	cp -Rv DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	./configure --prefix=/usr					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32	\
				--disable-static         		\
				--enable-fts{4,5}        		\
				CPPFLAGS="-D SQLITE_ENABLE_COLUMN_METADATA=1 \
						  -D SQLITE_ENABLE_UNLOCK_NOTIFY=1   \
						  -D SQLITE_ENABLE_DBSTAT_VTAB=1     \
						  -D SQLITE_SECURE_DELETE=1"
	make LDFLAGS.rpath=""
	make DESTDIR=$PWD/DESTDIR install
	cp -Rv DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 	
fi

update_version_list sqlite-$EXT_VERSION
