DESCRIPTION="The SPIRV-Tools package contains libraries and utilities for processing SPIR-V modules."
# SPIRV-Tools
# The SPIRV-Tools package contains libraries and utilities for processing SPIR-V modules.

# Contents
# Installed Programs: spirv-as, spirv-cfg, spirv-dis, spirv-lesspipe.sh, spirv-link, spirv-lint, spirv-objdump, spirv-opt, spirv-reduce, and spirv-val
# Installed Libraries: libSPIRV-Tools-diff.so, libSPIRV-Tools-link.so, libSPIRV-Tools-lint.so, libSPIRV-Tools-opt.so, libSPIRV-Tools-reduce.so, libSPIRV-Tools-shared.so, and libSPIRV-Tools.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/spirv-tools and /usr/lib/cmake/SPIRV-Tools

# Short Descriptions
# spirv-as - creates a SPIR-V binary module from SPIR-V assembly text
# spirv-cfg - shows the control flow graph in "dot" format
# spirv-dis - disassembles a SPIR-V binary module
# spirv-lesspipe.sh - automatically disassembles a .SPV file for 'less'
# spirv-link - links SPIR-V binary files together
# spirv-lint - checks a SPIR-V binary module for errors
# spirv-objdump - dumps information from a SPIR-V binary
# spirv-opt - performs optimizations on SPIR-V binary files
# spirv-reduce - reduces a SPIR-V binary file
# spirv-val - validates a SPIR-V binary file
# libSPIRV-Tools.so - contains functions for processing SPIR-V modules

# Required
# CMake-3.31.6 and SPIRV-Headers-1.4.304.1

# Recommended
# None

# Optional
# None

EXT_VERSION=$(basename $PKG_SPIRV_TOOLS .tar.gz | cut -d "-" -f 5)

mkdir build &&
cd    build &&

cmake -D CMAKE_INSTALL_PREFIX=/usr     \
      -D CMAKE_BUILD_TYPE=Release      \
      -D SPIRV_WERROR=OFF              \
      -D BUILD_SHARED_LIBS=ON          \
      -D SPIRV_TOOLS_BUILD_STATIC=OFF  \
      -D SPIRV-Headers_SOURCE_DIR=/usr \
      -G Ninja .. &&
ninja

ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"           \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig   \
	cmake -D CMAKE_INSTALL_PREFIX=/usr     \
		  -D CMAKE_INSTALL_LIBDIR=lib32    \
		  -D CMAKE_BUILD_TYPE=Release      \
		  -D SPIRV_WERROR=OFF              \
		  -D BUILD_SHARED_LIBS=ON          \
		  -D SPIRV_TOOLS_BUILD_STATIC=OFF  \
		  -D SPIRV-Headers_SOURCE_DIR=/usr \
		  -G Ninja ..
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"         \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig  \
	cmake -D CMAKE_INSTALL_PREFIX=/usr     \
		  -D CMAKE_INSTALL_LIBDIR=libx32   \
		  -D CMAKE_BUILD_TYPE=Release      \
		  -D SPIRV_WERROR=OFF              \
		  -D BUILD_SHARED_LIBS=ON          \
		  -D SPIRV_TOOLS_BUILD_STATIC=OFF  \
		  -D SPIRV-Headers_SOURCE_DIR=/usr \
		  -G Ninja ..

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list spirv_tools-$EXT_VERSION
