DESCRIPTION="The SPIRV-LLVM-Translator package contains a library and utility for converting between LLVM IR and SPIR-V code."

EXT_VERSION=$(basename $PKG_SPIRV_LLVM_TRANSLATOR .tar.gz | cut -d "-" -f 4) 

mkdir build &&
cd    build &&

cmake -D CMAKE_INSTALL_PREFIX=/usr                   \
      -D CMAKE_BUILD_TYPE=Release                    \
      -D BUILD_SHARED_LIBS=ON                        \
      -D CMAKE_SKIP_INSTALL_RPATH=ON                 \
      -D LLVM_EXTERNAL_SPIRV_HEADERS_SOURCE_DIR=/usr \
      -G Ninja ..                                    &&
ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"            \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	cmake -D CMAKE_INSTALL_PREFIX=/usr                   \
		  -D CMAKE_INSTALL_LIBDIR=lib32                  \
		  -D CMAKE_BUILD_TYPE=Release                    \
		  -D CMAKE_SKIP_INSTALL_RPATH=ON                 \
		  -D BUILD_SHARED_LIBS=ON                        \
		  -D LLVM_EXTERNAL_SPIRV_HEADERS_SOURCE_DIR=/usr \
		  -G Ninja ..
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"          \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	cmake -D CMAKE_INSTALL_PREFIX=/usr                   \
		  -D CMAKE_INSTALL_LIBDIR=libx32                 \
		  -D CMAKE_BUILD_TYPE=Release                    \
		  -D CMAKE_SKIP_INSTALL_RPATH=ON                 \
		  -D BUILD_SHARED_LIBS=ON                        \
		  -D LLVM_EXTERNAL_SPIRV_HEADERS_SOURCE_DIR=/usr \
		  -G Ninja ..
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list spirv_llvm_translator-$EXT_VERSION
