DESCRIPTION="Speex is an audio compression format designed specifically for speech."
# Speex
# Speex is an audio compression format designed specifically for speech. It is well-adapted to internet applications and provides useful features that are not present in most other CODECs. 

# Contents
# Installed Programs: speexenc and speexdec
# Installed Libraries: libspeex.so and libspeexdsp.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/speex and /usr/share/doc/speex-1.2.1

# Short Descriptions
# speexdec - decodes a Speex file and produces a WAV or raw file
# speexenc - encodes a WAV or raw file using Speex
# libspeex.so - provides functions for the audio encoding/decoding programs
# libspeexdsp.so - is a speech processing library that goes along with the Speex codec

# Required
# libogg-1.3.5

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# Valgrind-3.24.0

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_SPEEX .tar.gz | cut -d "-" -f 2) 
EXT_VERSION2=$(basename $PKG_SPEEXDSP .tar.gz | cut -d "-" -f 2) 

mkdir build
cd    build

../configure --prefix=/usr    \
            --disable-static \
            --docdir=/usr/share/doc/speex-$EXT_VERSION
make

# As root:
make install

tar -xf ../../$(basename $PKG_SPEEXDSP)
push speexdsp-$EXT_VERSION2 

./configure --prefix=/usr    \
            --disable-static \
            --docdir=/usr/share/doc/speexdsp-$EXT_VERSION2
make
make install

cd ..
rm -r speexdsp-$EXT_VERSION2

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--disable-static
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32	\
				--disable-static
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_SPEEX
