DESCRIPTION="The Sharutils package contains utilities that can create 'shell' archives."

EXT_VERSION=$(basename $PKG_SHARUTILS .tar.xz | cut -d "-" -f 2) 

[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && patch -Np1 -i ../$(basename $PATCH_SHARUTILS)

if [ $(gcc -dumpversion | cut -d "." -f 1) == 10 ]; then
	sed -i 's/BUFSIZ/rw_base_size/' src/unshar.c &&
	sed -i '/program_name/s/^/extern /' src/*opts.h

	sed -i 's/IO_ftrylockfile/IO_EOF_SEEN/' lib/*.c        &&
	echo "#define _IO_IN_BACKUP 0x100" >> lib/stdio-impl.h &&

	./configure --prefix=/usr 
fi

if [ $(gcc -dumpversion | cut -d "." -f 1) == 15 ]; then
	autoreconf -fiv 
	./configure --prefix=/usr 					\
				--disable-dependency-tracking	\
				--with-openssl
fi

make

# As root:
make install

update_version_list $PKG_SHARUTILS
