DESCRIPTION="The SGML Common package contains install-catalog. This is useful for creating and maintaining centralized SGML catalogs."

EXT_VERSION=$(basename $PKG_SGML_COMMON .tgz | cut -d "-" -f 3) 

[ -f ../$(basename $PATCH_SGML_COMMON) ] && patch -Np1 -i ../$(basename $PATCH_SGML_COMMON)
autoreconf -f -i

./configure --prefix=/usr --sysconfdir=/etc
make

# As root:
if [ -f /usr/share/sgml/sgml-iso-entities-8879.1986/catalog ]]; then
	install-catalog --remove /etc/sgml/sgml-ent.cat \
		/usr/share/sgml/sgml-iso-entities-8879.1986/catalog
fi
if [ -f /etc/sgml/sgml-ent.cat ]; then
	install-catalog --remove /etc/sgml/sgml-docbook.cat \
		/etc/sgml/sgml-ent.cat
fi

make docdir=/usr/share/doc install

install-catalog --add /etc/sgml/sgml-ent.cat \
    /usr/share/sgml/sgml-iso-entities-8879.1986/catalog

install-catalog --add /etc/sgml/sgml-docbook.cat \
    /etc/sgml/sgml-ent.cat

update_version_list $PKG_SGML_COMMON
