DESCRIPTION="The Simple DirectMedia Layer Version 2 (SDL2 for short) is a cross-platform library designed to make it easy to write multimedia software, such as games and emulators."
# SDL2
# The Simple DirectMedia Layer Version 2 (SDL2 for short) is a cross-platform library designed to make it easy to write multimedia software, such as games and emulators. 

# Contents
# Installed Programs: sdl2-config
# Installed Libraries: libSDL2.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/SDL2, /usr/lib/cmake/SDL2, and /usr/share/doc/SDL-2.30.11

# Short Descriptions
# sdl2-config - determines the compile and linker flags that should be used to compile and link programs that use libSDL2
# libSDL2.so - contains functions that provide low level access to audio, keyboard, mouse, joystick, 3D hardware via OpenGL, and the 2D frame buffer across multiple platforms

# Required
# None

# Recommended
# libxkbcommon-1.8.0, wayland-protocols-1.40, and Xorg Libraries (if those are not present, the corresponding modules are not built)

# Recommended_Runtime
# None

# Optional
# alsa-lib-1.2.13, Doxygen-1.13.2 (to create documentation), ibus-1.5.31, libsamplerate-0.2.2, libunwind-1.8.1, NASM-2.16.03, pipewire-1.2.7, PulseAudio-17.0, a graphical environment, DirectFB, fcitx, jack, and sndio

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_SDL2 .tar.gz | cut -d "-" -f 2) 

./configure --prefix=/usr &&
make

if [[ $(command -v doxygen) ]]; then
	pushd docs  &&
	  doxygen   &&
	popd
fi

# As root:
make install              &&
rm -v /usr/lib/libSDL2*.a

update_version_list $PKG_SDL2
