DESCRIPTION="Screen is a terminal multiplexor that runs several separate processes, typically interactive shells, on a single physical character-based terminal."

EXT_VERSION=$(basename $PKG_SCREEN .tar.gz | cut -d "-" -f 2) 

[[ $(command -v pam_namespace_helper) == "" ]] && OPTION="--disable-pam" | OPTION=""

./configure --prefix=/usr                        \
            --infodir=/usr/share/info            \
            --mandir=/usr/share/man              \
            $OPTION                        \
            --enable-socket-dir=/run/screen      \
            --with-pty-group=5                   \
            --with-system_screenrc=/etc/screenrc &&

sed -i -e "s%/usr/local/etc/screenrc%/etc/screenrc%" {etc,doc}/* &&
make

# As root:
make install &&
install -m 644 etc/etcscreenrc /etc/screenrc

update_version_list $PKG_SCREEN
