DESCRIPTION="SANE is short for Scanner Access Now Easy. Scanner access, however, is far from easy, since every vendor has their own protocols."

[[ $(cat /etc/group | grep scanner) == "" ]] && groupadd -g 70 scanner
usermod -G scanner -a root

EXT_VERSION=$(basename $PKG_SANE .tar.gz | cut -d "-" -f 3) 

OPTIONS=""
[[ $(pkg-config libusb-1.0 --modversion) != "" ]] && OPTIONS="--enable-libusb_1_0"

sg scanner -c "                                 \
PYTHON=python3 ./configure --prefix=/usr        \
                           --sysconfdir=/etc    \
                           --localstatedir=/var \
                           --with-lockdir=/run/lock \
                           --docdir=/usr/share/doc/sane-backends-${EXT_VERSION}"
make

# As root:
make install
install -m 644 -v tools/udev/libsane.rules           \
                  /etc/udev/rules.d/65-scanner.rules
mkdir -p          /run/lock/sane
chgrp -v scanner  /run/lock/sane

if [ ! -f /etc/sane.d/net.conf ]; then
cat >> /etc/sane.d/net.conf << "EOF"
connect_timeout = 60
<server_ip>
EOF
fi

update_version_list $PKG_SANE
