DESCRIPTION="The Rust programming language is designed to be a safe, concurrent, practical language."

EXT_VERSION=$(basename $PKG_RUSTC -src.tar.xz | cut -d "-" -f 2)

mkdir -pv /opt/rustc-$EXT_VERSION 
ln -svfn rustc-$EXT_VERSION /opt/rustc

source /etc/os-release

if [ ! $MULTILIB ]
then
cat << EOF > config.toml
# See bootstrap.toml.example for more possible options,
# and see src/bootstrap/defaults/bootstrap.dist.toml for a few options
# automatically set when building from a release tarball
# (unfortunately, we have to override many of them).

# Tell x.py the editors have reviewed the content of this file
# and updated it to follow the major changes of the building system,
# so x.py will not warn us to do such a review.
change-id = 142379

[llvm]
# When using system llvm prefer shared libraries
link-shared = true

# If building the shipped LLVM source, only enable the x86 target
# instead of all the targets supported by LLVM.
targets = "X86"

[build]
description = "for $VERSION_ID"

# Omit docs to save time and space (default is to build them).
docs = false

# Do not query new versions of dependencies online.
locked-deps = true

# Specify which extended tools (those from the default install).
tools = ["cargo", "clippy", "rustdoc", "rustfmt"]

[install]
prefix = "/opt/rustc-1.89.0"
docdir = "share/doc/rustc-1.89.0"

[rust]
channel = "stable"

# Enable the same optimizations as the official upstream build.
lto = "thin"
codegen-units = 1

# Don't build lld which does not belong to this package and seems not
# so useful for BLFS.  Even if it turns out to be really useful we'd build
# it as a part of the LLVM package instead.
lld = false

# Don't build llvm-bitcode-linker which is only useful for the NVPTX
# backend that we don't enable.
llvm-bitcode-linker = false

[target.x86_64-unknown-linux-gnu]
llvm-config = "/usr/bin/llvm-config"

[target.i686-unknown-linux-gnu]
llvm-config = "/usr/bin/llvm-config"
EOF
fi

if [ $MULTILIB ] && [ ! $MULTILIB_X32 ]
then
cat > bootstrap.toml << "EOF" &&
# See bootstrap.toml.example for more possible options,
# and see src/bootstrap/defaults/bootstrap.dist.toml for a few options
# automatically set when building from a release tarball.
# We have to override a decent number of them.

# Tell x.py the editors have reviewed the content of this file
# and updated it to follow the major changes of the building system,
# so x.py will not warn us to do such a review.
change-id = 142379

[llvm]
# When using system llvm prefer shared libraries
link-shared = true

EOF
if [ ! -f /usr/lib32/libc.so.6 ]; then
cat >> bootstrap.toml << "EOF"
# If building the shipped LLVM source, only enable the x86 target
# instead of all the targets supported by LLVM.
targets = "X86"

EOF
fi
cat >> bootstrap.toml << "EOF"
[build]
description = "for GLFS 12.4"
EOF
if [ -f /usr/lib32/libc.so.6 ]; then
cat >> bootstrap.toml << "EOF"
target = [
  "x86_64-unknown-linux-gnu",
  "i686-unknown-linux-gnu",
]
EOF
fi &&
cat >> bootstrap.toml << "EOF" &&

# omit docs to save time and space (default is to build them)
docs = false

# Do not query new versions of dependencies online.
locked-deps = true

# Specify which extended tools (those from the default install).
tools = ["cargo", "clippy", "rustdoc", "rustfmt"]

[install]
prefix = "/opt/rustc-1.89.0"
docdir = "share/doc/rustc-1.89.0"

[rust]
channel = "stable"

# Uncomment if FileCheck has been installed.
#codegen-tests = false

# Disable the need for lld.
lld = false

# If you didn't build in NVPTX support, you can uncomment this.
#llvm-bitcode-linker = false

# Enable the same optimizations as the official upstream build.
lto = "thin"
codegen-units = 1

EOF
if [ -f /usr/lib32/libc.so.6 ]; then
cat >> bootstrap.toml << "EOF"
[target.x86_64-unknown-linux-gnu]
cc = "/usr/bin/gcc"
cxx = "/usr/bin/g++"
ar = "/usr/bin/gcc-ar"
ranlib = "/usr/bin/gcc-ranlib"
llvm-config = "/usr/bin/llvm-config"

[target.i686-unknown-linux-gnu]
cc = "/usr/bin/gcc"
cxx = "/usr/bin/g++"
ar = "/usr/bin/gcc-ar"
ranlib = "/usr/bin/gcc-ranlib"
EOF
else
cat >> bootstrap.toml << "EOF"
[target.x86_64-unknown-linux-gnu]
llvm-config = "/usr/bin/llvm-config"

[target.i686-unknown-linux-gnu]
llvm-config = "/usr/bin/llvm-config"
EOF
fi
fi

[ ! -e /usr/include/libssh2.h ] || export LIBSSH2_SYS_USE_PKG_CONFIG=1
[ ! -e /usr/include/sqlite3.h ] || export LIBSQLITE3_SYS_USE_PKG_CONFIG=1
./x.py build

# ./x.py test --verbose --no-fail-fast | tee rustc-testlog

# grep '^test result:' rustc-testlog |
# awk '{sum1 += $4; sum2 += $6} END { print sum1 " passed; " sum2 " failed" }'

./x.py install

rm -fv /opt/rustc-$EXT_VERSION/share/doc/rustc-$EXT_VERSION/*.old   &&
install -vm644 README.md                                \
               /opt/rustc-$EXT_VERSION/share/doc/rustc-$EXT_VERSION &&

install -vdm755 /usr/share/zsh/site-functions      &&
ln -sfv /opt/rustc/share/zsh/site-functions/_cargo \
        /usr/share/zsh/site-functions

mv -v /etc/bash_completion.d/cargo /usr/share/bash-completion/completions

unset LIB{SSH2,SQLITE3}_SYS_USE_PKG_CONFIG

cat > /etc/profile.d/rustc.sh << "EOF"
# Begin /etc/profile.d/rustc.sh

pathprepend /opt/rustc/bin           PATH

# End /etc/profile.d/rustc.sh
EOF

source /etc/profile.d/rustc.sh

update_version_list rustc-$EXT_VERSION
