DESCRIPTION="The rust-bindgen package contains a utility that generates Rust bindings from C_C++ headers."
# rust-bindgen
# The rust-bindgen package contains a utility that generates Rust bindings from C/C++ headers.

# Contents
# Installed Programs: bindgen
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# bindgen - generates bindings for Rust from C/C++ headers

# Required
# rustc-1.85.0 and LLVM-19.1.7 (with Clang, runtime)

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

#EXT_VERSION=$(basename $PKG_RUST_BINDGEN .tar.gz | cut -d "-" -f 3) 
EXT_VERSION="0.72.1"

source /etc/profile.d/rustc.sh

if [[ $(ping -c 1 8.8.8.8 | grep "Destination Net Unreachable") == "" ]]; then
	cargo build --release
else
	rm -r *
	curl -LO https://repo.dillonsociety.com/pub/DSLsq/portholes/rust_bindgen-$EXT_VERSION-offline.tar.gz
	tar -xvf rust_bindgen-$EXT_VERSION-offline.tar.gz --strip-components=1
	cargo build --release --offline
fi

# cargo test --release

# As root:
install -v -m755 target/release/bindgen /usr/bin

bindgen --generate-shell-completions bash \
    > /usr/share/bash-completion/completions/bindgen
bindgen --generate-shell-completions zsh  \
    > /usr/share/zsh/site-functions/_bindgen

rm ../$(basename $PKG_RUST_BINDGEN)

update_version_list rust_bindgen-$EXT_VERSION
