DESCRIPTION="The rsync package contains the rsync utility. This is useful for synchronizing large file archives over a network."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_RSYNC .tar.gz | cut -d "-" -f 2) 

[[ $(cat /etc/group | grep rsyncd:) == "" ]] && groupadd -g 48 rsyncd
[[ $(cat /etc/passwd | grep rsyncd:) == "" ]] && useradd -c "rsyncd Daemon" -m -d /home/rsync -g rsyncd -s /bin/false -u 48 rsyncd

./configure --prefix=/usr    \
            --disable-xxhash \
            --without-included-zlib
make

[[ $(command -v doxygen) != "" ]] && MAKE_DOC=true && doxygen

# As root:
make install

if [[ $MAKE_DOC == "true" ]]; then
	install -v -m755 -d          /usr/share/doc/rsync-${EXT_VERSION}/api
	install -v -m644 dox/html/*  /usr/share/doc/rsync-${EXT_VERSION}/api
fi

update_version_list $PKG_RSYNC
