DESCRIPTION="QtWebEngine integrates chromium's web capabilities into Qt."

EXT_VERSION=$(basename $PKG_QTWEBENGINE .tar.gz | cut -d "-" -f 4) 

[ -f ../$(basename $PATCH_QTWEBENGINE) ] && patch -Np1 -i ../$(basename $PATCH_QTWEBENGINE)

# pushd src/3rdparty/chromium/third_party/webrtc/modules &&

  # sed -e "88 s/proxy_/reinterpret_cast<pw_node*>(&)/"       \
      # -e "120s/that->proxy_/reinterpret_cast<pw_node*>(&)/" \
      # -i video_capture/linux/pipewire_session.cc            &&

# popd

mkdir build
cd    build

cmake -D CMAKE_MESSAGE_LOG_LEVEL=STATUS             \
      -D QT_FEATURE_webengine_system_ffmpeg=ON      \
      -D QT_FEATURE_webengine_system_icu=ON         \
      -D QT_FEATURE_webengine_system_libevent=ON    \
      -D QT_FEATURE_webengine_proprietary_codecs=ON \
      -D QT_FEATURE_webengine_webrtc_pipewire=ON    \
      -D QT_BUILD_EXAMPLES_BY_DEFAULT=OFF           \
      -D QT_GENERATE_SBOM=OFF                       \
      -G Ninja ..
ninja

# As root:
ninja install

update_version_list $PKG_QTWEBENGINE

# WebEngine Repository Build Options:
  # Build Gn ............................... yes
  # Jumbo Build ............................ yes
  # Developer build ........................ no
  # Build QtWebEngine Modules:
    # Build QtWebEngineCore ................ yes
    # Build QtWebEngineWidgets ............. yes
    # Build QtWebEngineQuick ............... yes
  # Build QtPdf Modules:
    # Build QtPdfWidgets ................... yes
    # Build QtPdfQuick ..................... yes
  # Optional system libraries:
    # re2 .................................. no
    # webengine_system_icu ................. yes
    # libwebp, libwebpmux and libwebpdemux . yes
    # opus ................................. yes
    # webengine_system_ffmpeg .............. yes
    # libvpx ............................... no
    # snappy ............................... no
    # glib ................................. yes
    # zlib ................................. yes
    # minizip .............................. no
    # webengine_system_libevent ............ yes
    # libxml2 and libxslt .................. yes
    # lcms2 ................................ yes
    # png .................................. yes
    # tiff ................................. yes
    # jpeg ................................. yes
    # libopenjpeg2 ......................... yes
    # harfbuzz ............................. yes
    # freetype ............................. yes
    # libpci ............................... yes
    # libudev .............................. yes
# Qt WebEngineCore:
  # Embedded build ......................... no
  # Full debug information ................. no
  # Sanitizer support ...................... no
  # Pepper Plugins ......................... yes
  # Printing and PDF ....................... yes
  # webengine_proprietary_codecs ........... yes
  # Spellchecker ........................... yes
  # WebRTC ................................. yes
  # webengine_webrtc_pipewire .............. yes
  # Geolocation ............................ yes
  # WebChannel support ..................... yes
  # Kerberos Authentication ................ no
  # Extensions ............................. yes
  # Support X11 on qpa-xcb ................. yes
  # Vulkan support ......................... yes
  # VA-API support ......................... yes
  # Use ALSA ............................... yes
  # Use PulseAudio ......................... yes
  # Use v8 context snapshot ................ yes
  # Build WebEngineDriver .................. yes
# Qt WebEngineQuick:
  # UI Delegates ........................... yes
# Qt PDF:
  # Support V8 ............................. no
  # Support XFA ............................ no
  # Support XFA-BMP ........................ no
  # Support XFA-GIF ........................ no
  # Support XFA-PNG ........................ no
  # Support XFA-TIFF ....................... no
  # Bitcode support ........................ no
  # Use static runtime ..................... no
