DESCRIPTION="QtWebEngine integrates chromium's web capabilities into Qt."

EXT_VERSION=$(basename $PKG_QTWEBENGINE .tar.gz | cut -d "-" -f 4) 

[ -f ../$(basename $PATCH_QTWEBENGINE) ] && patch -Np1 -i ../$(basename $PATCH_QTWEBENGINE)

# pushd src/3rdparty/chromium/third_party/webrtc/modules &&

  # sed -e "88 s/proxy_/reinterpret_cast<pw_node*>(&)/"       \
      # -e "120s/that->proxy_/reinterpret_cast<pw_node*>(&)/" \
      # -i video_capture/linux/pipewire_session.cc            &&

# popd

mkdir build
cd    build

cmake -D CMAKE_MESSAGE_LOG_LEVEL=STATUS             \
      -D QT_FEATURE_webengine_system_ffmpeg=ON      \
      -D QT_FEATURE_webengine_system_icu=ON         \
      -D QT_FEATURE_webengine_system_libevent=ON    \
      -D QT_FEATURE_webengine_proprietary_codecs=ON \
      -D QT_FEATURE_webengine_webrtc_pipewire=ON    \
      -D QT_BUILD_EXAMPLES_BY_DEFAULT=OFF           \
      -D QT_GENERATE_SBOM=OFF                       \
      -G Ninja ..
ninja

# As root:
ninja install

update_version_list $PKG_QTWEBENGINE
