DESCRIPTION="Qt6 is a cross-platform application framework that is widely used for developing application software with a graphical user interface (GUI) (in which cases Qt6 is classified as a widget toolkit), and also used for developing non-GUI programs such as command-line tools and consoles for servers."

EXT_VERSION=$(basename $PKG_QT .tar.xz | cut -d "-" -f 4)

source /etc/profile
LC_ALL=C.UTF-8
unset CPLUS_INCLUDE_PATH

[ -d /opt/qt-$EXT_VERSION ] && rm -r /opt/qt-$EXT_VERSION
mkdir -pv /opt/qt-$EXT_VERSION
[ -h /opt/qt6 ] && unlink /opt/qt6
ln -sfnv qt-$EXT_VERSION /opt/qt6

export QT6PREFIX=/opt/qt6

[ -f ../$(basename $PATCH_QT) ] && patch -Np1 -i ../$(basename $PATCH_QT)

if [ "$(uname -m)" == "i686" ]; then
    sed -e "/^#elif defined(Q_CC_GNU_ONLY)/s/.*/& \&\& 0/" \
         -i qtbase/src/corelib/global/qtypes.h &&
    export CXXFLAGS+="-DDISABLE_SIMD -DPFFFT_SIMD_DISABLE"
fi

./configure -prefix $QT6PREFIX      \
            -sysconfdir /etc/xdg    \
            -dbus-linked            \
            -openssl-linked         \
            -system-sqlite          \
            -nomake examples        \
            -no-rpath               \
            -syslog                 \
            -skip qt3d              \
            -skip qtquick3dphysics  \
            -skip qtwebengine		\
			-D docs=enable		\
			#-pulseaudio				\
			#-alsa					\
			#-gstreamer				\
			#-no-opengl
			
# Works:
# ./configure -prefix $QT6PREFIX -skip qtwebview -skip qtdatavis3d -skip qt3d -skip qtwebengine -skip qtcharts -skip qtactiveqt -skip qtwayland -no-opengl
ninja

ninja install

find $QT6PREFIX/ -name \*.prl \
   -exec sed -i -e '/^QMAKE_PRL_BUILD_DIR/d' {} \;

pushd qttools/src

install -v -Dm644 assistant/assistant/images/assistant-128.png       \
                  /usr/share/pixmaps/assistant-qt6.png

install -v -Dm644 designer/src/designer/images/designer.png          \
                  /usr/share/pixmaps/designer-qt6.png

install -v -Dm644 linguist/linguist/images/icons/linguist-128-32.png \
                  /usr/share/pixmaps/linguist-qt6.png

install -v -Dm644 qdbus/qdbusviewer/images/qdbusviewer-128.png       \
                  /usr/share/pixmaps/qdbusviewer-qt6.png
popd


cat > /usr/share/applications/assistant-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Assistant
Comment=Shows Qt6 documentation and examples
Exec=$QT6PREFIX/bin/assistant
Icon=assistant-qt6.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;Documentation;
EOF

cat > /usr/share/applications/designer-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Designer
GenericName=Interface Designer
Comment=Design GUIs for Qt6 applications
Exec=$QT6PREFIX/bin/designer
Icon=designer-qt6.png
MimeType=application/x-designer;
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;
EOF

cat > /usr/share/applications/linguist-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Linguist
Comment=Add translations to Qt6 applications
Exec=$QT6PREFIX/bin/linguist
Icon=linguist-qt6.png
MimeType=text/vnd.trolltech.linguist;application/x-linguist;
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;
EOF

cat > /usr/share/applications/qdbusviewer-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 QDbusViewer
GenericName=D-Bus Debugger
Comment=Debug D-Bus applications
Exec=$QT6PREFIX/bin/qdbusviewer
Icon=qdbusviewer-qt6.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;Debugger;
EOF

# If sudoers is installed
mkdir -p /etc/sudoers.d
cat > /etc/sudoers.d/qt << "EOF"
Defaults env_keep += QT6DIR
EOF

cat > /etc/ld.so.conf.d/qt.conf << EOF
# Begin Qt addition

/opt/qt6/lib

# End Qt addition
EOF

ldconfig

cat > /etc/profile.d/qt6.sh << "EOF"
# Begin /etc/profile.d/qt6.sh

QT6DIR=/opt/qt6

pathappend $QT6DIR/bin           PATH
pathappend $QT6DIR/lib/pkgconfig PKG_CONFIG_PATH

export QT6DIR

# End /etc/profile.d/qt6.sh
EOF

#/opt/qt6/bin/qt-configure-module

update_version_list qt-$EXT_VERSION

[[ $(command -v qcatool-qt6) != "" ]] && echo "Installing qca" && extension --install qca --rebuild && echo "Finished qca"
[ -f /lib/libQCoro6Core.so ] && echo "Installing qcoro" && extension --install qcoro --rebuild && echo "Finished qcoro"
[[ $(command -v sddm) != "" ]] && echo "Installing sddm" && extension --install sddm --rebuild && echo "Finished sddm"
