DESCRIPTION="Qt6 is a cross-platform application framework that is widely used for developing application software with a graphical user interface (GUI) (in which cases Qt6 is classified as a widget toolkit), and also used for developing non-GUI programs such as command-line tools and consoles for servers."
# qt
# Qt6 is a cross-platform application framework that is widely used for developing application software with a graphical user interface (GUI) (in which cases Qt6 is classified as a widget toolkit), and also used for developing non-GUI programs such as command-line tools and consoles for servers.

# Contents
# Installed Programs: androiddeployqt (hard link to androiddeployqt6), androiddeployqt6, androidtestrunner, assistant, balsam, balsamui, canbusutil, designer, instancer, lconvert, linguist, lrelease, lupdate, materialeditor, meshdebug, pixeltool, qdbus, qdbuscpp2xml, qdbusviewer, qdbusxml2cpp, qdistancefieldgenerator, qdoc, qmake (hard link to qmake6), qmake6, qml, qmldom, qmleasing, qmlformat, qmllint, qmlls, qmlplugindump, qmlpreview, qmlprofiler, qmlscene, qmltc, qmltestrunner, qmltime, qopcuaxmldatatypes2cpp, qqem, qsb, qtdiag (hard link to qtdiag6), qtdiag6, qtpaths (hard link to qtpaths6), qtpaths6, qtplugininfo, qt-cmake, qt-cmake-create, qt-configure-module, shadergen, shapegen, and svg2xml
# Installed Libraries: libQt6Bluetooth.so, libQt6Bodymovin.so, libQt6BundledEmbree.a, libQt6BundledOpenXR.a, libQt6BundledResonanceAudio.a, libQt6Charts.so, libQt6ChartsQml.so, libQt6Coap.so, libQt6Concurrent.so, libQt6Core.so, libQt6Core5Compat.so, libQt6DBus.so, libQt6DataVisualization.so, libQt6DataVisualizationQml.so, libQt6DeclarativeOpcua.so, libQt6Designer.so, libQt6DesignerComponents.so, libQt6DeviceDiscoverySupport.a, libQt6EglFSDeviceIntegration.so, libQt6EglFsKmsGbmSupport.so, libQt6EglFsKmsSupport.so, libQt6ExampleIcons.a, libQt6ExamplesAssetDownloader.a, libQt6FbSupport.a, libQt6Graphs.so, libQt6GraphsWidgets.so, libQt6Grpc.so, libQt6GrpcQuick.so, libQt6Gui.so, libQt6Help.so, libQt6HttpServer.so, libQt6InputSupport.a, libQt6JsonRpc.so, libQt6KmsSupport.a, libQt6LabsAnimation.so, libQt6LabsFolderListModel.so, libQt6LabsPlatform.so, libQt6LabsQmlModels.so, libQt6LabsSettings.so, libQt6LabsSharedImage.so, libQt6LabsWavefrontMesh.so, libQt6LanguageServer.a, libQt6Location.so, libQt6Mqtt.so, libQt6Multimedia.so, libQt6MultimediaQuick.so, libQt6MultimediaTestLib.a, libQt6MultimediaWidgets.so, libQt6Network.so, libQt6NetworkAuth.so, libQt6Nfc.so, libQt6OpcUa.so, libQt6OpenGL.so, libQt6OpenGLWidgets.so, libQt6PacketProtocol.a, libQt6Positioning.so, libQt6PositioningQuick.so, libQt6PrintSupport.so, libQt6Protobuf.so, libQt6ProtobufQtCoreTypes.so, libQt6ProtobufQtGuiTypes.so, libQt6ProtobufQuick.so, libQt6ProtobufWellKnownTypes.so, libQt6QGstreamerMediaPluginImpl.a, libQt6Qml.so, libQt6QmlAssetDownloader.a, libQt6QmlCompiler.so, libQt6QmlCore.so, libQt6QmlDebug.a, libQt6QmlDom.a, libQt6QmlLocalStorage.so, libQt6QmlLS.a, libQt6QmlMeta.so, libQt6QmlModels.so, libQt6QmlNetwork.so, libQt6QmlToolingSettings.a, libQt6QmlTypeRegistrar.a, libQt6QmlWorkerScript.so, libQt6QmlXmlListModel.so, libQt6Quick.so, libQt6Quick3D.so, libQt6Quick3DAssetImport.so, libQt6Quick3DAssetUtils.so, libQt6Quick3DEffects.so, libQt6Quick3DGlslParser.so, libQt6Quick3DHelpers.so, libQt6Quick3DHelpersImpl.so, libQt6Quick3DIblBaker.so, libQt6Quick3DParticleEffects.so, libQt6Quick3DParticles.so, libQt6Quick3DRuntimeRender.so, libQt6Quick3DSpatialAudio.so, libQt6Quick3DUtils.so, libQt6Quick3DXr.so, libQt6QuickControls2.so, libQt6QuickControls2Basic.so, libQt6QuickControls2BasicStyleImpl.so, libQt6QuickControls2FluentWinUI3StyleImpl.so, libQt6QuickControls2Fusion.so, libQt6QuickControls2FusionStyleImpl.so, libQt6QuickControls2Imagine.so, libQt6QuickControls2ImagineStyleImpl.so, libQt6QuickControls2Impl.so, libQt6QuickControls2Material.so, libQt6QuickControls2MaterialStyleImpl.so, libQt6QuickControls2Universal.so, libQt6QuickControls2UniversalStyleImpl.so, libQt6QuickControlsTestUtils.a, libQt6QuickDialogs2.so, libQt6QuickDialogs2QuickImpl.so, libQt6QuickDialogs2Utils.so, libQt6QuickEffects.so, libQt6QuickLayouts.so, libQt6QuickParticles.so, libQt6QuickShapes.so, libQt6QuickTemplates2.so, libQt6QuickTimelineBlendTrees.so, libQt6QuickTest.so, libQt6QuickTestUtils.a, libQt6QuickTimeline.so, libQt6QuickVectorImageGenerator.so, libQt6QuickVectorImage.so, libQt6QuickWidgets.so, libQt6RemoteObjects.so, libQt6RemoteObjectsQml.so, libQt6Scxml.so, libQt6ScxmlQml.so, libQt6Sensors.so, libQt6SensorsQuick.so, libQt6SerialBus.so, libQt6SerialPort.so, libQt6ShaderTools.so, libQt6SpatialAudio.so, libQt6Sql.so, libQt6StateMachine.so, libQt6StateMachineQml.so, libQt6Svg.so, libQt6SvgWidgets.so, libQt6Test.so, libQt6TextToSpeech.so, libQt6UiTools.so, libQt6VirtualKeyboard.so, libQt6VirtualKeyboardSettings.so, libQt6WaylandClient.so, libQt6WaylandCompositor.so, libQt6WaylandCompositorIviapplication.so, libQt6WaylandCompositorPresentationTime.so, libQt6WaylandCompositorWLShell.so, libQt6WaylandCompositorXdgShell.so, libQt6WaylandEglClientHwIntegration.so, libQt6WaylandEglCompositorHwIntegration.so, libQt6WebChannel.so, libQt6WebChannelQuick.so, libQt6WebSockets.so, libQt6WebView.so, libQt6WebViewQuick.so, libQt6Widgets.so, libQt6WlShellIntegration.so, libQt6XcbQpa.so, and libQt6Xml.so
# Installed Directory: /opt/qt6 and /opt/qt-6.8.2

# Short Descriptions
# assistant - is a tool for presenting on-line documentation
# balsam - is a tool to convert 3D scenes from various creation tools to QML format, for use by the new QtQuick 3D library
# canbustil - is a tool to deal with arbitrary CAN bus frames. A Controller Area Network (CAN) is a vehicle bus standard designed to allow microcontrollers and devices to communicate with each other in applications without a host computer
# designer - is a full-fledged GUI builder. It includes powerful features such as preview mode, automatic widget layout, support for custom widgets, and an advanced property editor
# lconvert - is part of Qt6's Linguist tool chain. It can be used as a standalone tool to convert and filter translation data files
# linguist - provides support for translating applications into local languages
# lrelease - is a simple command line tool. It reads XML-based translation files in TS format and produces message files used by the application
# lupdate - finds the translatable strings in the specified source, header and Qt Designer interface files, and stores the extracted messages in translation files to be processed by lrelease
# meshdebug - displays information about qtquick-3d mesh files
# pixeltool - is a desktop magnifier - as you move your mouse around the screen, it will show the magnified contents in its window
# qdbus - lists available services, object paths, methods, signals, and properties of objects on a bus
# qdbuscpp2xml - takes a C++ source file and generates a D-Bus XML definition of the interface
# qdbusviewer - is a graphical D-Bus browser
# qdbusxml2cpp - is a tool that can be used to parse interface descriptions and produce static code representing those interfaces,
# qdistancefieldgenerator - allows a font cache to be pregenerated for Text.QtRendering to speed up an application's startup if the user interface has a lot of text, or multiple fonts, or a large amount of distinct characters, e.g. in CJK writing systems
# qdoc - is a tool used by Qt Developers to generate documentation for software projects
# qmake - uses information stored in project files to determine what should go in the makefiles it generates
# qml - executes a QML file
# qmleasing - is a tool used to define the easing curves using an interactive curve editor
# qmlformat - formats QML files according to the QML coding conventions
# qmllint - is a syntax checker for QML files
# qmlplugindump - is a tool to create a qmltypes file
# qmlpreview - is a tool used to analyze QML applications
# qmlprofiler - is a tool which watches QML and JavaScript files on disk and updates the application live with any changes
# qmlscene - is a utility that loads and displays QML documents even before the application is complete
# qmltestrunner - is a tool used to make tests
# qtdiag - is a tool for reporting diagnostic information about Qt and its environment
# qtpaths - is a tool to query Qt path information
# qtplugininfo - dumps meta-data about Qt plugins in JSON format

# Required
# Xorg Libraries

# Recommended
# alsa-lib-1.2.13, make-ca-1.15, Cups-2.4.11, double-conversion-3.3.1, GLib-2.84.0, gst-plugins-base-1.24.12 (QtMultimedia backend), harfBuzz-10.4.0, ICU-76.1, jasper-4.2.4, libjpeg-turbo-3.0.1, libinput-1.27.1, libmng-2.0.3, libpng-1.6.47, libtiff-4.7.0, libwebp-1.5.0, libxkbcommon-1.8.0, Mesa-25.0.1, mtdev-1.1.7, pcre2-10.45, SQLite-3.49.1, Wayland-1.23.0 (Mesa must be built with Wayland EGL backend), and XCB Utilities

# Optional
# BlueZ-5.79 (for sdpscanner, and at runtime for QtConnectivity module), GTK-3.24.49, ibus-1.5.31, LLVM-19.1.7 (with Clang), MariaDB-11.4.5 or MySQL, MIT Kerberos V5-1.21.3, pciutils-3.13.0, PostgreSQL-17.4, PulseAudio-17.0, SDL2-2.30.11, unixODBC-2.3.12, assimp, Flite, Firebird, FreeTDS, libproxy, OpenAL, speech-dispatcher, and tslib

EXT_VERSION=$(basename $PKG_QT .tar.xz | cut -d "-" -f 4)

#LC_ALL=C.UTF-8

[ -d /opt/qt-$EXT_VERSION ] && rm -r /opt/qt-$EXT_VERSION
mkdir -pv /opt/qt-$EXT_VERSION
[ -h /opt/qt6 ] && unlink /opt/qt6
ln -sfnv qt-$EXT_VERSION /opt/qt6

export QT6PREFIX=/opt/qt6

if [ "$(uname -m)" == "i686" ]; then
    sed -e "/^#elif defined(Q_CC_GNU_ONLY)/s/.*/& \&\& 0/" \
        -i qtbase/src/corelib/global/qtypes.h
fi

./configure -prefix $QT6PREFIX      \
            -sysconfdir /etc/xdg    \
            -dbus-linked            \
            -openssl-linked         \
            -system-sqlite          \
            -nomake examples        \
            -no-rpath               \
            -journald               \
            -skip qt3d              \
            -skip qtquick3dphysics  \
            -skip qtwebengine		\
			-D docs=enable		\
			#-pulseaudio				\
			#-alsa					\
			#-gstreamer				\
			#-no-opengl
			
# Works:
# ./configure -prefix $QT6PREFIX -skip qtwebview -skip qtdatavis3d -skip qt3d -skip qtwebengine -skip qtcharts -skip qtactiveqt -skip qtwayland -no-opengl
ninja

ninja install

find $QT6PREFIX/ -name \*.prl \
   -exec sed -i -e '/^QMAKE_PRL_BUILD_DIR/d' {} \;

pushd qttools/src &&

install -v -Dm644 assistant/assistant/images/assistant-128.png       \
                  /usr/share/pixmaps/assistant-qt6.png               &&

install -v -Dm644 designer/src/designer/images/designer.png          \
                  /usr/share/pixmaps/designer-qt6.png                &&

install -v -Dm644 linguist/linguist/images/icons/linguist-128-32.png \
                  /usr/share/pixmaps/linguist-qt6.png                &&

install -v -Dm644 qdbus/qdbusviewer/images/qdbusviewer-128.png       \
                  /usr/share/pixmaps/qdbusviewer-qt6.png             &&
popd &&


cat > /usr/share/applications/assistant-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Assistant
Comment=Shows Qt6 documentation and examples
Exec=$QT6PREFIX/bin/assistant
Icon=assistant-qt6.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;Documentation;
EOF

cat > /usr/share/applications/designer-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Designer
GenericName=Interface Designer
Comment=Design GUIs for Qt6 applications
Exec=$QT6PREFIX/bin/designer
Icon=designer-qt6.png
MimeType=application/x-designer;
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;
EOF

cat > /usr/share/applications/linguist-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 Linguist
Comment=Add translations to Qt6 applications
Exec=$QT6PREFIX/bin/linguist
Icon=linguist-qt6.png
MimeType=text/vnd.trolltech.linguist;application/x-linguist;
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;
EOF

cat > /usr/share/applications/qdbusviewer-qt6.desktop << EOF
[Desktop Entry]
Name=Qt6 QDbusViewer
GenericName=D-Bus Debugger
Comment=Debug D-Bus applications
Exec=$QT6PREFIX/bin/qdbusviewer
Icon=qdbusviewer-qt6.png
Terminal=false
Encoding=UTF-8
Type=Application
Categories=Qt;Development;Debugger;
EOF

# If sudoers is installed
#cat > /etc/sudoers.d/qt << "EOF"
#Defaults env_keep += QT6DIR
#EOF

cat > /etc/ld.so.conf.d/qt.conf << EOF
# Begin Qt addition

/opt/qt6/lib

# End Qt addition
EOF

ldconfig

cat > /etc/profile.d/qt6.sh << "EOF"
# Begin /etc/profile.d/qt6.sh

QT6DIR=/opt/qt6

pathappend $QT6DIR/bin           PATH
pathappend $QT6DIR/lib/pkgconfig PKG_CONFIG_PATH

export QT6DIR

# End /etc/profile.d/qt6.sh
EOF

#/opt/qt6/bin/qt-configure-module

update_version_list qt-$EXT_VERSION

[[ $(command -v qcatool-qt6) != "" ]] && echo "Rebuilding Qca" && extension --install Qca --rebuild && echo "Finished Qca"
[ -f /lib/libQCoro6Core.so ] && echo "Rebuilding qcoro" && extension --install qcoro --rebuild && echo "Finished qcoro"
