DESCRIPTION="The Python 3 package contains the Python development environment."

EXT_VERSION=$(basename $PKG_PYTHON3 .tar.xz | cut -d "-" -f 2) 

./configure --prefix=/usr          \
            --enable-shared        \
            --with-system-expat    \
            --enable-optimizations \
            --without-static-libpython
make

# As root:
make install

install -v -dm755 /usr/share/doc/python-${EXT_VERSION}/html

tar --strip-components=1  \
    --no-same-owner       \
    --no-same-permissions \
    -C /usr/share/doc/python-${EXT_VERSION}/html \
    -xvf ../$(basename $DOC_PYTHON3) 

[ -h /usr/share/doc/python-3 ] && unlink /usr/share/doc/python-3
ln -svfn python-3.13.7 /usr/share/doc/python-3

if [[ $(cat /etc/profile | grep "export PYTHONDOCS=/usr/share/doc/python-3/html") == "" ]]; then
	echo "export PYTHONDOCS=/usr/share/doc/python-3/html" >> /etc/profile
fi

update_version_list $PKG_PYTHON3
