DESCRIPTION="Python bindings for the QT6 cross-platform application and UI framework"

EXT_VERSION=$(basename $PKG_PYSIDE6 .zip | cut -d "-" -f 2) 

LIBCLANG_PATH=/usr/lib

[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5" || OPTIONS=""

unzip ../$(basename $PKG_PYSIDE6)
cd $(basename $PKG_PYSIDE6 .zip)

[ -f ../../$(basename $PATCH_PYSIDE6) ] && patch -Np1 -i ../../$(basename $PATCH_PYSIDE6) CMakeLists.txt

mkdir build
cd build

cmake -W no-dev $OPTIONS ..
make

# As root:
make install

update_version_list pyside6-$EXT_VERSION
